/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.medialive.model.InputSecurityGroupState;
import software.amazon.awssdk.services.medialive.model.InputWhitelistRule;
import software.amazon.awssdk.services.medialive.model.TagsCopier;
import software.amazon.awssdk.services.medialive.model.___listOfInputWhitelistRuleCopier;
import software.amazon.awssdk.services.medialive.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InputSecurityGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InputSecurityGroup> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InputSecurityGroup.getter(InputSecurityGroup::arn)).setter(InputSecurityGroup.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InputSecurityGroup.getter(InputSecurityGroup::id)).setter(InputSecurityGroup.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<List<String>> INPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(InputSecurityGroup.getter(InputSecurityGroup::inputs)).setter(InputSecurityGroup.setter(Builder::inputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InputSecurityGroup.getter(InputSecurityGroup::stateAsString)).setter(InputSecurityGroup.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(InputSecurityGroup.getter(InputSecurityGroup::tags)).setter(InputSecurityGroup.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<InputWhitelistRule>> WHITELIST_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(InputSecurityGroup.getter(InputSecurityGroup::whitelistRules)).setter(InputSecurityGroup.setter(Builder::whitelistRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("whitelistRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputWhitelistRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD, INPUTS_FIELD, STATE_FIELD, TAGS_FIELD, WHITELIST_RULES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String id;
    private final List<String> inputs;
    private final String state;
    private final Map<String, String> tags;
    private final List<InputWhitelistRule> whitelistRules;

    private InputSecurityGroup(BuilderImpl builder) {
        this.arn = builder.arn;
        this.id = builder.id;
        this.inputs = builder.inputs;
        this.state = builder.state;
        this.tags = builder.tags;
        this.whitelistRules = builder.whitelistRules;
    }

    public String arn() {
        return this.arn;
    }

    public String id() {
        return this.id;
    }

    public List<String> inputs() {
        return this.inputs;
    }

    public InputSecurityGroupState state() {
        return InputSecurityGroupState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public List<InputWhitelistRule> whitelistRules() {
        return this.whitelistRules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputs());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.whitelistRules());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputSecurityGroup)) {
            return false;
        }
        InputSecurityGroup other = (InputSecurityGroup)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.inputs(), other.inputs()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.whitelistRules(), other.whitelistRules());
    }

    public String toString() {
        return ToString.builder((String)"InputSecurityGroup").add("Arn", (Object)this.arn()).add("Id", (Object)this.id()).add("Inputs", this.inputs()).add("State", (Object)this.stateAsString()).add("Tags", this.tags()).add("WhitelistRules", this.whitelistRules()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Inputs": {
                return Optional.ofNullable(clazz.cast(this.inputs()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "WhitelistRules": {
                return Optional.ofNullable(clazz.cast(this.whitelistRules()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputSecurityGroup, T> g) {
        return obj -> g.apply((InputSecurityGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String id;
        private List<String> inputs = DefaultSdkAutoConstructList.getInstance();
        private String state;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private List<InputWhitelistRule> whitelistRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InputSecurityGroup model) {
            this.arn(model.arn);
            this.id(model.id);
            this.inputs(model.inputs);
            this.state(model.state);
            this.tags(model.tags);
            this.whitelistRules(model.whitelistRules);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Collection<String> getInputs() {
            return this.inputs;
        }

        @Override
        public final Builder inputs(Collection<String> inputs) {
            this.inputs = ___listOf__stringCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(String ... inputs) {
            this.inputs(Arrays.asList(inputs));
            return this;
        }

        public final void setInputs(Collection<String> inputs) {
            this.inputs = ___listOf__stringCopier.copy(inputs);
        }

        public final String getStateAsString() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(InputSecurityGroupState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        public final Collection<InputWhitelistRule.Builder> getWhitelistRules() {
            return this.whitelistRules != null ? (Collection)this.whitelistRules.stream().map(InputWhitelistRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder whitelistRules(Collection<InputWhitelistRule> whitelistRules) {
            this.whitelistRules = ___listOfInputWhitelistRuleCopier.copy(whitelistRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder whitelistRules(InputWhitelistRule ... whitelistRules) {
            this.whitelistRules(Arrays.asList(whitelistRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder whitelistRules(Consumer<InputWhitelistRule.Builder> ... whitelistRules) {
            this.whitelistRules(Stream.of(whitelistRules).map(c -> (InputWhitelistRule)((InputWhitelistRule.Builder)InputWhitelistRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setWhitelistRules(Collection<InputWhitelistRule.BuilderImpl> whitelistRules) {
            this.whitelistRules = ___listOfInputWhitelistRuleCopier.copyFromBuilder(whitelistRules);
        }

        public InputSecurityGroup build() {
            return new InputSecurityGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InputSecurityGroup> {
        public Builder arn(String var1);

        public Builder id(String var1);

        public Builder inputs(Collection<String> var1);

        public Builder inputs(String ... var1);

        public Builder state(String var1);

        public Builder state(InputSecurityGroupState var1);

        public Builder tags(Map<String, String> var1);

        public Builder whitelistRules(Collection<InputWhitelistRule> var1);

        public Builder whitelistRules(InputWhitelistRule ... var1);

        public Builder whitelistRules(Consumer<InputWhitelistRule.Builder> ... var1);
    }
}

