/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.InputDestinationVpc;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InputDestination
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InputDestination> {
    private static final SdkField<String> IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InputDestination.getter(InputDestination::ip)).setter(InputDestination.setter(Builder::ip)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ip").build()}).build();
    private static final SdkField<String> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InputDestination.getter(InputDestination::port)).setter(InputDestination.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()}).build();
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InputDestination.getter(InputDestination::url)).setter(InputDestination.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()}).build();
    private static final SdkField<InputDestinationVpc> VPC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(InputDestination.getter(InputDestination::vpc)).setter(InputDestination.setter(Builder::vpc)).constructor(InputDestinationVpc::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpc").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_FIELD, PORT_FIELD, URL_FIELD, VPC_FIELD));
    private static final long serialVersionUID = 1L;
    private final String ip;
    private final String port;
    private final String url;
    private final InputDestinationVpc vpc;

    private InputDestination(BuilderImpl builder) {
        this.ip = builder.ip;
        this.port = builder.port;
        this.url = builder.url;
        this.vpc = builder.vpc;
    }

    public String ip() {
        return this.ip;
    }

    public String port() {
        return this.port;
    }

    public String url() {
        return this.url;
    }

    public InputDestinationVpc vpc() {
        return this.vpc;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ip());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpc());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputDestination)) {
            return false;
        }
        InputDestination other = (InputDestination)obj;
        return Objects.equals(this.ip(), other.ip()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.url(), other.url()) && Objects.equals(this.vpc(), other.vpc());
    }

    public String toString() {
        return ToString.builder((String)"InputDestination").add("Ip", (Object)this.ip()).add("Port", (Object)this.port()).add("Url", (Object)this.url()).add("Vpc", (Object)this.vpc()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Ip": {
                return Optional.ofNullable(clazz.cast(this.ip()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "Url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
            case "Vpc": {
                return Optional.ofNullable(clazz.cast(this.vpc()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputDestination, T> g) {
        return obj -> g.apply((InputDestination)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ip;
        private String port;
        private String url;
        private InputDestinationVpc vpc;

        private BuilderImpl() {
        }

        private BuilderImpl(InputDestination model) {
            this.ip(model.ip);
            this.port(model.port);
            this.url(model.url);
            this.vpc(model.vpc);
        }

        public final String getIp() {
            return this.ip;
        }

        @Override
        public final Builder ip(String ip) {
            this.ip = ip;
            return this;
        }

        public final void setIp(String ip) {
            this.ip = ip;
        }

        public final String getPort() {
            return this.port;
        }

        @Override
        public final Builder port(String port) {
            this.port = port;
            return this;
        }

        public final void setPort(String port) {
            this.port = port;
        }

        public final String getUrl() {
            return this.url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public final InputDestinationVpc.Builder getVpc() {
            return this.vpc != null ? this.vpc.toBuilder() : null;
        }

        @Override
        public final Builder vpc(InputDestinationVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        public final void setVpc(InputDestinationVpc.BuilderImpl vpc) {
            this.vpc = vpc != null ? vpc.build() : null;
        }

        public InputDestination build() {
            return new InputDestination(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InputDestination> {
        public Builder ip(String var1);

        public Builder port(String var1);

        public Builder url(String var1);

        public Builder vpc(InputDestinationVpc var1);

        default public Builder vpc(Consumer<InputDestinationVpc.Builder> vpc) {
            return this.vpc((InputDestinationVpc)((InputDestinationVpc.Builder)InputDestinationVpc.builder().applyMutation(vpc)).build());
        }
    }
}

