/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.InputSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InputAttachment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InputAttachment> {
    private static final SdkField<String> INPUT_ATTACHMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InputAttachment.getter(InputAttachment::inputAttachmentName)).setter(InputAttachment.setter(Builder::inputAttachmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputAttachmentName").build()}).build();
    private static final SdkField<String> INPUT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InputAttachment.getter(InputAttachment::inputId)).setter(InputAttachment.setter(Builder::inputId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputId").build()}).build();
    private static final SdkField<InputSettings> INPUT_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(InputAttachment.getter(InputAttachment::inputSettings)).setter(InputAttachment.setter(Builder::inputSettings)).constructor(InputSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_ATTACHMENT_NAME_FIELD, INPUT_ID_FIELD, INPUT_SETTINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String inputAttachmentName;
    private final String inputId;
    private final InputSettings inputSettings;

    private InputAttachment(BuilderImpl builder) {
        this.inputAttachmentName = builder.inputAttachmentName;
        this.inputId = builder.inputId;
        this.inputSettings = builder.inputSettings;
    }

    public String inputAttachmentName() {
        return this.inputAttachmentName;
    }

    public String inputId() {
        return this.inputId;
    }

    public InputSettings inputSettings() {
        return this.inputSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.inputAttachmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputId());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputSettings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputAttachment)) {
            return false;
        }
        InputAttachment other = (InputAttachment)obj;
        return Objects.equals(this.inputAttachmentName(), other.inputAttachmentName()) && Objects.equals(this.inputId(), other.inputId()) && Objects.equals(this.inputSettings(), other.inputSettings());
    }

    public String toString() {
        return ToString.builder((String)"InputAttachment").add("InputAttachmentName", (Object)this.inputAttachmentName()).add("InputId", (Object)this.inputId()).add("InputSettings", (Object)this.inputSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InputAttachmentName": {
                return Optional.ofNullable(clazz.cast(this.inputAttachmentName()));
            }
            case "InputId": {
                return Optional.ofNullable(clazz.cast(this.inputId()));
            }
            case "InputSettings": {
                return Optional.ofNullable(clazz.cast(this.inputSettings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputAttachment, T> g) {
        return obj -> g.apply((InputAttachment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String inputAttachmentName;
        private String inputId;
        private InputSettings inputSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(InputAttachment model) {
            this.inputAttachmentName(model.inputAttachmentName);
            this.inputId(model.inputId);
            this.inputSettings(model.inputSettings);
        }

        public final String getInputAttachmentName() {
            return this.inputAttachmentName;
        }

        @Override
        public final Builder inputAttachmentName(String inputAttachmentName) {
            this.inputAttachmentName = inputAttachmentName;
            return this;
        }

        public final void setInputAttachmentName(String inputAttachmentName) {
            this.inputAttachmentName = inputAttachmentName;
        }

        public final String getInputId() {
            return this.inputId;
        }

        @Override
        public final Builder inputId(String inputId) {
            this.inputId = inputId;
            return this;
        }

        public final void setInputId(String inputId) {
            this.inputId = inputId;
        }

        public final InputSettings.Builder getInputSettings() {
            return this.inputSettings != null ? this.inputSettings.toBuilder() : null;
        }

        @Override
        public final Builder inputSettings(InputSettings inputSettings) {
            this.inputSettings = inputSettings;
            return this;
        }

        public final void setInputSettings(InputSettings.BuilderImpl inputSettings) {
            this.inputSettings = inputSettings != null ? inputSettings.build() : null;
        }

        public InputAttachment build() {
            return new InputAttachment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InputAttachment> {
        public Builder inputAttachmentName(String var1);

        public Builder inputId(String var1);

        public Builder inputSettings(InputSettings var1);

        default public Builder inputSettings(Consumer<InputSettings.Builder> inputSettings) {
            return this.inputSettings((InputSettings)((InputSettings.Builder)InputSettings.builder().applyMutation(inputSettings)).build());
        }
    }
}

