/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.medialive.MediaLiveAsyncClient;
import software.amazon.awssdk.services.medialive.model.ListReservationsRequest;
import software.amazon.awssdk.services.medialive.model.ListReservationsResponse;

public class ListReservationsPublisher
implements SdkPublisher<ListReservationsResponse> {
    private final MediaLiveAsyncClient client;
    private final ListReservationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListReservationsPublisher(MediaLiveAsyncClient client, ListReservationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListReservationsPublisher(MediaLiveAsyncClient client, ListReservationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListReservationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListReservationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListReservationsResponseFetcher
    implements AsyncPageFetcher<ListReservationsResponse> {
        private ListReservationsResponseFetcher() {
        }

        public boolean hasNextPage(ListReservationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListReservationsResponse> nextPage(ListReservationsResponse previousPage) {
            if (previousPage == null) {
                return ListReservationsPublisher.this.client.listReservations(ListReservationsPublisher.this.firstRequest);
            }
            return ListReservationsPublisher.this.client.listReservations((ListReservationsRequest)((Object)ListReservationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

