/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.FollowPoint;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FollowModeScheduleActionStartSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FollowModeScheduleActionStartSettings> {
    private static final SdkField<String> FOLLOW_POINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FollowModeScheduleActionStartSettings.getter(FollowModeScheduleActionStartSettings::followPointAsString)).setter(FollowModeScheduleActionStartSettings.setter(Builder::followPoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("followPoint").build()}).build();
    private static final SdkField<String> REFERENCE_ACTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FollowModeScheduleActionStartSettings.getter(FollowModeScheduleActionStartSettings::referenceActionName)).setter(FollowModeScheduleActionStartSettings.setter(Builder::referenceActionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referenceActionName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FOLLOW_POINT_FIELD, REFERENCE_ACTION_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String followPoint;
    private final String referenceActionName;

    private FollowModeScheduleActionStartSettings(BuilderImpl builder) {
        this.followPoint = builder.followPoint;
        this.referenceActionName = builder.referenceActionName;
    }

    public FollowPoint followPoint() {
        return FollowPoint.fromValue(this.followPoint);
    }

    public String followPointAsString() {
        return this.followPoint;
    }

    public String referenceActionName() {
        return this.referenceActionName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.followPointAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.referenceActionName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FollowModeScheduleActionStartSettings)) {
            return false;
        }
        FollowModeScheduleActionStartSettings other = (FollowModeScheduleActionStartSettings)obj;
        return Objects.equals(this.followPointAsString(), other.followPointAsString()) && Objects.equals(this.referenceActionName(), other.referenceActionName());
    }

    public String toString() {
        return ToString.builder((String)"FollowModeScheduleActionStartSettings").add("FollowPoint", (Object)this.followPointAsString()).add("ReferenceActionName", (Object)this.referenceActionName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FollowPoint": {
                return Optional.ofNullable(clazz.cast(this.followPointAsString()));
            }
            case "ReferenceActionName": {
                return Optional.ofNullable(clazz.cast(this.referenceActionName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FollowModeScheduleActionStartSettings, T> g) {
        return obj -> g.apply((FollowModeScheduleActionStartSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String followPoint;
        private String referenceActionName;

        private BuilderImpl() {
        }

        private BuilderImpl(FollowModeScheduleActionStartSettings model) {
            this.followPoint(model.followPoint);
            this.referenceActionName(model.referenceActionName);
        }

        public final String getFollowPointAsString() {
            return this.followPoint;
        }

        @Override
        public final Builder followPoint(String followPoint) {
            this.followPoint = followPoint;
            return this;
        }

        @Override
        public final Builder followPoint(FollowPoint followPoint) {
            this.followPoint(followPoint.toString());
            return this;
        }

        public final void setFollowPoint(String followPoint) {
            this.followPoint = followPoint;
        }

        public final String getReferenceActionName() {
            return this.referenceActionName;
        }

        @Override
        public final Builder referenceActionName(String referenceActionName) {
            this.referenceActionName = referenceActionName;
            return this;
        }

        public final void setReferenceActionName(String referenceActionName) {
            this.referenceActionName = referenceActionName;
        }

        public FollowModeScheduleActionStartSettings build() {
            return new FollowModeScheduleActionStartSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FollowModeScheduleActionStartSettings> {
        public Builder followPoint(String var1);

        public Builder followPoint(FollowPoint var1);

        public Builder referenceActionName(String var1);
    }
}

