/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.medialive.MediaLiveClient;
import software.amazon.awssdk.services.medialive.model.ListInputsRequest;
import software.amazon.awssdk.services.medialive.model.ListInputsResponse;

public class ListInputsIterable
implements SdkIterable<ListInputsResponse> {
    private final MediaLiveClient client;
    private final ListInputsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListInputsIterable(MediaLiveClient client, ListInputsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListInputsResponseFetcher();
    }

    public Iterator<ListInputsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListInputsResponseFetcher
    implements SyncPageFetcher<ListInputsResponse> {
        private ListInputsResponseFetcher() {
        }

        public boolean hasNextPage(ListInputsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListInputsResponse nextPage(ListInputsResponse previousPage) {
            if (previousPage == null) {
                return ListInputsIterable.this.client.listInputs(ListInputsIterable.this.firstRequest);
            }
            return ListInputsIterable.this.client.listInputs((ListInputsRequest)((Object)ListInputsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

