/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.IpPoolUpdateRequest;
import software.amazon.awssdk.services.medialive.model.MediaLiveRequest;
import software.amazon.awssdk.services.medialive.model.RouteUpdateRequest;
import software.amazon.awssdk.services.medialive.model.___listOfIpPoolUpdateRequestCopier;
import software.amazon.awssdk.services.medialive.model.___listOfRouteUpdateRequestCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateNetworkRequest
extends MediaLiveRequest
implements ToCopyableBuilder<Builder, UpdateNetworkRequest> {
    private static final SdkField<List<IpPoolUpdateRequest>> IP_POOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IpPools").getter(UpdateNetworkRequest.getter(UpdateNetworkRequest::ipPools)).setter(UpdateNetworkRequest.setter(Builder::ipPools)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipPools").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpPoolUpdateRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateNetworkRequest.getter(UpdateNetworkRequest::name)).setter(UpdateNetworkRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkId").getter(UpdateNetworkRequest.getter(UpdateNetworkRequest::networkId)).setter(UpdateNetworkRequest.setter(Builder::networkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("networkId").build()}).build();
    private static final SdkField<List<RouteUpdateRequest>> ROUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Routes").getter(UpdateNetworkRequest.getter(UpdateNetworkRequest::routes)).setter(UpdateNetworkRequest.setter(Builder::routes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RouteUpdateRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_POOLS_FIELD, NAME_FIELD, NETWORK_ID_FIELD, ROUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateNetworkRequest.memberNameToFieldInitializer();
    private final List<IpPoolUpdateRequest> ipPools;
    private final String name;
    private final String networkId;
    private final List<RouteUpdateRequest> routes;

    private UpdateNetworkRequest(BuilderImpl builder) {
        super(builder);
        this.ipPools = builder.ipPools;
        this.name = builder.name;
        this.networkId = builder.networkId;
        this.routes = builder.routes;
    }

    public final boolean hasIpPools() {
        return this.ipPools != null && !(this.ipPools instanceof SdkAutoConstructList);
    }

    public final List<IpPoolUpdateRequest> ipPools() {
        return this.ipPools;
    }

    public final String name() {
        return this.name;
    }

    public final String networkId() {
        return this.networkId;
    }

    public final boolean hasRoutes() {
        return this.routes != null && !(this.routes instanceof SdkAutoConstructList);
    }

    public final List<RouteUpdateRequest> routes() {
        return this.routes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpPools() ? this.ipPools() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoutes() ? this.routes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateNetworkRequest)) {
            return false;
        }
        UpdateNetworkRequest other = (UpdateNetworkRequest)((Object)obj);
        return this.hasIpPools() == other.hasIpPools() && Objects.equals(this.ipPools(), other.ipPools()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.networkId(), other.networkId()) && this.hasRoutes() == other.hasRoutes() && Objects.equals(this.routes(), other.routes());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateNetworkRequest").add("IpPools", this.hasIpPools() ? this.ipPools() : null).add("Name", (Object)this.name()).add("NetworkId", (Object)this.networkId()).add("Routes", this.hasRoutes() ? this.routes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IpPools": {
                return Optional.ofNullable(clazz.cast(this.ipPools()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "NetworkId": {
                return Optional.ofNullable(clazz.cast(this.networkId()));
            }
            case "Routes": {
                return Optional.ofNullable(clazz.cast(this.routes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ipPools", IP_POOLS_FIELD);
        map.put("name", NAME_FIELD);
        map.put("networkId", NETWORK_ID_FIELD);
        map.put("routes", ROUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateNetworkRequest, T> g) {
        return obj -> g.apply((UpdateNetworkRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveRequest.BuilderImpl
    implements Builder {
        private List<IpPoolUpdateRequest> ipPools = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private String networkId;
        private List<RouteUpdateRequest> routes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateNetworkRequest model) {
            super(model);
            this.ipPools(model.ipPools);
            this.name(model.name);
            this.networkId(model.networkId);
            this.routes(model.routes);
        }

        public final List<IpPoolUpdateRequest.Builder> getIpPools() {
            List<IpPoolUpdateRequest.Builder> result = ___listOfIpPoolUpdateRequestCopier.copyToBuilder(this.ipPools);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpPools(Collection<IpPoolUpdateRequest.BuilderImpl> ipPools) {
            this.ipPools = ___listOfIpPoolUpdateRequestCopier.copyFromBuilder(ipPools);
        }

        @Override
        public final Builder ipPools(Collection<IpPoolUpdateRequest> ipPools) {
            this.ipPools = ___listOfIpPoolUpdateRequestCopier.copy(ipPools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPools(IpPoolUpdateRequest ... ipPools) {
            this.ipPools(Arrays.asList(ipPools));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPools(Consumer<IpPoolUpdateRequest.Builder> ... ipPools) {
            this.ipPools(Stream.of(ipPools).map(c -> (IpPoolUpdateRequest)((IpPoolUpdateRequest.Builder)IpPoolUpdateRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getNetworkId() {
            return this.networkId;
        }

        public final void setNetworkId(String networkId) {
            this.networkId = networkId;
        }

        @Override
        public final Builder networkId(String networkId) {
            this.networkId = networkId;
            return this;
        }

        public final List<RouteUpdateRequest.Builder> getRoutes() {
            List<RouteUpdateRequest.Builder> result = ___listOfRouteUpdateRequestCopier.copyToBuilder(this.routes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoutes(Collection<RouteUpdateRequest.BuilderImpl> routes) {
            this.routes = ___listOfRouteUpdateRequestCopier.copyFromBuilder(routes);
        }

        @Override
        public final Builder routes(Collection<RouteUpdateRequest> routes) {
            this.routes = ___listOfRouteUpdateRequestCopier.copy(routes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(RouteUpdateRequest ... routes) {
            this.routes(Arrays.asList(routes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(Consumer<RouteUpdateRequest.Builder> ... routes) {
            this.routes(Stream.of(routes).map(c -> (RouteUpdateRequest)((RouteUpdateRequest.Builder)RouteUpdateRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateNetworkRequest build() {
            return new UpdateNetworkRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MediaLiveRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateNetworkRequest> {
        public Builder ipPools(Collection<IpPoolUpdateRequest> var1);

        public Builder ipPools(IpPoolUpdateRequest ... var1);

        public Builder ipPools(Consumer<IpPoolUpdateRequest.Builder> ... var1);

        public Builder name(String var1);

        public Builder networkId(String var1);

        public Builder routes(Collection<RouteUpdateRequest> var1);

        public Builder routes(RouteUpdateRequest ... var1);

        public Builder routes(Consumer<RouteUpdateRequest.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

