/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.MediaLiveResponse;
import software.amazon.awssdk.services.medialive.model.MultiplexSummary;
import software.amazon.awssdk.services.medialive.model.___listOfMultiplexSummaryCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMultiplexesResponse
extends MediaLiveResponse
implements ToCopyableBuilder<Builder, ListMultiplexesResponse> {
    private static final SdkField<List<MultiplexSummary>> MULTIPLEXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Multiplexes").getter(ListMultiplexesResponse.getter(ListMultiplexesResponse::multiplexes)).setter(ListMultiplexesResponse.setter(Builder::multiplexes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiplexes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MultiplexSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListMultiplexesResponse.getter(ListMultiplexesResponse::nextToken)).setter(ListMultiplexesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MULTIPLEXES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListMultiplexesResponse.memberNameToFieldInitializer();
    private final List<MultiplexSummary> multiplexes;
    private final String nextToken;

    private ListMultiplexesResponse(BuilderImpl builder) {
        super(builder);
        this.multiplexes = builder.multiplexes;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasMultiplexes() {
        return this.multiplexes != null && !(this.multiplexes instanceof SdkAutoConstructList);
    }

    public final List<MultiplexSummary> multiplexes() {
        return this.multiplexes;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMultiplexes() ? this.multiplexes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMultiplexesResponse)) {
            return false;
        }
        ListMultiplexesResponse other = (ListMultiplexesResponse)((Object)obj);
        return this.hasMultiplexes() == other.hasMultiplexes() && Objects.equals(this.multiplexes(), other.multiplexes()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListMultiplexesResponse").add("Multiplexes", this.hasMultiplexes() ? this.multiplexes() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Multiplexes": {
                return Optional.ofNullable(clazz.cast(this.multiplexes()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("multiplexes", MULTIPLEXES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMultiplexesResponse, T> g) {
        return obj -> g.apply((ListMultiplexesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveResponse.BuilderImpl
    implements Builder {
        private List<MultiplexSummary> multiplexes = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMultiplexesResponse model) {
            super(model);
            this.multiplexes(model.multiplexes);
            this.nextToken(model.nextToken);
        }

        public final List<MultiplexSummary.Builder> getMultiplexes() {
            List<MultiplexSummary.Builder> result = ___listOfMultiplexSummaryCopier.copyToBuilder(this.multiplexes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMultiplexes(Collection<MultiplexSummary.BuilderImpl> multiplexes) {
            this.multiplexes = ___listOfMultiplexSummaryCopier.copyFromBuilder(multiplexes);
        }

        @Override
        public final Builder multiplexes(Collection<MultiplexSummary> multiplexes) {
            this.multiplexes = ___listOfMultiplexSummaryCopier.copy(multiplexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder multiplexes(MultiplexSummary ... multiplexes) {
            this.multiplexes(Arrays.asList(multiplexes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder multiplexes(Consumer<MultiplexSummary.Builder> ... multiplexes) {
            this.multiplexes(Stream.of(multiplexes).map(c -> (MultiplexSummary)((MultiplexSummary.Builder)MultiplexSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListMultiplexesResponse build() {
            return new ListMultiplexesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MediaLiveResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMultiplexesResponse> {
        public Builder multiplexes(Collection<MultiplexSummary> var1);

        public Builder multiplexes(MultiplexSummary ... var1);

        public Builder multiplexes(Consumer<MultiplexSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

