/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.ColorSpace;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ColorCorrection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ColorCorrection> {
    private static final SdkField<String> INPUT_COLOR_SPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputColorSpace").getter(ColorCorrection.getter(ColorCorrection::inputColorSpaceAsString)).setter(ColorCorrection.setter(Builder::inputColorSpace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputColorSpace").build()}).build();
    private static final SdkField<String> OUTPUT_COLOR_SPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputColorSpace").getter(ColorCorrection.getter(ColorCorrection::outputColorSpaceAsString)).setter(ColorCorrection.setter(Builder::outputColorSpace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputColorSpace").build()}).build();
    private static final SdkField<String> URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Uri").getter(ColorCorrection.getter(ColorCorrection::uri)).setter(ColorCorrection.setter(Builder::uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uri").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_COLOR_SPACE_FIELD, OUTPUT_COLOR_SPACE_FIELD, URI_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ColorCorrection.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String inputColorSpace;
    private final String outputColorSpace;
    private final String uri;

    private ColorCorrection(BuilderImpl builder) {
        this.inputColorSpace = builder.inputColorSpace;
        this.outputColorSpace = builder.outputColorSpace;
        this.uri = builder.uri;
    }

    public final ColorSpace inputColorSpace() {
        return ColorSpace.fromValue(this.inputColorSpace);
    }

    public final String inputColorSpaceAsString() {
        return this.inputColorSpace;
    }

    public final ColorSpace outputColorSpace() {
        return ColorSpace.fromValue(this.outputColorSpace);
    }

    public final String outputColorSpaceAsString() {
        return this.outputColorSpace;
    }

    public final String uri() {
        return this.uri;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.inputColorSpaceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputColorSpaceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.uri());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColorCorrection)) {
            return false;
        }
        ColorCorrection other = (ColorCorrection)obj;
        return Objects.equals(this.inputColorSpaceAsString(), other.inputColorSpaceAsString()) && Objects.equals(this.outputColorSpaceAsString(), other.outputColorSpaceAsString()) && Objects.equals(this.uri(), other.uri());
    }

    public final String toString() {
        return ToString.builder((String)"ColorCorrection").add("InputColorSpace", (Object)this.inputColorSpaceAsString()).add("OutputColorSpace", (Object)this.outputColorSpaceAsString()).add("Uri", (Object)this.uri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InputColorSpace": {
                return Optional.ofNullable(clazz.cast(this.inputColorSpaceAsString()));
            }
            case "OutputColorSpace": {
                return Optional.ofNullable(clazz.cast(this.outputColorSpaceAsString()));
            }
            case "Uri": {
                return Optional.ofNullable(clazz.cast(this.uri()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("inputColorSpace", INPUT_COLOR_SPACE_FIELD);
        map.put("outputColorSpace", OUTPUT_COLOR_SPACE_FIELD);
        map.put("uri", URI_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ColorCorrection, T> g) {
        return obj -> g.apply((ColorCorrection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String inputColorSpace;
        private String outputColorSpace;
        private String uri;

        private BuilderImpl() {
        }

        private BuilderImpl(ColorCorrection model) {
            this.inputColorSpace(model.inputColorSpace);
            this.outputColorSpace(model.outputColorSpace);
            this.uri(model.uri);
        }

        public final String getInputColorSpace() {
            return this.inputColorSpace;
        }

        public final void setInputColorSpace(String inputColorSpace) {
            this.inputColorSpace = inputColorSpace;
        }

        @Override
        public final Builder inputColorSpace(String inputColorSpace) {
            this.inputColorSpace = inputColorSpace;
            return this;
        }

        @Override
        public final Builder inputColorSpace(ColorSpace inputColorSpace) {
            this.inputColorSpace(inputColorSpace == null ? null : inputColorSpace.toString());
            return this;
        }

        public final String getOutputColorSpace() {
            return this.outputColorSpace;
        }

        public final void setOutputColorSpace(String outputColorSpace) {
            this.outputColorSpace = outputColorSpace;
        }

        @Override
        public final Builder outputColorSpace(String outputColorSpace) {
            this.outputColorSpace = outputColorSpace;
            return this;
        }

        @Override
        public final Builder outputColorSpace(ColorSpace outputColorSpace) {
            this.outputColorSpace(outputColorSpace == null ? null : outputColorSpace.toString());
            return this;
        }

        public final String getUri() {
            return this.uri;
        }

        public final void setUri(String uri) {
            this.uri = uri;
        }

        @Override
        public final Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public ColorCorrection build() {
            return new ColorCorrection(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ColorCorrection> {
        public Builder inputColorSpace(String var1);

        public Builder inputColorSpace(ColorSpace var1);

        public Builder outputColorSpace(String var1);

        public Builder outputColorSpace(ColorSpace var1);

        public Builder uri(String var1);
    }
}

