/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.AutomaticInputFailoverSettings;
import software.amazon.awssdk.services.medialive.model.InputSettings;
import software.amazon.awssdk.services.medialive.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InputAttachment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InputAttachment> {
    private static final SdkField<AutomaticInputFailoverSettings> AUTOMATIC_INPUT_FAILOVER_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AutomaticInputFailoverSettings").getter(InputAttachment.getter(InputAttachment::automaticInputFailoverSettings)).setter(InputAttachment.setter(Builder::automaticInputFailoverSettings)).constructor(AutomaticInputFailoverSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("automaticInputFailoverSettings").build()}).build();
    private static final SdkField<String> INPUT_ATTACHMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputAttachmentName").getter(InputAttachment.getter(InputAttachment::inputAttachmentName)).setter(InputAttachment.setter(Builder::inputAttachmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputAttachmentName").build()}).build();
    private static final SdkField<String> INPUT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputId").getter(InputAttachment.getter(InputAttachment::inputId)).setter(InputAttachment.setter(Builder::inputId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputId").build()}).build();
    private static final SdkField<InputSettings> INPUT_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InputSettings").getter(InputAttachment.getter(InputAttachment::inputSettings)).setter(InputAttachment.setter(Builder::inputSettings)).constructor(InputSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputSettings").build()}).build();
    private static final SdkField<List<String>> LOGICAL_INTERFACE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LogicalInterfaceNames").getter(InputAttachment.getter(InputAttachment::logicalInterfaceNames)).setter(InputAttachment.setter(Builder::logicalInterfaceNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logicalInterfaceNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTOMATIC_INPUT_FAILOVER_SETTINGS_FIELD, INPUT_ATTACHMENT_NAME_FIELD, INPUT_ID_FIELD, INPUT_SETTINGS_FIELD, LOGICAL_INTERFACE_NAMES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InputAttachment.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AutomaticInputFailoverSettings automaticInputFailoverSettings;
    private final String inputAttachmentName;
    private final String inputId;
    private final InputSettings inputSettings;
    private final List<String> logicalInterfaceNames;

    private InputAttachment(BuilderImpl builder) {
        this.automaticInputFailoverSettings = builder.automaticInputFailoverSettings;
        this.inputAttachmentName = builder.inputAttachmentName;
        this.inputId = builder.inputId;
        this.inputSettings = builder.inputSettings;
        this.logicalInterfaceNames = builder.logicalInterfaceNames;
    }

    public final AutomaticInputFailoverSettings automaticInputFailoverSettings() {
        return this.automaticInputFailoverSettings;
    }

    public final String inputAttachmentName() {
        return this.inputAttachmentName;
    }

    public final String inputId() {
        return this.inputId;
    }

    public final InputSettings inputSettings() {
        return this.inputSettings;
    }

    public final boolean hasLogicalInterfaceNames() {
        return this.logicalInterfaceNames != null && !(this.logicalInterfaceNames instanceof SdkAutoConstructList);
    }

    public final List<String> logicalInterfaceNames() {
        return this.logicalInterfaceNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.automaticInputFailoverSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputAttachmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputId());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogicalInterfaceNames() ? this.logicalInterfaceNames() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputAttachment)) {
            return false;
        }
        InputAttachment other = (InputAttachment)obj;
        return Objects.equals(this.automaticInputFailoverSettings(), other.automaticInputFailoverSettings()) && Objects.equals(this.inputAttachmentName(), other.inputAttachmentName()) && Objects.equals(this.inputId(), other.inputId()) && Objects.equals(this.inputSettings(), other.inputSettings()) && this.hasLogicalInterfaceNames() == other.hasLogicalInterfaceNames() && Objects.equals(this.logicalInterfaceNames(), other.logicalInterfaceNames());
    }

    public final String toString() {
        return ToString.builder((String)"InputAttachment").add("AutomaticInputFailoverSettings", (Object)this.automaticInputFailoverSettings()).add("InputAttachmentName", (Object)this.inputAttachmentName()).add("InputId", (Object)this.inputId()).add("InputSettings", (Object)this.inputSettings()).add("LogicalInterfaceNames", this.hasLogicalInterfaceNames() ? this.logicalInterfaceNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutomaticInputFailoverSettings": {
                return Optional.ofNullable(clazz.cast(this.automaticInputFailoverSettings()));
            }
            case "InputAttachmentName": {
                return Optional.ofNullable(clazz.cast(this.inputAttachmentName()));
            }
            case "InputId": {
                return Optional.ofNullable(clazz.cast(this.inputId()));
            }
            case "InputSettings": {
                return Optional.ofNullable(clazz.cast(this.inputSettings()));
            }
            case "LogicalInterfaceNames": {
                return Optional.ofNullable(clazz.cast(this.logicalInterfaceNames()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("automaticInputFailoverSettings", AUTOMATIC_INPUT_FAILOVER_SETTINGS_FIELD);
        map.put("inputAttachmentName", INPUT_ATTACHMENT_NAME_FIELD);
        map.put("inputId", INPUT_ID_FIELD);
        map.put("inputSettings", INPUT_SETTINGS_FIELD);
        map.put("logicalInterfaceNames", LOGICAL_INTERFACE_NAMES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InputAttachment, T> g) {
        return obj -> g.apply((InputAttachment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AutomaticInputFailoverSettings automaticInputFailoverSettings;
        private String inputAttachmentName;
        private String inputId;
        private InputSettings inputSettings;
        private List<String> logicalInterfaceNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InputAttachment model) {
            this.automaticInputFailoverSettings(model.automaticInputFailoverSettings);
            this.inputAttachmentName(model.inputAttachmentName);
            this.inputId(model.inputId);
            this.inputSettings(model.inputSettings);
            this.logicalInterfaceNames(model.logicalInterfaceNames);
        }

        public final AutomaticInputFailoverSettings.Builder getAutomaticInputFailoverSettings() {
            return this.automaticInputFailoverSettings != null ? this.automaticInputFailoverSettings.toBuilder() : null;
        }

        public final void setAutomaticInputFailoverSettings(AutomaticInputFailoverSettings.BuilderImpl automaticInputFailoverSettings) {
            this.automaticInputFailoverSettings = automaticInputFailoverSettings != null ? automaticInputFailoverSettings.build() : null;
        }

        @Override
        public final Builder automaticInputFailoverSettings(AutomaticInputFailoverSettings automaticInputFailoverSettings) {
            this.automaticInputFailoverSettings = automaticInputFailoverSettings;
            return this;
        }

        public final String getInputAttachmentName() {
            return this.inputAttachmentName;
        }

        public final void setInputAttachmentName(String inputAttachmentName) {
            this.inputAttachmentName = inputAttachmentName;
        }

        @Override
        public final Builder inputAttachmentName(String inputAttachmentName) {
            this.inputAttachmentName = inputAttachmentName;
            return this;
        }

        public final String getInputId() {
            return this.inputId;
        }

        public final void setInputId(String inputId) {
            this.inputId = inputId;
        }

        @Override
        public final Builder inputId(String inputId) {
            this.inputId = inputId;
            return this;
        }

        public final InputSettings.Builder getInputSettings() {
            return this.inputSettings != null ? this.inputSettings.toBuilder() : null;
        }

        public final void setInputSettings(InputSettings.BuilderImpl inputSettings) {
            this.inputSettings = inputSettings != null ? inputSettings.build() : null;
        }

        @Override
        public final Builder inputSettings(InputSettings inputSettings) {
            this.inputSettings = inputSettings;
            return this;
        }

        public final Collection<String> getLogicalInterfaceNames() {
            if (this.logicalInterfaceNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.logicalInterfaceNames;
        }

        public final void setLogicalInterfaceNames(Collection<String> logicalInterfaceNames) {
            this.logicalInterfaceNames = ___listOf__stringCopier.copy(logicalInterfaceNames);
        }

        @Override
        public final Builder logicalInterfaceNames(Collection<String> logicalInterfaceNames) {
            this.logicalInterfaceNames = ___listOf__stringCopier.copy(logicalInterfaceNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logicalInterfaceNames(String ... logicalInterfaceNames) {
            this.logicalInterfaceNames(Arrays.asList(logicalInterfaceNames));
            return this;
        }

        public InputAttachment build() {
            return new InputAttachment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InputAttachment> {
        public Builder automaticInputFailoverSettings(AutomaticInputFailoverSettings var1);

        default public Builder automaticInputFailoverSettings(Consumer<AutomaticInputFailoverSettings.Builder> automaticInputFailoverSettings) {
            return this.automaticInputFailoverSettings((AutomaticInputFailoverSettings)((AutomaticInputFailoverSettings.Builder)AutomaticInputFailoverSettings.builder().applyMutation(automaticInputFailoverSettings)).build());
        }

        public Builder inputAttachmentName(String var1);

        public Builder inputId(String var1);

        public Builder inputSettings(InputSettings var1);

        default public Builder inputSettings(Consumer<InputSettings.Builder> inputSettings) {
            return this.inputSettings((InputSettings)((InputSettings.Builder)InputSettings.builder().applyMutation(inputSettings)).build());
        }

        public Builder logicalInterfaceNames(Collection<String> var1);

        public Builder logicalInterfaceNames(String ... var1);
    }
}

