/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.MediaLiveResponse;
import software.amazon.awssdk.services.medialive.model.SignalMapSummary;
import software.amazon.awssdk.services.medialive.model.___listOfSignalMapSummaryCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSignalMapsResponse
extends MediaLiveResponse
implements ToCopyableBuilder<Builder, ListSignalMapsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListSignalMapsResponse.getter(ListSignalMapsResponse::nextToken)).setter(ListSignalMapsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<SignalMapSummary>> SIGNAL_MAPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SignalMaps").getter(ListSignalMapsResponse.getter(ListSignalMapsResponse::signalMaps)).setter(ListSignalMapsResponse.setter(Builder::signalMaps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signalMaps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SignalMapSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SIGNAL_MAPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListSignalMapsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<SignalMapSummary> signalMaps;

    private ListSignalMapsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.signalMaps = builder.signalMaps;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasSignalMaps() {
        return this.signalMaps != null && !(this.signalMaps instanceof SdkAutoConstructList);
    }

    public final List<SignalMapSummary> signalMaps() {
        return this.signalMaps;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSignalMaps() ? this.signalMaps() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSignalMapsResponse)) {
            return false;
        }
        ListSignalMapsResponse other = (ListSignalMapsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasSignalMaps() == other.hasSignalMaps() && Objects.equals(this.signalMaps(), other.signalMaps());
    }

    public final String toString() {
        return ToString.builder((String)"ListSignalMapsResponse").add("NextToken", (Object)this.nextToken()).add("SignalMaps", this.hasSignalMaps() ? this.signalMaps() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "SignalMaps": {
                return Optional.ofNullable(clazz.cast(this.signalMaps()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("signalMaps", SIGNAL_MAPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSignalMapsResponse, T> g) {
        return obj -> g.apply((ListSignalMapsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<SignalMapSummary> signalMaps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSignalMapsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.signalMaps(model.signalMaps);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<SignalMapSummary.Builder> getSignalMaps() {
            List<SignalMapSummary.Builder> result = ___listOfSignalMapSummaryCopier.copyToBuilder(this.signalMaps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSignalMaps(Collection<SignalMapSummary.BuilderImpl> signalMaps) {
            this.signalMaps = ___listOfSignalMapSummaryCopier.copyFromBuilder(signalMaps);
        }

        @Override
        public final Builder signalMaps(Collection<SignalMapSummary> signalMaps) {
            this.signalMaps = ___listOfSignalMapSummaryCopier.copy(signalMaps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signalMaps(SignalMapSummary ... signalMaps) {
            this.signalMaps(Arrays.asList(signalMaps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signalMaps(Consumer<SignalMapSummary.Builder> ... signalMaps) {
            this.signalMaps(Stream.of(signalMaps).map(c -> (SignalMapSummary)((SignalMapSummary.Builder)SignalMapSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListSignalMapsResponse build() {
            return new ListSignalMapsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MediaLiveResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSignalMapsResponse> {
        public Builder nextToken(String var1);

        public Builder signalMaps(Collection<SignalMapSummary> var1);

        public Builder signalMaps(SignalMapSummary ... var1);

        public Builder signalMaps(Consumer<SignalMapSummary.Builder> ... var1);
    }
}

