/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.HlsAkamaiSettings;
import software.amazon.awssdk.services.medialive.model.HlsBasicPutSettings;
import software.amazon.awssdk.services.medialive.model.HlsMediaStoreSettings;
import software.amazon.awssdk.services.medialive.model.HlsS3Settings;
import software.amazon.awssdk.services.medialive.model.HlsWebdavSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HlsCdnSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HlsCdnSettings> {
    private static final SdkField<HlsAkamaiSettings> HLS_AKAMAI_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HlsAkamaiSettings").getter(HlsCdnSettings.getter(HlsCdnSettings::hlsAkamaiSettings)).setter(HlsCdnSettings.setter(Builder::hlsAkamaiSettings)).constructor(HlsAkamaiSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hlsAkamaiSettings").build()}).build();
    private static final SdkField<HlsBasicPutSettings> HLS_BASIC_PUT_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HlsBasicPutSettings").getter(HlsCdnSettings.getter(HlsCdnSettings::hlsBasicPutSettings)).setter(HlsCdnSettings.setter(Builder::hlsBasicPutSettings)).constructor(HlsBasicPutSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hlsBasicPutSettings").build()}).build();
    private static final SdkField<HlsMediaStoreSettings> HLS_MEDIA_STORE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HlsMediaStoreSettings").getter(HlsCdnSettings.getter(HlsCdnSettings::hlsMediaStoreSettings)).setter(HlsCdnSettings.setter(Builder::hlsMediaStoreSettings)).constructor(HlsMediaStoreSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hlsMediaStoreSettings").build()}).build();
    private static final SdkField<HlsS3Settings> HLS_S3_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HlsS3Settings").getter(HlsCdnSettings.getter(HlsCdnSettings::hlsS3Settings)).setter(HlsCdnSettings.setter(Builder::hlsS3Settings)).constructor(HlsS3Settings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hlsS3Settings").build()}).build();
    private static final SdkField<HlsWebdavSettings> HLS_WEBDAV_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HlsWebdavSettings").getter(HlsCdnSettings.getter(HlsCdnSettings::hlsWebdavSettings)).setter(HlsCdnSettings.setter(Builder::hlsWebdavSettings)).constructor(HlsWebdavSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hlsWebdavSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HLS_AKAMAI_SETTINGS_FIELD, HLS_BASIC_PUT_SETTINGS_FIELD, HLS_MEDIA_STORE_SETTINGS_FIELD, HLS_S3_SETTINGS_FIELD, HLS_WEBDAV_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = HlsCdnSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final HlsAkamaiSettings hlsAkamaiSettings;
    private final HlsBasicPutSettings hlsBasicPutSettings;
    private final HlsMediaStoreSettings hlsMediaStoreSettings;
    private final HlsS3Settings hlsS3Settings;
    private final HlsWebdavSettings hlsWebdavSettings;

    private HlsCdnSettings(BuilderImpl builder) {
        this.hlsAkamaiSettings = builder.hlsAkamaiSettings;
        this.hlsBasicPutSettings = builder.hlsBasicPutSettings;
        this.hlsMediaStoreSettings = builder.hlsMediaStoreSettings;
        this.hlsS3Settings = builder.hlsS3Settings;
        this.hlsWebdavSettings = builder.hlsWebdavSettings;
    }

    public final HlsAkamaiSettings hlsAkamaiSettings() {
        return this.hlsAkamaiSettings;
    }

    public final HlsBasicPutSettings hlsBasicPutSettings() {
        return this.hlsBasicPutSettings;
    }

    public final HlsMediaStoreSettings hlsMediaStoreSettings() {
        return this.hlsMediaStoreSettings;
    }

    public final HlsS3Settings hlsS3Settings() {
        return this.hlsS3Settings;
    }

    public final HlsWebdavSettings hlsWebdavSettings() {
        return this.hlsWebdavSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hlsAkamaiSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hlsBasicPutSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hlsMediaStoreSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hlsS3Settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hlsWebdavSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsCdnSettings)) {
            return false;
        }
        HlsCdnSettings other = (HlsCdnSettings)obj;
        return Objects.equals(this.hlsAkamaiSettings(), other.hlsAkamaiSettings()) && Objects.equals(this.hlsBasicPutSettings(), other.hlsBasicPutSettings()) && Objects.equals(this.hlsMediaStoreSettings(), other.hlsMediaStoreSettings()) && Objects.equals(this.hlsS3Settings(), other.hlsS3Settings()) && Objects.equals(this.hlsWebdavSettings(), other.hlsWebdavSettings());
    }

    public final String toString() {
        return ToString.builder((String)"HlsCdnSettings").add("HlsAkamaiSettings", (Object)this.hlsAkamaiSettings()).add("HlsBasicPutSettings", (Object)this.hlsBasicPutSettings()).add("HlsMediaStoreSettings", (Object)this.hlsMediaStoreSettings()).add("HlsS3Settings", (Object)this.hlsS3Settings()).add("HlsWebdavSettings", (Object)this.hlsWebdavSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HlsAkamaiSettings": {
                return Optional.ofNullable(clazz.cast(this.hlsAkamaiSettings()));
            }
            case "HlsBasicPutSettings": {
                return Optional.ofNullable(clazz.cast(this.hlsBasicPutSettings()));
            }
            case "HlsMediaStoreSettings": {
                return Optional.ofNullable(clazz.cast(this.hlsMediaStoreSettings()));
            }
            case "HlsS3Settings": {
                return Optional.ofNullable(clazz.cast(this.hlsS3Settings()));
            }
            case "HlsWebdavSettings": {
                return Optional.ofNullable(clazz.cast(this.hlsWebdavSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("hlsAkamaiSettings", HLS_AKAMAI_SETTINGS_FIELD);
        map.put("hlsBasicPutSettings", HLS_BASIC_PUT_SETTINGS_FIELD);
        map.put("hlsMediaStoreSettings", HLS_MEDIA_STORE_SETTINGS_FIELD);
        map.put("hlsS3Settings", HLS_S3_SETTINGS_FIELD);
        map.put("hlsWebdavSettings", HLS_WEBDAV_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HlsCdnSettings, T> g) {
        return obj -> g.apply((HlsCdnSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private HlsAkamaiSettings hlsAkamaiSettings;
        private HlsBasicPutSettings hlsBasicPutSettings;
        private HlsMediaStoreSettings hlsMediaStoreSettings;
        private HlsS3Settings hlsS3Settings;
        private HlsWebdavSettings hlsWebdavSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsCdnSettings model) {
            this.hlsAkamaiSettings(model.hlsAkamaiSettings);
            this.hlsBasicPutSettings(model.hlsBasicPutSettings);
            this.hlsMediaStoreSettings(model.hlsMediaStoreSettings);
            this.hlsS3Settings(model.hlsS3Settings);
            this.hlsWebdavSettings(model.hlsWebdavSettings);
        }

        public final HlsAkamaiSettings.Builder getHlsAkamaiSettings() {
            return this.hlsAkamaiSettings != null ? this.hlsAkamaiSettings.toBuilder() : null;
        }

        public final void setHlsAkamaiSettings(HlsAkamaiSettings.BuilderImpl hlsAkamaiSettings) {
            this.hlsAkamaiSettings = hlsAkamaiSettings != null ? hlsAkamaiSettings.build() : null;
        }

        @Override
        public final Builder hlsAkamaiSettings(HlsAkamaiSettings hlsAkamaiSettings) {
            this.hlsAkamaiSettings = hlsAkamaiSettings;
            return this;
        }

        public final HlsBasicPutSettings.Builder getHlsBasicPutSettings() {
            return this.hlsBasicPutSettings != null ? this.hlsBasicPutSettings.toBuilder() : null;
        }

        public final void setHlsBasicPutSettings(HlsBasicPutSettings.BuilderImpl hlsBasicPutSettings) {
            this.hlsBasicPutSettings = hlsBasicPutSettings != null ? hlsBasicPutSettings.build() : null;
        }

        @Override
        public final Builder hlsBasicPutSettings(HlsBasicPutSettings hlsBasicPutSettings) {
            this.hlsBasicPutSettings = hlsBasicPutSettings;
            return this;
        }

        public final HlsMediaStoreSettings.Builder getHlsMediaStoreSettings() {
            return this.hlsMediaStoreSettings != null ? this.hlsMediaStoreSettings.toBuilder() : null;
        }

        public final void setHlsMediaStoreSettings(HlsMediaStoreSettings.BuilderImpl hlsMediaStoreSettings) {
            this.hlsMediaStoreSettings = hlsMediaStoreSettings != null ? hlsMediaStoreSettings.build() : null;
        }

        @Override
        public final Builder hlsMediaStoreSettings(HlsMediaStoreSettings hlsMediaStoreSettings) {
            this.hlsMediaStoreSettings = hlsMediaStoreSettings;
            return this;
        }

        public final HlsS3Settings.Builder getHlsS3Settings() {
            return this.hlsS3Settings != null ? this.hlsS3Settings.toBuilder() : null;
        }

        public final void setHlsS3Settings(HlsS3Settings.BuilderImpl hlsS3Settings) {
            this.hlsS3Settings = hlsS3Settings != null ? hlsS3Settings.build() : null;
        }

        @Override
        public final Builder hlsS3Settings(HlsS3Settings hlsS3Settings) {
            this.hlsS3Settings = hlsS3Settings;
            return this;
        }

        public final HlsWebdavSettings.Builder getHlsWebdavSettings() {
            return this.hlsWebdavSettings != null ? this.hlsWebdavSettings.toBuilder() : null;
        }

        public final void setHlsWebdavSettings(HlsWebdavSettings.BuilderImpl hlsWebdavSettings) {
            this.hlsWebdavSettings = hlsWebdavSettings != null ? hlsWebdavSettings.build() : null;
        }

        @Override
        public final Builder hlsWebdavSettings(HlsWebdavSettings hlsWebdavSettings) {
            this.hlsWebdavSettings = hlsWebdavSettings;
            return this;
        }

        public HlsCdnSettings build() {
            return new HlsCdnSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HlsCdnSettings> {
        public Builder hlsAkamaiSettings(HlsAkamaiSettings var1);

        default public Builder hlsAkamaiSettings(Consumer<HlsAkamaiSettings.Builder> hlsAkamaiSettings) {
            return this.hlsAkamaiSettings((HlsAkamaiSettings)((HlsAkamaiSettings.Builder)HlsAkamaiSettings.builder().applyMutation(hlsAkamaiSettings)).build());
        }

        public Builder hlsBasicPutSettings(HlsBasicPutSettings var1);

        default public Builder hlsBasicPutSettings(Consumer<HlsBasicPutSettings.Builder> hlsBasicPutSettings) {
            return this.hlsBasicPutSettings((HlsBasicPutSettings)((HlsBasicPutSettings.Builder)HlsBasicPutSettings.builder().applyMutation(hlsBasicPutSettings)).build());
        }

        public Builder hlsMediaStoreSettings(HlsMediaStoreSettings var1);

        default public Builder hlsMediaStoreSettings(Consumer<HlsMediaStoreSettings.Builder> hlsMediaStoreSettings) {
            return this.hlsMediaStoreSettings((HlsMediaStoreSettings)((HlsMediaStoreSettings.Builder)HlsMediaStoreSettings.builder().applyMutation(hlsMediaStoreSettings)).build());
        }

        public Builder hlsS3Settings(HlsS3Settings var1);

        default public Builder hlsS3Settings(Consumer<HlsS3Settings.Builder> hlsS3Settings) {
            return this.hlsS3Settings((HlsS3Settings)((HlsS3Settings.Builder)HlsS3Settings.builder().applyMutation(hlsS3Settings)).build());
        }

        public Builder hlsWebdavSettings(HlsWebdavSettings var1);

        default public Builder hlsWebdavSettings(Consumer<HlsWebdavSettings.Builder> hlsWebdavSettings) {
            return this.hlsWebdavSettings((HlsWebdavSettings)((HlsWebdavSettings.Builder)HlsWebdavSettings.builder().applyMutation(hlsWebdavSettings)).build());
        }
    }
}

