/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.medialive.model.MediaLiveRequest;
import software.amazon.awssdk.services.medialive.model.MultiplexPacketIdentifiersMappingCopier;
import software.amazon.awssdk.services.medialive.model.MultiplexProgramPacketIdentifiersMap;
import software.amazon.awssdk.services.medialive.model.MultiplexSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateMultiplexRequest
extends MediaLiveRequest
implements ToCopyableBuilder<Builder, UpdateMultiplexRequest> {
    private static final SdkField<String> MULTIPLEX_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MultiplexId").getter(UpdateMultiplexRequest.getter(UpdateMultiplexRequest::multiplexId)).setter(UpdateMultiplexRequest.setter(Builder::multiplexId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("multiplexId").build()}).build();
    private static final SdkField<MultiplexSettings> MULTIPLEX_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MultiplexSettings").getter(UpdateMultiplexRequest.getter(UpdateMultiplexRequest::multiplexSettings)).setter(UpdateMultiplexRequest.setter(Builder::multiplexSettings)).constructor(MultiplexSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiplexSettings").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateMultiplexRequest.getter(UpdateMultiplexRequest::name)).setter(UpdateMultiplexRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Map<String, MultiplexProgramPacketIdentifiersMap>> PACKET_IDENTIFIERS_MAPPING_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("PacketIdentifiersMapping").getter(UpdateMultiplexRequest.getter(UpdateMultiplexRequest::packetIdentifiersMapping)).setter(UpdateMultiplexRequest.setter(Builder::packetIdentifiersMapping)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packetIdentifiersMapping").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MultiplexProgramPacketIdentifiersMap::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MULTIPLEX_ID_FIELD, MULTIPLEX_SETTINGS_FIELD, NAME_FIELD, PACKET_IDENTIFIERS_MAPPING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateMultiplexRequest.memberNameToFieldInitializer();
    private final String multiplexId;
    private final MultiplexSettings multiplexSettings;
    private final String name;
    private final Map<String, MultiplexProgramPacketIdentifiersMap> packetIdentifiersMapping;

    private UpdateMultiplexRequest(BuilderImpl builder) {
        super(builder);
        this.multiplexId = builder.multiplexId;
        this.multiplexSettings = builder.multiplexSettings;
        this.name = builder.name;
        this.packetIdentifiersMapping = builder.packetIdentifiersMapping;
    }

    public final String multiplexId() {
        return this.multiplexId;
    }

    public final MultiplexSettings multiplexSettings() {
        return this.multiplexSettings;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasPacketIdentifiersMapping() {
        return this.packetIdentifiersMapping != null && !(this.packetIdentifiersMapping instanceof SdkAutoConstructMap);
    }

    public final Map<String, MultiplexProgramPacketIdentifiersMap> packetIdentifiersMapping() {
        return this.packetIdentifiersMapping;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.multiplexId());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiplexSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPacketIdentifiersMapping() ? this.packetIdentifiersMapping() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMultiplexRequest)) {
            return false;
        }
        UpdateMultiplexRequest other = (UpdateMultiplexRequest)((Object)obj);
        return Objects.equals(this.multiplexId(), other.multiplexId()) && Objects.equals(this.multiplexSettings(), other.multiplexSettings()) && Objects.equals(this.name(), other.name()) && this.hasPacketIdentifiersMapping() == other.hasPacketIdentifiersMapping() && Objects.equals(this.packetIdentifiersMapping(), other.packetIdentifiersMapping());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateMultiplexRequest").add("MultiplexId", (Object)this.multiplexId()).add("MultiplexSettings", (Object)this.multiplexSettings()).add("Name", (Object)this.name()).add("PacketIdentifiersMapping", this.hasPacketIdentifiersMapping() ? this.packetIdentifiersMapping() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MultiplexId": {
                return Optional.ofNullable(clazz.cast(this.multiplexId()));
            }
            case "MultiplexSettings": {
                return Optional.ofNullable(clazz.cast(this.multiplexSettings()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "PacketIdentifiersMapping": {
                return Optional.ofNullable(clazz.cast(this.packetIdentifiersMapping()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("multiplexId", MULTIPLEX_ID_FIELD);
        map.put("multiplexSettings", MULTIPLEX_SETTINGS_FIELD);
        map.put("name", NAME_FIELD);
        map.put("packetIdentifiersMapping", PACKET_IDENTIFIERS_MAPPING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateMultiplexRequest, T> g) {
        return obj -> g.apply((UpdateMultiplexRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveRequest.BuilderImpl
    implements Builder {
        private String multiplexId;
        private MultiplexSettings multiplexSettings;
        private String name;
        private Map<String, MultiplexProgramPacketIdentifiersMap> packetIdentifiersMapping = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMultiplexRequest model) {
            super(model);
            this.multiplexId(model.multiplexId);
            this.multiplexSettings(model.multiplexSettings);
            this.name(model.name);
            this.packetIdentifiersMapping(model.packetIdentifiersMapping);
        }

        public final String getMultiplexId() {
            return this.multiplexId;
        }

        public final void setMultiplexId(String multiplexId) {
            this.multiplexId = multiplexId;
        }

        @Override
        public final Builder multiplexId(String multiplexId) {
            this.multiplexId = multiplexId;
            return this;
        }

        public final MultiplexSettings.Builder getMultiplexSettings() {
            return this.multiplexSettings != null ? this.multiplexSettings.toBuilder() : null;
        }

        public final void setMultiplexSettings(MultiplexSettings.BuilderImpl multiplexSettings) {
            this.multiplexSettings = multiplexSettings != null ? multiplexSettings.build() : null;
        }

        @Override
        public final Builder multiplexSettings(MultiplexSettings multiplexSettings) {
            this.multiplexSettings = multiplexSettings;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, MultiplexProgramPacketIdentifiersMap.Builder> getPacketIdentifiersMapping() {
            Map<String, MultiplexProgramPacketIdentifiersMap.Builder> result = MultiplexPacketIdentifiersMappingCopier.copyToBuilder(this.packetIdentifiersMapping);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPacketIdentifiersMapping(Map<String, MultiplexProgramPacketIdentifiersMap.BuilderImpl> packetIdentifiersMapping) {
            this.packetIdentifiersMapping = MultiplexPacketIdentifiersMappingCopier.copyFromBuilder(packetIdentifiersMapping);
        }

        @Override
        public final Builder packetIdentifiersMapping(Map<String, MultiplexProgramPacketIdentifiersMap> packetIdentifiersMapping) {
            this.packetIdentifiersMapping = MultiplexPacketIdentifiersMappingCopier.copy(packetIdentifiersMapping);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMultiplexRequest build() {
            return new UpdateMultiplexRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MediaLiveRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateMultiplexRequest> {
        public Builder multiplexId(String var1);

        public Builder multiplexSettings(MultiplexSettings var1);

        default public Builder multiplexSettings(Consumer<MultiplexSettings.Builder> multiplexSettings) {
            return this.multiplexSettings((MultiplexSettings)((MultiplexSettings.Builder)MultiplexSettings.builder().applyMutation(multiplexSettings)).build());
        }

        public Builder name(String var1);

        public Builder packetIdentifiersMapping(Map<String, MultiplexProgramPacketIdentifiersMap> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

