/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.AnywhereSettings;
import software.amazon.awssdk.services.medialive.model.CdiInputSpecification;
import software.amazon.awssdk.services.medialive.model.ChannelEngineVersionRequest;
import software.amazon.awssdk.services.medialive.model.EncoderSettings;
import software.amazon.awssdk.services.medialive.model.InputAttachment;
import software.amazon.awssdk.services.medialive.model.InputSpecification;
import software.amazon.awssdk.services.medialive.model.LogLevel;
import software.amazon.awssdk.services.medialive.model.MaintenanceUpdateSettings;
import software.amazon.awssdk.services.medialive.model.MediaLiveRequest;
import software.amazon.awssdk.services.medialive.model.OutputDestination;
import software.amazon.awssdk.services.medialive.model.___listOfInputAttachmentCopier;
import software.amazon.awssdk.services.medialive.model.___listOfOutputDestinationCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateChannelRequest
extends MediaLiveRequest
implements ToCopyableBuilder<Builder, UpdateChannelRequest> {
    private static final SdkField<CdiInputSpecification> CDI_INPUT_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CdiInputSpecification").getter(UpdateChannelRequest.getter(UpdateChannelRequest::cdiInputSpecification)).setter(UpdateChannelRequest.setter(Builder::cdiInputSpecification)).constructor(CdiInputSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cdiInputSpecification").build()}).build();
    private static final SdkField<String> CHANNEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelId").getter(UpdateChannelRequest.getter(UpdateChannelRequest::channelId)).setter(UpdateChannelRequest.setter(Builder::channelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("channelId").build()}).build();
    private static final SdkField<List<OutputDestination>> DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Destinations").getter(UpdateChannelRequest.getter(UpdateChannelRequest::destinations)).setter(UpdateChannelRequest.setter(Builder::destinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OutputDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<EncoderSettings> ENCODER_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncoderSettings").getter(UpdateChannelRequest.getter(UpdateChannelRequest::encoderSettings)).setter(UpdateChannelRequest.setter(Builder::encoderSettings)).constructor(EncoderSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encoderSettings").build()}).build();
    private static final SdkField<List<InputAttachment>> INPUT_ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InputAttachments").getter(UpdateChannelRequest.getter(UpdateChannelRequest::inputAttachments)).setter(UpdateChannelRequest.setter(Builder::inputAttachments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputAttachments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputAttachment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<InputSpecification> INPUT_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InputSpecification").getter(UpdateChannelRequest.getter(UpdateChannelRequest::inputSpecification)).setter(UpdateChannelRequest.setter(Builder::inputSpecification)).constructor(InputSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputSpecification").build()}).build();
    private static final SdkField<String> LOG_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogLevel").getter(UpdateChannelRequest.getter(UpdateChannelRequest::logLevelAsString)).setter(UpdateChannelRequest.setter(Builder::logLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logLevel").build()}).build();
    private static final SdkField<MaintenanceUpdateSettings> MAINTENANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Maintenance").getter(UpdateChannelRequest.getter(UpdateChannelRequest::maintenance)).setter(UpdateChannelRequest.setter(Builder::maintenance)).constructor(MaintenanceUpdateSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenance").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateChannelRequest.getter(UpdateChannelRequest::name)).setter(UpdateChannelRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(UpdateChannelRequest.getter(UpdateChannelRequest::roleArn)).setter(UpdateChannelRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<ChannelEngineVersionRequest> CHANNEL_ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ChannelEngineVersion").getter(UpdateChannelRequest.getter(UpdateChannelRequest::channelEngineVersion)).setter(UpdateChannelRequest.setter(Builder::channelEngineVersion)).constructor(ChannelEngineVersionRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelEngineVersion").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(UpdateChannelRequest.getter(UpdateChannelRequest::dryRun)).setter(UpdateChannelRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dryRun").build()}).build();
    private static final SdkField<AnywhereSettings> ANYWHERE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AnywhereSettings").getter(UpdateChannelRequest.getter(UpdateChannelRequest::anywhereSettings)).setter(UpdateChannelRequest.setter(Builder::anywhereSettings)).constructor(AnywhereSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("anywhereSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CDI_INPUT_SPECIFICATION_FIELD, CHANNEL_ID_FIELD, DESTINATIONS_FIELD, ENCODER_SETTINGS_FIELD, INPUT_ATTACHMENTS_FIELD, INPUT_SPECIFICATION_FIELD, LOG_LEVEL_FIELD, MAINTENANCE_FIELD, NAME_FIELD, ROLE_ARN_FIELD, CHANNEL_ENGINE_VERSION_FIELD, DRY_RUN_FIELD, ANYWHERE_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateChannelRequest.memberNameToFieldInitializer();
    private final CdiInputSpecification cdiInputSpecification;
    private final String channelId;
    private final List<OutputDestination> destinations;
    private final EncoderSettings encoderSettings;
    private final List<InputAttachment> inputAttachments;
    private final InputSpecification inputSpecification;
    private final String logLevel;
    private final MaintenanceUpdateSettings maintenance;
    private final String name;
    private final String roleArn;
    private final ChannelEngineVersionRequest channelEngineVersion;
    private final Boolean dryRun;
    private final AnywhereSettings anywhereSettings;

    private UpdateChannelRequest(BuilderImpl builder) {
        super(builder);
        this.cdiInputSpecification = builder.cdiInputSpecification;
        this.channelId = builder.channelId;
        this.destinations = builder.destinations;
        this.encoderSettings = builder.encoderSettings;
        this.inputAttachments = builder.inputAttachments;
        this.inputSpecification = builder.inputSpecification;
        this.logLevel = builder.logLevel;
        this.maintenance = builder.maintenance;
        this.name = builder.name;
        this.roleArn = builder.roleArn;
        this.channelEngineVersion = builder.channelEngineVersion;
        this.dryRun = builder.dryRun;
        this.anywhereSettings = builder.anywhereSettings;
    }

    public final CdiInputSpecification cdiInputSpecification() {
        return this.cdiInputSpecification;
    }

    public final String channelId() {
        return this.channelId;
    }

    public final boolean hasDestinations() {
        return this.destinations != null && !(this.destinations instanceof SdkAutoConstructList);
    }

    public final List<OutputDestination> destinations() {
        return this.destinations;
    }

    public final EncoderSettings encoderSettings() {
        return this.encoderSettings;
    }

    public final boolean hasInputAttachments() {
        return this.inputAttachments != null && !(this.inputAttachments instanceof SdkAutoConstructList);
    }

    public final List<InputAttachment> inputAttachments() {
        return this.inputAttachments;
    }

    public final InputSpecification inputSpecification() {
        return this.inputSpecification;
    }

    public final LogLevel logLevel() {
        return LogLevel.fromValue(this.logLevel);
    }

    public final String logLevelAsString() {
        return this.logLevel;
    }

    public final MaintenanceUpdateSettings maintenance() {
        return this.maintenance;
    }

    public final String name() {
        return this.name;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final ChannelEngineVersionRequest channelEngineVersion() {
        return this.channelEngineVersion;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final AnywhereSettings anywhereSettings() {
        return this.anywhereSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cdiInputSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinations() ? this.destinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.encoderSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputAttachments() ? this.inputAttachments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.inputSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.logLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenance());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelEngineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.anywhereSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateChannelRequest)) {
            return false;
        }
        UpdateChannelRequest other = (UpdateChannelRequest)((Object)obj);
        return Objects.equals(this.cdiInputSpecification(), other.cdiInputSpecification()) && Objects.equals(this.channelId(), other.channelId()) && this.hasDestinations() == other.hasDestinations() && Objects.equals(this.destinations(), other.destinations()) && Objects.equals(this.encoderSettings(), other.encoderSettings()) && this.hasInputAttachments() == other.hasInputAttachments() && Objects.equals(this.inputAttachments(), other.inputAttachments()) && Objects.equals(this.inputSpecification(), other.inputSpecification()) && Objects.equals(this.logLevelAsString(), other.logLevelAsString()) && Objects.equals(this.maintenance(), other.maintenance()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.channelEngineVersion(), other.channelEngineVersion()) && Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.anywhereSettings(), other.anywhereSettings());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateChannelRequest").add("CdiInputSpecification", (Object)this.cdiInputSpecification()).add("ChannelId", (Object)this.channelId()).add("Destinations", this.hasDestinations() ? this.destinations() : null).add("EncoderSettings", (Object)this.encoderSettings()).add("InputAttachments", this.hasInputAttachments() ? this.inputAttachments() : null).add("InputSpecification", (Object)this.inputSpecification()).add("LogLevel", (Object)this.logLevelAsString()).add("Maintenance", (Object)this.maintenance()).add("Name", (Object)this.name()).add("RoleArn", (Object)this.roleArn()).add("ChannelEngineVersion", (Object)this.channelEngineVersion()).add("DryRun", (Object)this.dryRun()).add("AnywhereSettings", (Object)this.anywhereSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CdiInputSpecification": {
                return Optional.ofNullable(clazz.cast(this.cdiInputSpecification()));
            }
            case "ChannelId": {
                return Optional.ofNullable(clazz.cast(this.channelId()));
            }
            case "Destinations": {
                return Optional.ofNullable(clazz.cast(this.destinations()));
            }
            case "EncoderSettings": {
                return Optional.ofNullable(clazz.cast(this.encoderSettings()));
            }
            case "InputAttachments": {
                return Optional.ofNullable(clazz.cast(this.inputAttachments()));
            }
            case "InputSpecification": {
                return Optional.ofNullable(clazz.cast(this.inputSpecification()));
            }
            case "LogLevel": {
                return Optional.ofNullable(clazz.cast(this.logLevelAsString()));
            }
            case "Maintenance": {
                return Optional.ofNullable(clazz.cast(this.maintenance()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "ChannelEngineVersion": {
                return Optional.ofNullable(clazz.cast(this.channelEngineVersion()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "AnywhereSettings": {
                return Optional.ofNullable(clazz.cast(this.anywhereSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cdiInputSpecification", CDI_INPUT_SPECIFICATION_FIELD);
        map.put("channelId", CHANNEL_ID_FIELD);
        map.put("destinations", DESTINATIONS_FIELD);
        map.put("encoderSettings", ENCODER_SETTINGS_FIELD);
        map.put("inputAttachments", INPUT_ATTACHMENTS_FIELD);
        map.put("inputSpecification", INPUT_SPECIFICATION_FIELD);
        map.put("logLevel", LOG_LEVEL_FIELD);
        map.put("maintenance", MAINTENANCE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("channelEngineVersion", CHANNEL_ENGINE_VERSION_FIELD);
        map.put("dryRun", DRY_RUN_FIELD);
        map.put("anywhereSettings", ANYWHERE_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateChannelRequest, T> g) {
        return obj -> g.apply((UpdateChannelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveRequest.BuilderImpl
    implements Builder {
        private CdiInputSpecification cdiInputSpecification;
        private String channelId;
        private List<OutputDestination> destinations = DefaultSdkAutoConstructList.getInstance();
        private EncoderSettings encoderSettings;
        private List<InputAttachment> inputAttachments = DefaultSdkAutoConstructList.getInstance();
        private InputSpecification inputSpecification;
        private String logLevel;
        private MaintenanceUpdateSettings maintenance;
        private String name;
        private String roleArn;
        private ChannelEngineVersionRequest channelEngineVersion;
        private Boolean dryRun;
        private AnywhereSettings anywhereSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateChannelRequest model) {
            super(model);
            this.cdiInputSpecification(model.cdiInputSpecification);
            this.channelId(model.channelId);
            this.destinations(model.destinations);
            this.encoderSettings(model.encoderSettings);
            this.inputAttachments(model.inputAttachments);
            this.inputSpecification(model.inputSpecification);
            this.logLevel(model.logLevel);
            this.maintenance(model.maintenance);
            this.name(model.name);
            this.roleArn(model.roleArn);
            this.channelEngineVersion(model.channelEngineVersion);
            this.dryRun(model.dryRun);
            this.anywhereSettings(model.anywhereSettings);
        }

        public final CdiInputSpecification.Builder getCdiInputSpecification() {
            return this.cdiInputSpecification != null ? this.cdiInputSpecification.toBuilder() : null;
        }

        public final void setCdiInputSpecification(CdiInputSpecification.BuilderImpl cdiInputSpecification) {
            this.cdiInputSpecification = cdiInputSpecification != null ? cdiInputSpecification.build() : null;
        }

        @Override
        public final Builder cdiInputSpecification(CdiInputSpecification cdiInputSpecification) {
            this.cdiInputSpecification = cdiInputSpecification;
            return this;
        }

        public final String getChannelId() {
            return this.channelId;
        }

        public final void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @Override
        public final Builder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public final List<OutputDestination.Builder> getDestinations() {
            List<OutputDestination.Builder> result = ___listOfOutputDestinationCopier.copyToBuilder(this.destinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinations(Collection<OutputDestination.BuilderImpl> destinations) {
            this.destinations = ___listOfOutputDestinationCopier.copyFromBuilder(destinations);
        }

        @Override
        public final Builder destinations(Collection<OutputDestination> destinations) {
            this.destinations = ___listOfOutputDestinationCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(OutputDestination ... destinations) {
            this.destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<OutputDestination.Builder> ... destinations) {
            this.destinations(Stream.of(destinations).map(c -> (OutputDestination)((OutputDestination.Builder)OutputDestination.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final EncoderSettings.Builder getEncoderSettings() {
            return this.encoderSettings != null ? this.encoderSettings.toBuilder() : null;
        }

        public final void setEncoderSettings(EncoderSettings.BuilderImpl encoderSettings) {
            this.encoderSettings = encoderSettings != null ? encoderSettings.build() : null;
        }

        @Override
        public final Builder encoderSettings(EncoderSettings encoderSettings) {
            this.encoderSettings = encoderSettings;
            return this;
        }

        public final List<InputAttachment.Builder> getInputAttachments() {
            List<InputAttachment.Builder> result = ___listOfInputAttachmentCopier.copyToBuilder(this.inputAttachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputAttachments(Collection<InputAttachment.BuilderImpl> inputAttachments) {
            this.inputAttachments = ___listOfInputAttachmentCopier.copyFromBuilder(inputAttachments);
        }

        @Override
        public final Builder inputAttachments(Collection<InputAttachment> inputAttachments) {
            this.inputAttachments = ___listOfInputAttachmentCopier.copy(inputAttachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputAttachments(InputAttachment ... inputAttachments) {
            this.inputAttachments(Arrays.asList(inputAttachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputAttachments(Consumer<InputAttachment.Builder> ... inputAttachments) {
            this.inputAttachments(Stream.of(inputAttachments).map(c -> (InputAttachment)((InputAttachment.Builder)InputAttachment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final InputSpecification.Builder getInputSpecification() {
            return this.inputSpecification != null ? this.inputSpecification.toBuilder() : null;
        }

        public final void setInputSpecification(InputSpecification.BuilderImpl inputSpecification) {
            this.inputSpecification = inputSpecification != null ? inputSpecification.build() : null;
        }

        @Override
        public final Builder inputSpecification(InputSpecification inputSpecification) {
            this.inputSpecification = inputSpecification;
            return this;
        }

        public final String getLogLevel() {
            return this.logLevel;
        }

        public final void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }

        @Override
        public final Builder logLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        @Override
        public final Builder logLevel(LogLevel logLevel) {
            this.logLevel(logLevel == null ? null : logLevel.toString());
            return this;
        }

        public final MaintenanceUpdateSettings.Builder getMaintenance() {
            return this.maintenance != null ? this.maintenance.toBuilder() : null;
        }

        public final void setMaintenance(MaintenanceUpdateSettings.BuilderImpl maintenance) {
            this.maintenance = maintenance != null ? maintenance.build() : null;
        }

        @Override
        public final Builder maintenance(MaintenanceUpdateSettings maintenance) {
            this.maintenance = maintenance;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final ChannelEngineVersionRequest.Builder getChannelEngineVersion() {
            return this.channelEngineVersion != null ? this.channelEngineVersion.toBuilder() : null;
        }

        public final void setChannelEngineVersion(ChannelEngineVersionRequest.BuilderImpl channelEngineVersion) {
            this.channelEngineVersion = channelEngineVersion != null ? channelEngineVersion.build() : null;
        }

        @Override
        public final Builder channelEngineVersion(ChannelEngineVersionRequest channelEngineVersion) {
            this.channelEngineVersion = channelEngineVersion;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final AnywhereSettings.Builder getAnywhereSettings() {
            return this.anywhereSettings != null ? this.anywhereSettings.toBuilder() : null;
        }

        public final void setAnywhereSettings(AnywhereSettings.BuilderImpl anywhereSettings) {
            this.anywhereSettings = anywhereSettings != null ? anywhereSettings.build() : null;
        }

        @Override
        public final Builder anywhereSettings(AnywhereSettings anywhereSettings) {
            this.anywhereSettings = anywhereSettings;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateChannelRequest build() {
            return new UpdateChannelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MediaLiveRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateChannelRequest> {
        public Builder cdiInputSpecification(CdiInputSpecification var1);

        default public Builder cdiInputSpecification(Consumer<CdiInputSpecification.Builder> cdiInputSpecification) {
            return this.cdiInputSpecification((CdiInputSpecification)((CdiInputSpecification.Builder)CdiInputSpecification.builder().applyMutation(cdiInputSpecification)).build());
        }

        public Builder channelId(String var1);

        public Builder destinations(Collection<OutputDestination> var1);

        public Builder destinations(OutputDestination ... var1);

        public Builder destinations(Consumer<OutputDestination.Builder> ... var1);

        public Builder encoderSettings(EncoderSettings var1);

        default public Builder encoderSettings(Consumer<EncoderSettings.Builder> encoderSettings) {
            return this.encoderSettings((EncoderSettings)((EncoderSettings.Builder)EncoderSettings.builder().applyMutation(encoderSettings)).build());
        }

        public Builder inputAttachments(Collection<InputAttachment> var1);

        public Builder inputAttachments(InputAttachment ... var1);

        public Builder inputAttachments(Consumer<InputAttachment.Builder> ... var1);

        public Builder inputSpecification(InputSpecification var1);

        default public Builder inputSpecification(Consumer<InputSpecification.Builder> inputSpecification) {
            return this.inputSpecification((InputSpecification)((InputSpecification.Builder)InputSpecification.builder().applyMutation(inputSpecification)).build());
        }

        public Builder logLevel(String var1);

        public Builder logLevel(LogLevel var1);

        public Builder maintenance(MaintenanceUpdateSettings var1);

        default public Builder maintenance(Consumer<MaintenanceUpdateSettings.Builder> maintenance) {
            return this.maintenance((MaintenanceUpdateSettings)((MaintenanceUpdateSettings.Builder)MaintenanceUpdateSettings.builder().applyMutation(maintenance)).build());
        }

        public Builder name(String var1);

        public Builder roleArn(String var1);

        public Builder channelEngineVersion(ChannelEngineVersionRequest var1);

        default public Builder channelEngineVersion(Consumer<ChannelEngineVersionRequest.Builder> channelEngineVersion) {
            return this.channelEngineVersion((ChannelEngineVersionRequest)((ChannelEngineVersionRequest.Builder)ChannelEngineVersionRequest.builder().applyMutation(channelEngineVersion)).build());
        }

        public Builder dryRun(Boolean var1);

        public Builder anywhereSettings(AnywhereSettings var1);

        default public Builder anywhereSettings(Consumer<AnywhereSettings.Builder> anywhereSettings) {
            return this.anywhereSettings((AnywhereSettings)((AnywhereSettings.Builder)AnywhereSettings.builder().applyMutation(anywhereSettings)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

