/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.MediaLiveResponse;
import software.amazon.awssdk.services.medialive.model.SdiSourceSummary;
import software.amazon.awssdk.services.medialive.model.___listOfSdiSourceSummaryCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSdiSourcesResponse
extends MediaLiveResponse
implements ToCopyableBuilder<Builder, ListSdiSourcesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListSdiSourcesResponse.getter(ListSdiSourcesResponse::nextToken)).setter(ListSdiSourcesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<SdiSourceSummary>> SDI_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SdiSources").getter(ListSdiSourcesResponse.getter(ListSdiSourcesResponse::sdiSources)).setter(ListSdiSourcesResponse.setter(Builder::sdiSources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sdiSources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SdiSourceSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SDI_SOURCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListSdiSourcesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<SdiSourceSummary> sdiSources;

    private ListSdiSourcesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.sdiSources = builder.sdiSources;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasSdiSources() {
        return this.sdiSources != null && !(this.sdiSources instanceof SdkAutoConstructList);
    }

    public final List<SdiSourceSummary> sdiSources() {
        return this.sdiSources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSdiSources() ? this.sdiSources() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSdiSourcesResponse)) {
            return false;
        }
        ListSdiSourcesResponse other = (ListSdiSourcesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasSdiSources() == other.hasSdiSources() && Objects.equals(this.sdiSources(), other.sdiSources());
    }

    public final String toString() {
        return ToString.builder((String)"ListSdiSourcesResponse").add("NextToken", (Object)this.nextToken()).add("SdiSources", this.hasSdiSources() ? this.sdiSources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "SdiSources": {
                return Optional.ofNullable(clazz.cast(this.sdiSources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("sdiSources", SDI_SOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSdiSourcesResponse, T> g) {
        return obj -> g.apply((ListSdiSourcesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<SdiSourceSummary> sdiSources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSdiSourcesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.sdiSources(model.sdiSources);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<SdiSourceSummary.Builder> getSdiSources() {
            List<SdiSourceSummary.Builder> result = ___listOfSdiSourceSummaryCopier.copyToBuilder(this.sdiSources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSdiSources(Collection<SdiSourceSummary.BuilderImpl> sdiSources) {
            this.sdiSources = ___listOfSdiSourceSummaryCopier.copyFromBuilder(sdiSources);
        }

        @Override
        public final Builder sdiSources(Collection<SdiSourceSummary> sdiSources) {
            this.sdiSources = ___listOfSdiSourceSummaryCopier.copy(sdiSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sdiSources(SdiSourceSummary ... sdiSources) {
            this.sdiSources(Arrays.asList(sdiSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sdiSources(Consumer<SdiSourceSummary.Builder> ... sdiSources) {
            this.sdiSources(Stream.of(sdiSources).map(c -> (SdiSourceSummary)((SdiSourceSummary.Builder)SdiSourceSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListSdiSourcesResponse build() {
            return new ListSdiSourcesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MediaLiveResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSdiSourcesResponse> {
        public Builder nextToken(String var1);

        public Builder sdiSources(Collection<SdiSourceSummary> var1);

        public Builder sdiSources(SdiSourceSummary ... var1);

        public Builder sdiSources(Consumer<SdiSourceSummary.Builder> ... var1);
    }
}

