/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SdiSourceType {
    SINGLE("SINGLE"),
    QUAD("QUAD"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SdiSourceType> VALUE_MAP;
    private final String value;

    private SdiSourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SdiSourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SdiSourceType> knownValues() {
        EnumSet<SdiSourceType> knownValues = EnumSet.allOf(SdiSourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SdiSourceType.class, SdiSourceType::toString);
    }
}

