/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.VideoCodecSettings;
import software.amazon.awssdk.services.medialive.model.VideoDescriptionRespondToAfd;
import software.amazon.awssdk.services.medialive.model.VideoDescriptionScalingBehavior;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VideoDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VideoDescription> {
    private static final SdkField<VideoCodecSettings> CODEC_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CodecSettings").getter(VideoDescription.getter(VideoDescription::codecSettings)).setter(VideoDescription.setter(Builder::codecSettings)).constructor(VideoCodecSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codecSettings").build()}).build();
    private static final SdkField<Integer> HEIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Height").getter(VideoDescription.getter(VideoDescription::height)).setter(VideoDescription.setter(Builder::height)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("height").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(VideoDescription.getter(VideoDescription::name)).setter(VideoDescription.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> RESPOND_TO_AFD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RespondToAfd").getter(VideoDescription.getter(VideoDescription::respondToAfdAsString)).setter(VideoDescription.setter(Builder::respondToAfd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("respondToAfd").build()}).build();
    private static final SdkField<String> SCALING_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScalingBehavior").getter(VideoDescription.getter(VideoDescription::scalingBehaviorAsString)).setter(VideoDescription.setter(Builder::scalingBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scalingBehavior").build()}).build();
    private static final SdkField<Integer> SHARPNESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Sharpness").getter(VideoDescription.getter(VideoDescription::sharpness)).setter(VideoDescription.setter(Builder::sharpness)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sharpness").build()}).build();
    private static final SdkField<Integer> WIDTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Width").getter(VideoDescription.getter(VideoDescription::width)).setter(VideoDescription.setter(Builder::width)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("width").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODEC_SETTINGS_FIELD, HEIGHT_FIELD, NAME_FIELD, RESPOND_TO_AFD_FIELD, SCALING_BEHAVIOR_FIELD, SHARPNESS_FIELD, WIDTH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VideoDescription.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final VideoCodecSettings codecSettings;
    private final Integer height;
    private final String name;
    private final String respondToAfd;
    private final String scalingBehavior;
    private final Integer sharpness;
    private final Integer width;

    private VideoDescription(BuilderImpl builder) {
        this.codecSettings = builder.codecSettings;
        this.height = builder.height;
        this.name = builder.name;
        this.respondToAfd = builder.respondToAfd;
        this.scalingBehavior = builder.scalingBehavior;
        this.sharpness = builder.sharpness;
        this.width = builder.width;
    }

    public final VideoCodecSettings codecSettings() {
        return this.codecSettings;
    }

    public final Integer height() {
        return this.height;
    }

    public final String name() {
        return this.name;
    }

    public final VideoDescriptionRespondToAfd respondToAfd() {
        return VideoDescriptionRespondToAfd.fromValue(this.respondToAfd);
    }

    public final String respondToAfdAsString() {
        return this.respondToAfd;
    }

    public final VideoDescriptionScalingBehavior scalingBehavior() {
        return VideoDescriptionScalingBehavior.fromValue(this.scalingBehavior);
    }

    public final String scalingBehaviorAsString() {
        return this.scalingBehavior;
    }

    public final Integer sharpness() {
        return this.sharpness;
    }

    public final Integer width() {
        return this.width;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.codecSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.height());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.respondToAfdAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sharpness());
        hashCode = 31 * hashCode + Objects.hashCode(this.width());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoDescription)) {
            return false;
        }
        VideoDescription other = (VideoDescription)obj;
        return Objects.equals(this.codecSettings(), other.codecSettings()) && Objects.equals(this.height(), other.height()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.respondToAfdAsString(), other.respondToAfdAsString()) && Objects.equals(this.scalingBehaviorAsString(), other.scalingBehaviorAsString()) && Objects.equals(this.sharpness(), other.sharpness()) && Objects.equals(this.width(), other.width());
    }

    public final String toString() {
        return ToString.builder((String)"VideoDescription").add("CodecSettings", (Object)this.codecSettings()).add("Height", (Object)this.height()).add("Name", (Object)this.name()).add("RespondToAfd", (Object)this.respondToAfdAsString()).add("ScalingBehavior", (Object)this.scalingBehaviorAsString()).add("Sharpness", (Object)this.sharpness()).add("Width", (Object)this.width()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CodecSettings": {
                return Optional.ofNullable(clazz.cast(this.codecSettings()));
            }
            case "Height": {
                return Optional.ofNullable(clazz.cast(this.height()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RespondToAfd": {
                return Optional.ofNullable(clazz.cast(this.respondToAfdAsString()));
            }
            case "ScalingBehavior": {
                return Optional.ofNullable(clazz.cast(this.scalingBehaviorAsString()));
            }
            case "Sharpness": {
                return Optional.ofNullable(clazz.cast(this.sharpness()));
            }
            case "Width": {
                return Optional.ofNullable(clazz.cast(this.width()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("codecSettings", CODEC_SETTINGS_FIELD);
        map.put("height", HEIGHT_FIELD);
        map.put("name", NAME_FIELD);
        map.put("respondToAfd", RESPOND_TO_AFD_FIELD);
        map.put("scalingBehavior", SCALING_BEHAVIOR_FIELD);
        map.put("sharpness", SHARPNESS_FIELD);
        map.put("width", WIDTH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VideoDescription, T> g) {
        return obj -> g.apply((VideoDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private VideoCodecSettings codecSettings;
        private Integer height;
        private String name;
        private String respondToAfd;
        private String scalingBehavior;
        private Integer sharpness;
        private Integer width;

        private BuilderImpl() {
        }

        private BuilderImpl(VideoDescription model) {
            this.codecSettings(model.codecSettings);
            this.height(model.height);
            this.name(model.name);
            this.respondToAfd(model.respondToAfd);
            this.scalingBehavior(model.scalingBehavior);
            this.sharpness(model.sharpness);
            this.width(model.width);
        }

        public final VideoCodecSettings.Builder getCodecSettings() {
            return this.codecSettings != null ? this.codecSettings.toBuilder() : null;
        }

        public final void setCodecSettings(VideoCodecSettings.BuilderImpl codecSettings) {
            this.codecSettings = codecSettings != null ? codecSettings.build() : null;
        }

        @Override
        public final Builder codecSettings(VideoCodecSettings codecSettings) {
            this.codecSettings = codecSettings;
            return this;
        }

        public final Integer getHeight() {
            return this.height;
        }

        public final void setHeight(Integer height) {
            this.height = height;
        }

        @Override
        public final Builder height(Integer height) {
            this.height = height;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRespondToAfd() {
            return this.respondToAfd;
        }

        public final void setRespondToAfd(String respondToAfd) {
            this.respondToAfd = respondToAfd;
        }

        @Override
        public final Builder respondToAfd(String respondToAfd) {
            this.respondToAfd = respondToAfd;
            return this;
        }

        @Override
        public final Builder respondToAfd(VideoDescriptionRespondToAfd respondToAfd) {
            this.respondToAfd(respondToAfd == null ? null : respondToAfd.toString());
            return this;
        }

        public final String getScalingBehavior() {
            return this.scalingBehavior;
        }

        public final void setScalingBehavior(String scalingBehavior) {
            this.scalingBehavior = scalingBehavior;
        }

        @Override
        public final Builder scalingBehavior(String scalingBehavior) {
            this.scalingBehavior = scalingBehavior;
            return this;
        }

        @Override
        public final Builder scalingBehavior(VideoDescriptionScalingBehavior scalingBehavior) {
            this.scalingBehavior(scalingBehavior == null ? null : scalingBehavior.toString());
            return this;
        }

        public final Integer getSharpness() {
            return this.sharpness;
        }

        public final void setSharpness(Integer sharpness) {
            this.sharpness = sharpness;
        }

        @Override
        public final Builder sharpness(Integer sharpness) {
            this.sharpness = sharpness;
            return this;
        }

        public final Integer getWidth() {
            return this.width;
        }

        public final void setWidth(Integer width) {
            this.width = width;
        }

        @Override
        public final Builder width(Integer width) {
            this.width = width;
            return this;
        }

        public VideoDescription build() {
            return new VideoDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VideoDescription> {
        public Builder codecSettings(VideoCodecSettings var1);

        default public Builder codecSettings(Consumer<VideoCodecSettings.Builder> codecSettings) {
            return this.codecSettings((VideoCodecSettings)((VideoCodecSettings.Builder)VideoCodecSettings.builder().applyMutation(codecSettings)).build());
        }

        public Builder height(Integer var1);

        public Builder name(String var1);

        public Builder respondToAfd(String var1);

        public Builder respondToAfd(VideoDescriptionRespondToAfd var1);

        public Builder scalingBehavior(String var1);

        public Builder scalingBehavior(VideoDescriptionScalingBehavior var1);

        public Builder sharpness(Integer var1);

        public Builder width(Integer var1);
    }
}

