/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.OutputLocationRef;
import software.amazon.awssdk.services.medialive.model.SrtEncryptionType;
import software.amazon.awssdk.services.medialive.model.UdpContainerSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SrtOutputSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SrtOutputSettings> {
    private static final SdkField<Integer> BUFFER_MSEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BufferMsec").getter(SrtOutputSettings.getter(SrtOutputSettings::bufferMsec)).setter(SrtOutputSettings.setter(Builder::bufferMsec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bufferMsec").build()}).build();
    private static final SdkField<UdpContainerSettings> CONTAINER_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ContainerSettings").getter(SrtOutputSettings.getter(SrtOutputSettings::containerSettings)).setter(SrtOutputSettings.setter(Builder::containerSettings)).constructor(UdpContainerSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerSettings").build()}).build();
    private static final SdkField<OutputLocationRef> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Destination").getter(SrtOutputSettings.getter(SrtOutputSettings::destination)).setter(SrtOutputSettings.setter(Builder::destination)).constructor(OutputLocationRef::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()}).build();
    private static final SdkField<String> ENCRYPTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionType").getter(SrtOutputSettings.getter(SrtOutputSettings::encryptionTypeAsString)).setter(SrtOutputSettings.setter(Builder::encryptionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionType").build()}).build();
    private static final SdkField<Integer> LATENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Latency").getter(SrtOutputSettings.getter(SrtOutputSettings::latency)).setter(SrtOutputSettings.setter(Builder::latency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latency").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUFFER_MSEC_FIELD, CONTAINER_SETTINGS_FIELD, DESTINATION_FIELD, ENCRYPTION_TYPE_FIELD, LATENCY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SrtOutputSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer bufferMsec;
    private final UdpContainerSettings containerSettings;
    private final OutputLocationRef destination;
    private final String encryptionType;
    private final Integer latency;

    private SrtOutputSettings(BuilderImpl builder) {
        this.bufferMsec = builder.bufferMsec;
        this.containerSettings = builder.containerSettings;
        this.destination = builder.destination;
        this.encryptionType = builder.encryptionType;
        this.latency = builder.latency;
    }

    public final Integer bufferMsec() {
        return this.bufferMsec;
    }

    public final UdpContainerSettings containerSettings() {
        return this.containerSettings;
    }

    public final OutputLocationRef destination() {
        return this.destination;
    }

    public final SrtEncryptionType encryptionType() {
        return SrtEncryptionType.fromValue(this.encryptionType);
    }

    public final String encryptionTypeAsString() {
        return this.encryptionType;
    }

    public final Integer latency() {
        return this.latency;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bufferMsec());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.latency());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SrtOutputSettings)) {
            return false;
        }
        SrtOutputSettings other = (SrtOutputSettings)obj;
        return Objects.equals(this.bufferMsec(), other.bufferMsec()) && Objects.equals(this.containerSettings(), other.containerSettings()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.encryptionTypeAsString(), other.encryptionTypeAsString()) && Objects.equals(this.latency(), other.latency());
    }

    public final String toString() {
        return ToString.builder((String)"SrtOutputSettings").add("BufferMsec", (Object)this.bufferMsec()).add("ContainerSettings", (Object)this.containerSettings()).add("Destination", (Object)this.destination()).add("EncryptionType", (Object)this.encryptionTypeAsString()).add("Latency", (Object)this.latency()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BufferMsec": {
                return Optional.ofNullable(clazz.cast(this.bufferMsec()));
            }
            case "ContainerSettings": {
                return Optional.ofNullable(clazz.cast(this.containerSettings()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "EncryptionType": {
                return Optional.ofNullable(clazz.cast(this.encryptionTypeAsString()));
            }
            case "Latency": {
                return Optional.ofNullable(clazz.cast(this.latency()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("bufferMsec", BUFFER_MSEC_FIELD);
        map.put("containerSettings", CONTAINER_SETTINGS_FIELD);
        map.put("destination", DESTINATION_FIELD);
        map.put("encryptionType", ENCRYPTION_TYPE_FIELD);
        map.put("latency", LATENCY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SrtOutputSettings, T> g) {
        return obj -> g.apply((SrtOutputSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer bufferMsec;
        private UdpContainerSettings containerSettings;
        private OutputLocationRef destination;
        private String encryptionType;
        private Integer latency;

        private BuilderImpl() {
        }

        private BuilderImpl(SrtOutputSettings model) {
            this.bufferMsec(model.bufferMsec);
            this.containerSettings(model.containerSettings);
            this.destination(model.destination);
            this.encryptionType(model.encryptionType);
            this.latency(model.latency);
        }

        public final Integer getBufferMsec() {
            return this.bufferMsec;
        }

        public final void setBufferMsec(Integer bufferMsec) {
            this.bufferMsec = bufferMsec;
        }

        @Override
        public final Builder bufferMsec(Integer bufferMsec) {
            this.bufferMsec = bufferMsec;
            return this;
        }

        public final UdpContainerSettings.Builder getContainerSettings() {
            return this.containerSettings != null ? this.containerSettings.toBuilder() : null;
        }

        public final void setContainerSettings(UdpContainerSettings.BuilderImpl containerSettings) {
            this.containerSettings = containerSettings != null ? containerSettings.build() : null;
        }

        @Override
        public final Builder containerSettings(UdpContainerSettings containerSettings) {
            this.containerSettings = containerSettings;
            return this;
        }

        public final OutputLocationRef.Builder getDestination() {
            return this.destination != null ? this.destination.toBuilder() : null;
        }

        public final void setDestination(OutputLocationRef.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(OutputLocationRef destination) {
            this.destination = destination;
            return this;
        }

        public final String getEncryptionType() {
            return this.encryptionType;
        }

        public final void setEncryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
        }

        @Override
        public final Builder encryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
            return this;
        }

        @Override
        public final Builder encryptionType(SrtEncryptionType encryptionType) {
            this.encryptionType(encryptionType == null ? null : encryptionType.toString());
            return this;
        }

        public final Integer getLatency() {
            return this.latency;
        }

        public final void setLatency(Integer latency) {
            this.latency = latency;
        }

        @Override
        public final Builder latency(Integer latency) {
            this.latency = latency;
            return this;
        }

        public SrtOutputSettings build() {
            return new SrtOutputSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SrtOutputSettings> {
        public Builder bufferMsec(Integer var1);

        public Builder containerSettings(UdpContainerSettings var1);

        default public Builder containerSettings(Consumer<UdpContainerSettings.Builder> containerSettings) {
            return this.containerSettings((UdpContainerSettings)((UdpContainerSettings.Builder)UdpContainerSettings.builder().applyMutation(containerSettings)).build());
        }

        public Builder destination(OutputLocationRef var1);

        default public Builder destination(Consumer<OutputLocationRef.Builder> destination) {
            return this.destination((OutputLocationRef)((OutputLocationRef.Builder)OutputLocationRef.builder().applyMutation(destination)).build());
        }

        public Builder encryptionType(String var1);

        public Builder encryptionType(SrtEncryptionType var1);

        public Builder latency(Integer var1);
    }
}

