/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.medialive.model.InputClass;
import software.amazon.awssdk.services.medialive.model.InputDestination;
import software.amazon.awssdk.services.medialive.model.InputDeviceSettings;
import software.amazon.awssdk.services.medialive.model.InputNetworkLocation;
import software.amazon.awssdk.services.medialive.model.InputSource;
import software.amazon.awssdk.services.medialive.model.InputSourceType;
import software.amazon.awssdk.services.medialive.model.InputState;
import software.amazon.awssdk.services.medialive.model.InputType;
import software.amazon.awssdk.services.medialive.model.MediaConnectFlow;
import software.amazon.awssdk.services.medialive.model.MediaLiveResponse;
import software.amazon.awssdk.services.medialive.model.MulticastSettings;
import software.amazon.awssdk.services.medialive.model.SrtSettings;
import software.amazon.awssdk.services.medialive.model.TagsCopier;
import software.amazon.awssdk.services.medialive.model.___listOfInputDestinationCopier;
import software.amazon.awssdk.services.medialive.model.___listOfInputDeviceSettingsCopier;
import software.amazon.awssdk.services.medialive.model.___listOfInputSourceCopier;
import software.amazon.awssdk.services.medialive.model.___listOfMediaConnectFlowCopier;
import software.amazon.awssdk.services.medialive.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeInputResponse
extends MediaLiveResponse
implements ToCopyableBuilder<Builder, DescribeInputResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(DescribeInputResponse.getter(DescribeInputResponse::arn)).setter(DescribeInputResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<List<String>> ATTACHED_CHANNELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AttachedChannels").getter(DescribeInputResponse.getter(DescribeInputResponse::attachedChannels)).setter(DescribeInputResponse.setter(Builder::attachedChannels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachedChannels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<InputDestination>> DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Destinations").getter(DescribeInputResponse.getter(DescribeInputResponse::destinations)).setter(DescribeInputResponse.setter(Builder::destinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(DescribeInputResponse.getter(DescribeInputResponse::id)).setter(DescribeInputResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> INPUT_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputClass").getter(DescribeInputResponse.getter(DescribeInputResponse::inputClassAsString)).setter(DescribeInputResponse.setter(Builder::inputClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputClass").build()}).build();
    private static final SdkField<List<InputDeviceSettings>> INPUT_DEVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InputDevices").getter(DescribeInputResponse.getter(DescribeInputResponse::inputDevices)).setter(DescribeInputResponse.setter(Builder::inputDevices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputDevices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputDeviceSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> INPUT_PARTNER_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InputPartnerIds").getter(DescribeInputResponse.getter(DescribeInputResponse::inputPartnerIds)).setter(DescribeInputResponse.setter(Builder::inputPartnerIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputPartnerIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INPUT_SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputSourceType").getter(DescribeInputResponse.getter(DescribeInputResponse::inputSourceTypeAsString)).setter(DescribeInputResponse.setter(Builder::inputSourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputSourceType").build()}).build();
    private static final SdkField<List<MediaConnectFlow>> MEDIA_CONNECT_FLOWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MediaConnectFlows").getter(DescribeInputResponse.getter(DescribeInputResponse::mediaConnectFlows)).setter(DescribeInputResponse.setter(Builder::mediaConnectFlows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaConnectFlows").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MediaConnectFlow::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DescribeInputResponse.getter(DescribeInputResponse::name)).setter(DescribeInputResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(DescribeInputResponse.getter(DescribeInputResponse::roleArn)).setter(DescribeInputResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroups").getter(DescribeInputResponse.getter(DescribeInputResponse::securityGroups)).setter(DescribeInputResponse.setter(Builder::securityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<InputSource>> SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Sources").getter(DescribeInputResponse.getter(DescribeInputResponse::sources)).setter(DescribeInputResponse.setter(Builder::sources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(DescribeInputResponse.getter(DescribeInputResponse::stateAsString)).setter(DescribeInputResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(DescribeInputResponse.getter(DescribeInputResponse::tags)).setter(DescribeInputResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(DescribeInputResponse.getter(DescribeInputResponse::typeAsString)).setter(DescribeInputResponse.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<SrtSettings> SRT_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SrtSettings").getter(DescribeInputResponse.getter(DescribeInputResponse::srtSettings)).setter(DescribeInputResponse.setter(Builder::srtSettings)).constructor(SrtSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("srtSettings").build()}).build();
    private static final SdkField<String> INPUT_NETWORK_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputNetworkLocation").getter(DescribeInputResponse.getter(DescribeInputResponse::inputNetworkLocationAsString)).setter(DescribeInputResponse.setter(Builder::inputNetworkLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputNetworkLocation").build()}).build();
    private static final SdkField<MulticastSettings> MULTICAST_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MulticastSettings").getter(DescribeInputResponse.getter(DescribeInputResponse::multicastSettings)).setter(DescribeInputResponse.setter(Builder::multicastSettings)).constructor(MulticastSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multicastSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ATTACHED_CHANNELS_FIELD, DESTINATIONS_FIELD, ID_FIELD, INPUT_CLASS_FIELD, INPUT_DEVICES_FIELD, INPUT_PARTNER_IDS_FIELD, INPUT_SOURCE_TYPE_FIELD, MEDIA_CONNECT_FLOWS_FIELD, NAME_FIELD, ROLE_ARN_FIELD, SECURITY_GROUPS_FIELD, SOURCES_FIELD, STATE_FIELD, TAGS_FIELD, TYPE_FIELD, SRT_SETTINGS_FIELD, INPUT_NETWORK_LOCATION_FIELD, MULTICAST_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeInputResponse.memberNameToFieldInitializer();
    private final String arn;
    private final List<String> attachedChannels;
    private final List<InputDestination> destinations;
    private final String id;
    private final String inputClass;
    private final List<InputDeviceSettings> inputDevices;
    private final List<String> inputPartnerIds;
    private final String inputSourceType;
    private final List<MediaConnectFlow> mediaConnectFlows;
    private final String name;
    private final String roleArn;
    private final List<String> securityGroups;
    private final List<InputSource> sources;
    private final String state;
    private final Map<String, String> tags;
    private final String type;
    private final SrtSettings srtSettings;
    private final String inputNetworkLocation;
    private final MulticastSettings multicastSettings;

    private DescribeInputResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.attachedChannels = builder.attachedChannels;
        this.destinations = builder.destinations;
        this.id = builder.id;
        this.inputClass = builder.inputClass;
        this.inputDevices = builder.inputDevices;
        this.inputPartnerIds = builder.inputPartnerIds;
        this.inputSourceType = builder.inputSourceType;
        this.mediaConnectFlows = builder.mediaConnectFlows;
        this.name = builder.name;
        this.roleArn = builder.roleArn;
        this.securityGroups = builder.securityGroups;
        this.sources = builder.sources;
        this.state = builder.state;
        this.tags = builder.tags;
        this.type = builder.type;
        this.srtSettings = builder.srtSettings;
        this.inputNetworkLocation = builder.inputNetworkLocation;
        this.multicastSettings = builder.multicastSettings;
    }

    public final String arn() {
        return this.arn;
    }

    public final boolean hasAttachedChannels() {
        return this.attachedChannels != null && !(this.attachedChannels instanceof SdkAutoConstructList);
    }

    public final List<String> attachedChannels() {
        return this.attachedChannels;
    }

    public final boolean hasDestinations() {
        return this.destinations != null && !(this.destinations instanceof SdkAutoConstructList);
    }

    public final List<InputDestination> destinations() {
        return this.destinations;
    }

    public final String id() {
        return this.id;
    }

    public final InputClass inputClass() {
        return InputClass.fromValue(this.inputClass);
    }

    public final String inputClassAsString() {
        return this.inputClass;
    }

    public final boolean hasInputDevices() {
        return this.inputDevices != null && !(this.inputDevices instanceof SdkAutoConstructList);
    }

    public final List<InputDeviceSettings> inputDevices() {
        return this.inputDevices;
    }

    public final boolean hasInputPartnerIds() {
        return this.inputPartnerIds != null && !(this.inputPartnerIds instanceof SdkAutoConstructList);
    }

    public final List<String> inputPartnerIds() {
        return this.inputPartnerIds;
    }

    public final InputSourceType inputSourceType() {
        return InputSourceType.fromValue(this.inputSourceType);
    }

    public final String inputSourceTypeAsString() {
        return this.inputSourceType;
    }

    public final boolean hasMediaConnectFlows() {
        return this.mediaConnectFlows != null && !(this.mediaConnectFlows instanceof SdkAutoConstructList);
    }

    public final List<MediaConnectFlow> mediaConnectFlows() {
        return this.mediaConnectFlows;
    }

    public final String name() {
        return this.name;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final boolean hasSecurityGroups() {
        return this.securityGroups != null && !(this.securityGroups instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroups() {
        return this.securityGroups;
    }

    public final boolean hasSources() {
        return this.sources != null && !(this.sources instanceof SdkAutoConstructList);
    }

    public final List<InputSource> sources() {
        return this.sources;
    }

    public final InputState state() {
        return InputState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final InputType type() {
        return InputType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final SrtSettings srtSettings() {
        return this.srtSettings;
    }

    public final InputNetworkLocation inputNetworkLocation() {
        return InputNetworkLocation.fromValue(this.inputNetworkLocation);
    }

    public final String inputNetworkLocationAsString() {
        return this.inputNetworkLocation;
    }

    public final MulticastSettings multicastSettings() {
        return this.multicastSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttachedChannels() ? this.attachedChannels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinations() ? this.destinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputDevices() ? this.inputDevices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputPartnerIds() ? this.inputPartnerIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.inputSourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMediaConnectFlows() ? this.mediaConnectFlows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroups() ? this.securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSources() ? this.sources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.srtSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputNetworkLocationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.multicastSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInputResponse)) {
            return false;
        }
        DescribeInputResponse other = (DescribeInputResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && this.hasAttachedChannels() == other.hasAttachedChannels() && Objects.equals(this.attachedChannels(), other.attachedChannels()) && this.hasDestinations() == other.hasDestinations() && Objects.equals(this.destinations(), other.destinations()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.inputClassAsString(), other.inputClassAsString()) && this.hasInputDevices() == other.hasInputDevices() && Objects.equals(this.inputDevices(), other.inputDevices()) && this.hasInputPartnerIds() == other.hasInputPartnerIds() && Objects.equals(this.inputPartnerIds(), other.inputPartnerIds()) && Objects.equals(this.inputSourceTypeAsString(), other.inputSourceTypeAsString()) && this.hasMediaConnectFlows() == other.hasMediaConnectFlows() && Objects.equals(this.mediaConnectFlows(), other.mediaConnectFlows()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.roleArn(), other.roleArn()) && this.hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(this.securityGroups(), other.securityGroups()) && this.hasSources() == other.hasSources() && Objects.equals(this.sources(), other.sources()) && Objects.equals(this.stateAsString(), other.stateAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.srtSettings(), other.srtSettings()) && Objects.equals(this.inputNetworkLocationAsString(), other.inputNetworkLocationAsString()) && Objects.equals(this.multicastSettings(), other.multicastSettings());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeInputResponse").add("Arn", (Object)this.arn()).add("AttachedChannels", this.hasAttachedChannels() ? this.attachedChannels() : null).add("Destinations", this.hasDestinations() ? this.destinations() : null).add("Id", (Object)this.id()).add("InputClass", (Object)this.inputClassAsString()).add("InputDevices", this.hasInputDevices() ? this.inputDevices() : null).add("InputPartnerIds", this.hasInputPartnerIds() ? this.inputPartnerIds() : null).add("InputSourceType", (Object)this.inputSourceTypeAsString()).add("MediaConnectFlows", this.hasMediaConnectFlows() ? this.mediaConnectFlows() : null).add("Name", (Object)this.name()).add("RoleArn", (Object)this.roleArn()).add("SecurityGroups", this.hasSecurityGroups() ? this.securityGroups() : null).add("Sources", this.hasSources() ? this.sources() : null).add("State", (Object)this.stateAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("Type", (Object)this.typeAsString()).add("SrtSettings", (Object)this.srtSettings()).add("InputNetworkLocation", (Object)this.inputNetworkLocationAsString()).add("MulticastSettings", (Object)this.multicastSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "AttachedChannels": {
                return Optional.ofNullable(clazz.cast(this.attachedChannels()));
            }
            case "Destinations": {
                return Optional.ofNullable(clazz.cast(this.destinations()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "InputClass": {
                return Optional.ofNullable(clazz.cast(this.inputClassAsString()));
            }
            case "InputDevices": {
                return Optional.ofNullable(clazz.cast(this.inputDevices()));
            }
            case "InputPartnerIds": {
                return Optional.ofNullable(clazz.cast(this.inputPartnerIds()));
            }
            case "InputSourceType": {
                return Optional.ofNullable(clazz.cast(this.inputSourceTypeAsString()));
            }
            case "MediaConnectFlows": {
                return Optional.ofNullable(clazz.cast(this.mediaConnectFlows()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "SecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.securityGroups()));
            }
            case "Sources": {
                return Optional.ofNullable(clazz.cast(this.sources()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "SrtSettings": {
                return Optional.ofNullable(clazz.cast(this.srtSettings()));
            }
            case "InputNetworkLocation": {
                return Optional.ofNullable(clazz.cast(this.inputNetworkLocationAsString()));
            }
            case "MulticastSettings": {
                return Optional.ofNullable(clazz.cast(this.multicastSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("attachedChannels", ATTACHED_CHANNELS_FIELD);
        map.put("destinations", DESTINATIONS_FIELD);
        map.put("id", ID_FIELD);
        map.put("inputClass", INPUT_CLASS_FIELD);
        map.put("inputDevices", INPUT_DEVICES_FIELD);
        map.put("inputPartnerIds", INPUT_PARTNER_IDS_FIELD);
        map.put("inputSourceType", INPUT_SOURCE_TYPE_FIELD);
        map.put("mediaConnectFlows", MEDIA_CONNECT_FLOWS_FIELD);
        map.put("name", NAME_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("securityGroups", SECURITY_GROUPS_FIELD);
        map.put("sources", SOURCES_FIELD);
        map.put("state", STATE_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("srtSettings", SRT_SETTINGS_FIELD);
        map.put("inputNetworkLocation", INPUT_NETWORK_LOCATION_FIELD);
        map.put("multicastSettings", MULTICAST_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeInputResponse, T> g) {
        return obj -> g.apply((DescribeInputResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveResponse.BuilderImpl
    implements Builder {
        private String arn;
        private List<String> attachedChannels = DefaultSdkAutoConstructList.getInstance();
        private List<InputDestination> destinations = DefaultSdkAutoConstructList.getInstance();
        private String id;
        private String inputClass;
        private List<InputDeviceSettings> inputDevices = DefaultSdkAutoConstructList.getInstance();
        private List<String> inputPartnerIds = DefaultSdkAutoConstructList.getInstance();
        private String inputSourceType;
        private List<MediaConnectFlow> mediaConnectFlows = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private String roleArn;
        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();
        private List<InputSource> sources = DefaultSdkAutoConstructList.getInstance();
        private String state;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String type;
        private SrtSettings srtSettings;
        private String inputNetworkLocation;
        private MulticastSettings multicastSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInputResponse model) {
            super(model);
            this.arn(model.arn);
            this.attachedChannels(model.attachedChannels);
            this.destinations(model.destinations);
            this.id(model.id);
            this.inputClass(model.inputClass);
            this.inputDevices(model.inputDevices);
            this.inputPartnerIds(model.inputPartnerIds);
            this.inputSourceType(model.inputSourceType);
            this.mediaConnectFlows(model.mediaConnectFlows);
            this.name(model.name);
            this.roleArn(model.roleArn);
            this.securityGroups(model.securityGroups);
            this.sources(model.sources);
            this.state(model.state);
            this.tags(model.tags);
            this.type(model.type);
            this.srtSettings(model.srtSettings);
            this.inputNetworkLocation(model.inputNetworkLocation);
            this.multicastSettings(model.multicastSettings);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Collection<String> getAttachedChannels() {
            if (this.attachedChannels instanceof SdkAutoConstructList) {
                return null;
            }
            return this.attachedChannels;
        }

        public final void setAttachedChannels(Collection<String> attachedChannels) {
            this.attachedChannels = ___listOf__stringCopier.copy(attachedChannels);
        }

        @Override
        public final Builder attachedChannels(Collection<String> attachedChannels) {
            this.attachedChannels = ___listOf__stringCopier.copy(attachedChannels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachedChannels(String ... attachedChannels) {
            this.attachedChannels(Arrays.asList(attachedChannels));
            return this;
        }

        public final List<InputDestination.Builder> getDestinations() {
            List<InputDestination.Builder> result = ___listOfInputDestinationCopier.copyToBuilder(this.destinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinations(Collection<InputDestination.BuilderImpl> destinations) {
            this.destinations = ___listOfInputDestinationCopier.copyFromBuilder(destinations);
        }

        @Override
        public final Builder destinations(Collection<InputDestination> destinations) {
            this.destinations = ___listOfInputDestinationCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(InputDestination ... destinations) {
            this.destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<InputDestination.Builder> ... destinations) {
            this.destinations(Stream.of(destinations).map(c -> (InputDestination)((InputDestination.Builder)InputDestination.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getInputClass() {
            return this.inputClass;
        }

        public final void setInputClass(String inputClass) {
            this.inputClass = inputClass;
        }

        @Override
        public final Builder inputClass(String inputClass) {
            this.inputClass = inputClass;
            return this;
        }

        @Override
        public final Builder inputClass(InputClass inputClass) {
            this.inputClass(inputClass == null ? null : inputClass.toString());
            return this;
        }

        public final List<InputDeviceSettings.Builder> getInputDevices() {
            List<InputDeviceSettings.Builder> result = ___listOfInputDeviceSettingsCopier.copyToBuilder(this.inputDevices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputDevices(Collection<InputDeviceSettings.BuilderImpl> inputDevices) {
            this.inputDevices = ___listOfInputDeviceSettingsCopier.copyFromBuilder(inputDevices);
        }

        @Override
        public final Builder inputDevices(Collection<InputDeviceSettings> inputDevices) {
            this.inputDevices = ___listOfInputDeviceSettingsCopier.copy(inputDevices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDevices(InputDeviceSettings ... inputDevices) {
            this.inputDevices(Arrays.asList(inputDevices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDevices(Consumer<InputDeviceSettings.Builder> ... inputDevices) {
            this.inputDevices(Stream.of(inputDevices).map(c -> (InputDeviceSettings)((InputDeviceSettings.Builder)InputDeviceSettings.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getInputPartnerIds() {
            if (this.inputPartnerIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inputPartnerIds;
        }

        public final void setInputPartnerIds(Collection<String> inputPartnerIds) {
            this.inputPartnerIds = ___listOf__stringCopier.copy(inputPartnerIds);
        }

        @Override
        public final Builder inputPartnerIds(Collection<String> inputPartnerIds) {
            this.inputPartnerIds = ___listOf__stringCopier.copy(inputPartnerIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputPartnerIds(String ... inputPartnerIds) {
            this.inputPartnerIds(Arrays.asList(inputPartnerIds));
            return this;
        }

        public final String getInputSourceType() {
            return this.inputSourceType;
        }

        public final void setInputSourceType(String inputSourceType) {
            this.inputSourceType = inputSourceType;
        }

        @Override
        public final Builder inputSourceType(String inputSourceType) {
            this.inputSourceType = inputSourceType;
            return this;
        }

        @Override
        public final Builder inputSourceType(InputSourceType inputSourceType) {
            this.inputSourceType(inputSourceType == null ? null : inputSourceType.toString());
            return this;
        }

        public final List<MediaConnectFlow.Builder> getMediaConnectFlows() {
            List<MediaConnectFlow.Builder> result = ___listOfMediaConnectFlowCopier.copyToBuilder(this.mediaConnectFlows);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMediaConnectFlows(Collection<MediaConnectFlow.BuilderImpl> mediaConnectFlows) {
            this.mediaConnectFlows = ___listOfMediaConnectFlowCopier.copyFromBuilder(mediaConnectFlows);
        }

        @Override
        public final Builder mediaConnectFlows(Collection<MediaConnectFlow> mediaConnectFlows) {
            this.mediaConnectFlows = ___listOfMediaConnectFlowCopier.copy(mediaConnectFlows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaConnectFlows(MediaConnectFlow ... mediaConnectFlows) {
            this.mediaConnectFlows(Arrays.asList(mediaConnectFlows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaConnectFlows(Consumer<MediaConnectFlow.Builder> ... mediaConnectFlows) {
            this.mediaConnectFlows(Stream.of(mediaConnectFlows).map(c -> (MediaConnectFlow)((MediaConnectFlow.Builder)MediaConnectFlow.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Collection<String> getSecurityGroups() {
            if (this.securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroups;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = ___listOf__stringCopier.copy(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = ___listOf__stringCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final List<InputSource.Builder> getSources() {
            List<InputSource.Builder> result = ___listOfInputSourceCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<InputSource.BuilderImpl> sources) {
            this.sources = ___listOfInputSourceCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<InputSource> sources) {
            this.sources = ___listOfInputSourceCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(InputSource ... sources) {
            this.sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<InputSource.Builder> ... sources) {
            this.sources(Stream.of(sources).map(c -> (InputSource)((InputSource.Builder)InputSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(InputState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(InputType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final SrtSettings.Builder getSrtSettings() {
            return this.srtSettings != null ? this.srtSettings.toBuilder() : null;
        }

        public final void setSrtSettings(SrtSettings.BuilderImpl srtSettings) {
            this.srtSettings = srtSettings != null ? srtSettings.build() : null;
        }

        @Override
        public final Builder srtSettings(SrtSettings srtSettings) {
            this.srtSettings = srtSettings;
            return this;
        }

        public final String getInputNetworkLocation() {
            return this.inputNetworkLocation;
        }

        public final void setInputNetworkLocation(String inputNetworkLocation) {
            this.inputNetworkLocation = inputNetworkLocation;
        }

        @Override
        public final Builder inputNetworkLocation(String inputNetworkLocation) {
            this.inputNetworkLocation = inputNetworkLocation;
            return this;
        }

        @Override
        public final Builder inputNetworkLocation(InputNetworkLocation inputNetworkLocation) {
            this.inputNetworkLocation(inputNetworkLocation == null ? null : inputNetworkLocation.toString());
            return this;
        }

        public final MulticastSettings.Builder getMulticastSettings() {
            return this.multicastSettings != null ? this.multicastSettings.toBuilder() : null;
        }

        public final void setMulticastSettings(MulticastSettings.BuilderImpl multicastSettings) {
            this.multicastSettings = multicastSettings != null ? multicastSettings.build() : null;
        }

        @Override
        public final Builder multicastSettings(MulticastSettings multicastSettings) {
            this.multicastSettings = multicastSettings;
            return this;
        }

        @Override
        public DescribeInputResponse build() {
            return new DescribeInputResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MediaLiveResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeInputResponse> {
        public Builder arn(String var1);

        public Builder attachedChannels(Collection<String> var1);

        public Builder attachedChannels(String ... var1);

        public Builder destinations(Collection<InputDestination> var1);

        public Builder destinations(InputDestination ... var1);

        public Builder destinations(Consumer<InputDestination.Builder> ... var1);

        public Builder id(String var1);

        public Builder inputClass(String var1);

        public Builder inputClass(InputClass var1);

        public Builder inputDevices(Collection<InputDeviceSettings> var1);

        public Builder inputDevices(InputDeviceSettings ... var1);

        public Builder inputDevices(Consumer<InputDeviceSettings.Builder> ... var1);

        public Builder inputPartnerIds(Collection<String> var1);

        public Builder inputPartnerIds(String ... var1);

        public Builder inputSourceType(String var1);

        public Builder inputSourceType(InputSourceType var1);

        public Builder mediaConnectFlows(Collection<MediaConnectFlow> var1);

        public Builder mediaConnectFlows(MediaConnectFlow ... var1);

        public Builder mediaConnectFlows(Consumer<MediaConnectFlow.Builder> ... var1);

        public Builder name(String var1);

        public Builder roleArn(String var1);

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);

        public Builder sources(Collection<InputSource> var1);

        public Builder sources(InputSource ... var1);

        public Builder sources(Consumer<InputSource.Builder> ... var1);

        public Builder state(String var1);

        public Builder state(InputState var1);

        public Builder tags(Map<String, String> var1);

        public Builder type(String var1);

        public Builder type(InputType var1);

        public Builder srtSettings(SrtSettings var1);

        default public Builder srtSettings(Consumer<SrtSettings.Builder> srtSettings) {
            return this.srtSettings((SrtSettings)((SrtSettings.Builder)SrtSettings.builder().applyMutation(srtSettings)).build());
        }

        public Builder inputNetworkLocation(String var1);

        public Builder inputNetworkLocation(InputNetworkLocation var1);

        public Builder multicastSettings(MulticastSettings var1);

        default public Builder multicastSettings(Consumer<MulticastSettings.Builder> multicastSettings) {
            return this.multicastSettings((MulticastSettings)((MulticastSettings.Builder)MulticastSettings.builder().applyMutation(multicastSettings)).build());
        }
    }
}

