/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.medialive.MediaLiveClient;
import software.amazon.awssdk.services.medialive.internal.UserAgentUtils;
import software.amazon.awssdk.services.medialive.model.DescribeChannelPlacementGroupSummary;
import software.amazon.awssdk.services.medialive.model.ListChannelPlacementGroupsRequest;
import software.amazon.awssdk.services.medialive.model.ListChannelPlacementGroupsResponse;

public class ListChannelPlacementGroupsIterable
implements SdkIterable<ListChannelPlacementGroupsResponse> {
    private final MediaLiveClient client;
    private final ListChannelPlacementGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListChannelPlacementGroupsIterable(MediaLiveClient client, ListChannelPlacementGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListChannelPlacementGroupsResponseFetcher();
    }

    public Iterator<ListChannelPlacementGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DescribeChannelPlacementGroupSummary> channelPlacementGroups() {
        Function<ListChannelPlacementGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.channelPlacementGroups() != null) {
                return response.channelPlacementGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListChannelPlacementGroupsResponseFetcher
    implements SyncPageFetcher<ListChannelPlacementGroupsResponse> {
        private ListChannelPlacementGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListChannelPlacementGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListChannelPlacementGroupsResponse nextPage(ListChannelPlacementGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListChannelPlacementGroupsIterable.this.client.listChannelPlacementGroups(ListChannelPlacementGroupsIterable.this.firstRequest);
            }
            return ListChannelPlacementGroupsIterable.this.client.listChannelPlacementGroups((ListChannelPlacementGroupsRequest)((Object)ListChannelPlacementGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

