/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.medialive.model.CdiInputSpecification;
import software.amazon.awssdk.services.medialive.model.ChannelClass;
import software.amazon.awssdk.services.medialive.model.ChannelEgressEndpoint;
import software.amazon.awssdk.services.medialive.model.ChannelState;
import software.amazon.awssdk.services.medialive.model.DescribeAnywhereSettings;
import software.amazon.awssdk.services.medialive.model.InputAttachment;
import software.amazon.awssdk.services.medialive.model.InputSpecification;
import software.amazon.awssdk.services.medialive.model.LogLevel;
import software.amazon.awssdk.services.medialive.model.MaintenanceStatus;
import software.amazon.awssdk.services.medialive.model.OutputDestination;
import software.amazon.awssdk.services.medialive.model.TagsCopier;
import software.amazon.awssdk.services.medialive.model.VpcOutputSettingsDescription;
import software.amazon.awssdk.services.medialive.model.___listOfChannelEgressEndpointCopier;
import software.amazon.awssdk.services.medialive.model.___listOfInputAttachmentCopier;
import software.amazon.awssdk.services.medialive.model.___listOfOutputDestinationCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChannelSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ChannelSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(ChannelSummary.getter(ChannelSummary::arn)).setter(ChannelSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<CdiInputSpecification> CDI_INPUT_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CdiInputSpecification").getter(ChannelSummary.getter(ChannelSummary::cdiInputSpecification)).setter(ChannelSummary.setter(Builder::cdiInputSpecification)).constructor(CdiInputSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cdiInputSpecification").build()}).build();
    private static final SdkField<String> CHANNEL_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelClass").getter(ChannelSummary.getter(ChannelSummary::channelClassAsString)).setter(ChannelSummary.setter(Builder::channelClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelClass").build()}).build();
    private static final SdkField<List<OutputDestination>> DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Destinations").getter(ChannelSummary.getter(ChannelSummary::destinations)).setter(ChannelSummary.setter(Builder::destinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OutputDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ChannelEgressEndpoint>> EGRESS_ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EgressEndpoints").getter(ChannelSummary.getter(ChannelSummary::egressEndpoints)).setter(ChannelSummary.setter(Builder::egressEndpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("egressEndpoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ChannelEgressEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(ChannelSummary.getter(ChannelSummary::id)).setter(ChannelSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<List<InputAttachment>> INPUT_ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InputAttachments").getter(ChannelSummary.getter(ChannelSummary::inputAttachments)).setter(ChannelSummary.setter(Builder::inputAttachments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputAttachments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputAttachment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<InputSpecification> INPUT_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InputSpecification").getter(ChannelSummary.getter(ChannelSummary::inputSpecification)).setter(ChannelSummary.setter(Builder::inputSpecification)).constructor(InputSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputSpecification").build()}).build();
    private static final SdkField<String> LOG_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogLevel").getter(ChannelSummary.getter(ChannelSummary::logLevelAsString)).setter(ChannelSummary.setter(Builder::logLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logLevel").build()}).build();
    private static final SdkField<MaintenanceStatus> MAINTENANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Maintenance").getter(ChannelSummary.getter(ChannelSummary::maintenance)).setter(ChannelSummary.setter(Builder::maintenance)).constructor(MaintenanceStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenance").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ChannelSummary.getter(ChannelSummary::name)).setter(ChannelSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Integer> PIPELINES_RUNNING_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PipelinesRunningCount").getter(ChannelSummary.getter(ChannelSummary::pipelinesRunningCount)).setter(ChannelSummary.setter(Builder::pipelinesRunningCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelinesRunningCount").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(ChannelSummary.getter(ChannelSummary::roleArn)).setter(ChannelSummary.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(ChannelSummary.getter(ChannelSummary::stateAsString)).setter(ChannelSummary.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(ChannelSummary.getter(ChannelSummary::tags)).setter(ChannelSummary.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<VpcOutputSettingsDescription> VPC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Vpc").getter(ChannelSummary.getter(ChannelSummary::vpc)).setter(ChannelSummary.setter(Builder::vpc)).constructor(VpcOutputSettingsDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpc").build()}).build();
    private static final SdkField<DescribeAnywhereSettings> ANYWHERE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AnywhereSettings").getter(ChannelSummary.getter(ChannelSummary::anywhereSettings)).setter(ChannelSummary.setter(Builder::anywhereSettings)).constructor(DescribeAnywhereSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("anywhereSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CDI_INPUT_SPECIFICATION_FIELD, CHANNEL_CLASS_FIELD, DESTINATIONS_FIELD, EGRESS_ENDPOINTS_FIELD, ID_FIELD, INPUT_ATTACHMENTS_FIELD, INPUT_SPECIFICATION_FIELD, LOG_LEVEL_FIELD, MAINTENANCE_FIELD, NAME_FIELD, PIPELINES_RUNNING_COUNT_FIELD, ROLE_ARN_FIELD, STATE_FIELD, TAGS_FIELD, VPC_FIELD, ANYWHERE_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ChannelSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final CdiInputSpecification cdiInputSpecification;
    private final String channelClass;
    private final List<OutputDestination> destinations;
    private final List<ChannelEgressEndpoint> egressEndpoints;
    private final String id;
    private final List<InputAttachment> inputAttachments;
    private final InputSpecification inputSpecification;
    private final String logLevel;
    private final MaintenanceStatus maintenance;
    private final String name;
    private final Integer pipelinesRunningCount;
    private final String roleArn;
    private final String state;
    private final Map<String, String> tags;
    private final VpcOutputSettingsDescription vpc;
    private final DescribeAnywhereSettings anywhereSettings;

    private ChannelSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.cdiInputSpecification = builder.cdiInputSpecification;
        this.channelClass = builder.channelClass;
        this.destinations = builder.destinations;
        this.egressEndpoints = builder.egressEndpoints;
        this.id = builder.id;
        this.inputAttachments = builder.inputAttachments;
        this.inputSpecification = builder.inputSpecification;
        this.logLevel = builder.logLevel;
        this.maintenance = builder.maintenance;
        this.name = builder.name;
        this.pipelinesRunningCount = builder.pipelinesRunningCount;
        this.roleArn = builder.roleArn;
        this.state = builder.state;
        this.tags = builder.tags;
        this.vpc = builder.vpc;
        this.anywhereSettings = builder.anywhereSettings;
    }

    public final String arn() {
        return this.arn;
    }

    public final CdiInputSpecification cdiInputSpecification() {
        return this.cdiInputSpecification;
    }

    public final ChannelClass channelClass() {
        return ChannelClass.fromValue(this.channelClass);
    }

    public final String channelClassAsString() {
        return this.channelClass;
    }

    public final boolean hasDestinations() {
        return this.destinations != null && !(this.destinations instanceof SdkAutoConstructList);
    }

    public final List<OutputDestination> destinations() {
        return this.destinations;
    }

    public final boolean hasEgressEndpoints() {
        return this.egressEndpoints != null && !(this.egressEndpoints instanceof SdkAutoConstructList);
    }

    public final List<ChannelEgressEndpoint> egressEndpoints() {
        return this.egressEndpoints;
    }

    public final String id() {
        return this.id;
    }

    public final boolean hasInputAttachments() {
        return this.inputAttachments != null && !(this.inputAttachments instanceof SdkAutoConstructList);
    }

    public final List<InputAttachment> inputAttachments() {
        return this.inputAttachments;
    }

    public final InputSpecification inputSpecification() {
        return this.inputSpecification;
    }

    public final LogLevel logLevel() {
        return LogLevel.fromValue(this.logLevel);
    }

    public final String logLevelAsString() {
        return this.logLevel;
    }

    public final MaintenanceStatus maintenance() {
        return this.maintenance;
    }

    public final String name() {
        return this.name;
    }

    public final Integer pipelinesRunningCount() {
        return this.pipelinesRunningCount;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final ChannelState state() {
        return ChannelState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final VpcOutputSettingsDescription vpc() {
        return this.vpc;
    }

    public final DescribeAnywhereSettings anywhereSettings() {
        return this.anywhereSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.cdiInputSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinations() ? this.destinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEgressEndpoints() ? this.egressEndpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputAttachments() ? this.inputAttachments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.inputSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.logLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenance());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelinesRunningCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpc());
        hashCode = 31 * hashCode + Objects.hashCode(this.anywhereSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelSummary)) {
            return false;
        }
        ChannelSummary other = (ChannelSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.cdiInputSpecification(), other.cdiInputSpecification()) && Objects.equals(this.channelClassAsString(), other.channelClassAsString()) && this.hasDestinations() == other.hasDestinations() && Objects.equals(this.destinations(), other.destinations()) && this.hasEgressEndpoints() == other.hasEgressEndpoints() && Objects.equals(this.egressEndpoints(), other.egressEndpoints()) && Objects.equals(this.id(), other.id()) && this.hasInputAttachments() == other.hasInputAttachments() && Objects.equals(this.inputAttachments(), other.inputAttachments()) && Objects.equals(this.inputSpecification(), other.inputSpecification()) && Objects.equals(this.logLevelAsString(), other.logLevelAsString()) && Objects.equals(this.maintenance(), other.maintenance()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.pipelinesRunningCount(), other.pipelinesRunningCount()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.stateAsString(), other.stateAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.vpc(), other.vpc()) && Objects.equals(this.anywhereSettings(), other.anywhereSettings());
    }

    public final String toString() {
        return ToString.builder((String)"ChannelSummary").add("Arn", (Object)this.arn()).add("CdiInputSpecification", (Object)this.cdiInputSpecification()).add("ChannelClass", (Object)this.channelClassAsString()).add("Destinations", this.hasDestinations() ? this.destinations() : null).add("EgressEndpoints", this.hasEgressEndpoints() ? this.egressEndpoints() : null).add("Id", (Object)this.id()).add("InputAttachments", this.hasInputAttachments() ? this.inputAttachments() : null).add("InputSpecification", (Object)this.inputSpecification()).add("LogLevel", (Object)this.logLevelAsString()).add("Maintenance", (Object)this.maintenance()).add("Name", (Object)this.name()).add("PipelinesRunningCount", (Object)this.pipelinesRunningCount()).add("RoleArn", (Object)this.roleArn()).add("State", (Object)this.stateAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("Vpc", (Object)this.vpc()).add("AnywhereSettings", (Object)this.anywhereSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CdiInputSpecification": {
                return Optional.ofNullable(clazz.cast(this.cdiInputSpecification()));
            }
            case "ChannelClass": {
                return Optional.ofNullable(clazz.cast(this.channelClassAsString()));
            }
            case "Destinations": {
                return Optional.ofNullable(clazz.cast(this.destinations()));
            }
            case "EgressEndpoints": {
                return Optional.ofNullable(clazz.cast(this.egressEndpoints()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "InputAttachments": {
                return Optional.ofNullable(clazz.cast(this.inputAttachments()));
            }
            case "InputSpecification": {
                return Optional.ofNullable(clazz.cast(this.inputSpecification()));
            }
            case "LogLevel": {
                return Optional.ofNullable(clazz.cast(this.logLevelAsString()));
            }
            case "Maintenance": {
                return Optional.ofNullable(clazz.cast(this.maintenance()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "PipelinesRunningCount": {
                return Optional.ofNullable(clazz.cast(this.pipelinesRunningCount()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Vpc": {
                return Optional.ofNullable(clazz.cast(this.vpc()));
            }
            case "AnywhereSettings": {
                return Optional.ofNullable(clazz.cast(this.anywhereSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("cdiInputSpecification", CDI_INPUT_SPECIFICATION_FIELD);
        map.put("channelClass", CHANNEL_CLASS_FIELD);
        map.put("destinations", DESTINATIONS_FIELD);
        map.put("egressEndpoints", EGRESS_ENDPOINTS_FIELD);
        map.put("id", ID_FIELD);
        map.put("inputAttachments", INPUT_ATTACHMENTS_FIELD);
        map.put("inputSpecification", INPUT_SPECIFICATION_FIELD);
        map.put("logLevel", LOG_LEVEL_FIELD);
        map.put("maintenance", MAINTENANCE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("pipelinesRunningCount", PIPELINES_RUNNING_COUNT_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("state", STATE_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("vpc", VPC_FIELD);
        map.put("anywhereSettings", ANYWHERE_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChannelSummary, T> g) {
        return obj -> g.apply((ChannelSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private CdiInputSpecification cdiInputSpecification;
        private String channelClass;
        private List<OutputDestination> destinations = DefaultSdkAutoConstructList.getInstance();
        private List<ChannelEgressEndpoint> egressEndpoints = DefaultSdkAutoConstructList.getInstance();
        private String id;
        private List<InputAttachment> inputAttachments = DefaultSdkAutoConstructList.getInstance();
        private InputSpecification inputSpecification;
        private String logLevel;
        private MaintenanceStatus maintenance;
        private String name;
        private Integer pipelinesRunningCount;
        private String roleArn;
        private String state;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private VpcOutputSettingsDescription vpc;
        private DescribeAnywhereSettings anywhereSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(ChannelSummary model) {
            this.arn(model.arn);
            this.cdiInputSpecification(model.cdiInputSpecification);
            this.channelClass(model.channelClass);
            this.destinations(model.destinations);
            this.egressEndpoints(model.egressEndpoints);
            this.id(model.id);
            this.inputAttachments(model.inputAttachments);
            this.inputSpecification(model.inputSpecification);
            this.logLevel(model.logLevel);
            this.maintenance(model.maintenance);
            this.name(model.name);
            this.pipelinesRunningCount(model.pipelinesRunningCount);
            this.roleArn(model.roleArn);
            this.state(model.state);
            this.tags(model.tags);
            this.vpc(model.vpc);
            this.anywhereSettings(model.anywhereSettings);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final CdiInputSpecification.Builder getCdiInputSpecification() {
            return this.cdiInputSpecification != null ? this.cdiInputSpecification.toBuilder() : null;
        }

        public final void setCdiInputSpecification(CdiInputSpecification.BuilderImpl cdiInputSpecification) {
            this.cdiInputSpecification = cdiInputSpecification != null ? cdiInputSpecification.build() : null;
        }

        @Override
        public final Builder cdiInputSpecification(CdiInputSpecification cdiInputSpecification) {
            this.cdiInputSpecification = cdiInputSpecification;
            return this;
        }

        public final String getChannelClass() {
            return this.channelClass;
        }

        public final void setChannelClass(String channelClass) {
            this.channelClass = channelClass;
        }

        @Override
        public final Builder channelClass(String channelClass) {
            this.channelClass = channelClass;
            return this;
        }

        @Override
        public final Builder channelClass(ChannelClass channelClass) {
            this.channelClass(channelClass == null ? null : channelClass.toString());
            return this;
        }

        public final List<OutputDestination.Builder> getDestinations() {
            List<OutputDestination.Builder> result = ___listOfOutputDestinationCopier.copyToBuilder(this.destinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinations(Collection<OutputDestination.BuilderImpl> destinations) {
            this.destinations = ___listOfOutputDestinationCopier.copyFromBuilder(destinations);
        }

        @Override
        public final Builder destinations(Collection<OutputDestination> destinations) {
            this.destinations = ___listOfOutputDestinationCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(OutputDestination ... destinations) {
            this.destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<OutputDestination.Builder> ... destinations) {
            this.destinations(Stream.of(destinations).map(c -> (OutputDestination)((OutputDestination.Builder)OutputDestination.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ChannelEgressEndpoint.Builder> getEgressEndpoints() {
            List<ChannelEgressEndpoint.Builder> result = ___listOfChannelEgressEndpointCopier.copyToBuilder(this.egressEndpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEgressEndpoints(Collection<ChannelEgressEndpoint.BuilderImpl> egressEndpoints) {
            this.egressEndpoints = ___listOfChannelEgressEndpointCopier.copyFromBuilder(egressEndpoints);
        }

        @Override
        public final Builder egressEndpoints(Collection<ChannelEgressEndpoint> egressEndpoints) {
            this.egressEndpoints = ___listOfChannelEgressEndpointCopier.copy(egressEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder egressEndpoints(ChannelEgressEndpoint ... egressEndpoints) {
            this.egressEndpoints(Arrays.asList(egressEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder egressEndpoints(Consumer<ChannelEgressEndpoint.Builder> ... egressEndpoints) {
            this.egressEndpoints(Stream.of(egressEndpoints).map(c -> (ChannelEgressEndpoint)((ChannelEgressEndpoint.Builder)ChannelEgressEndpoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final List<InputAttachment.Builder> getInputAttachments() {
            List<InputAttachment.Builder> result = ___listOfInputAttachmentCopier.copyToBuilder(this.inputAttachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputAttachments(Collection<InputAttachment.BuilderImpl> inputAttachments) {
            this.inputAttachments = ___listOfInputAttachmentCopier.copyFromBuilder(inputAttachments);
        }

        @Override
        public final Builder inputAttachments(Collection<InputAttachment> inputAttachments) {
            this.inputAttachments = ___listOfInputAttachmentCopier.copy(inputAttachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputAttachments(InputAttachment ... inputAttachments) {
            this.inputAttachments(Arrays.asList(inputAttachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputAttachments(Consumer<InputAttachment.Builder> ... inputAttachments) {
            this.inputAttachments(Stream.of(inputAttachments).map(c -> (InputAttachment)((InputAttachment.Builder)InputAttachment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final InputSpecification.Builder getInputSpecification() {
            return this.inputSpecification != null ? this.inputSpecification.toBuilder() : null;
        }

        public final void setInputSpecification(InputSpecification.BuilderImpl inputSpecification) {
            this.inputSpecification = inputSpecification != null ? inputSpecification.build() : null;
        }

        @Override
        public final Builder inputSpecification(InputSpecification inputSpecification) {
            this.inputSpecification = inputSpecification;
            return this;
        }

        public final String getLogLevel() {
            return this.logLevel;
        }

        public final void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }

        @Override
        public final Builder logLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        @Override
        public final Builder logLevel(LogLevel logLevel) {
            this.logLevel(logLevel == null ? null : logLevel.toString());
            return this;
        }

        public final MaintenanceStatus.Builder getMaintenance() {
            return this.maintenance != null ? this.maintenance.toBuilder() : null;
        }

        public final void setMaintenance(MaintenanceStatus.BuilderImpl maintenance) {
            this.maintenance = maintenance != null ? maintenance.build() : null;
        }

        @Override
        public final Builder maintenance(MaintenanceStatus maintenance) {
            this.maintenance = maintenance;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getPipelinesRunningCount() {
            return this.pipelinesRunningCount;
        }

        public final void setPipelinesRunningCount(Integer pipelinesRunningCount) {
            this.pipelinesRunningCount = pipelinesRunningCount;
        }

        @Override
        public final Builder pipelinesRunningCount(Integer pipelinesRunningCount) {
            this.pipelinesRunningCount = pipelinesRunningCount;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ChannelState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final VpcOutputSettingsDescription.Builder getVpc() {
            return this.vpc != null ? this.vpc.toBuilder() : null;
        }

        public final void setVpc(VpcOutputSettingsDescription.BuilderImpl vpc) {
            this.vpc = vpc != null ? vpc.build() : null;
        }

        @Override
        public final Builder vpc(VpcOutputSettingsDescription vpc) {
            this.vpc = vpc;
            return this;
        }

        public final DescribeAnywhereSettings.Builder getAnywhereSettings() {
            return this.anywhereSettings != null ? this.anywhereSettings.toBuilder() : null;
        }

        public final void setAnywhereSettings(DescribeAnywhereSettings.BuilderImpl anywhereSettings) {
            this.anywhereSettings = anywhereSettings != null ? anywhereSettings.build() : null;
        }

        @Override
        public final Builder anywhereSettings(DescribeAnywhereSettings anywhereSettings) {
            this.anywhereSettings = anywhereSettings;
            return this;
        }

        public ChannelSummary build() {
            return new ChannelSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ChannelSummary> {
        public Builder arn(String var1);

        public Builder cdiInputSpecification(CdiInputSpecification var1);

        default public Builder cdiInputSpecification(Consumer<CdiInputSpecification.Builder> cdiInputSpecification) {
            return this.cdiInputSpecification((CdiInputSpecification)((CdiInputSpecification.Builder)CdiInputSpecification.builder().applyMutation(cdiInputSpecification)).build());
        }

        public Builder channelClass(String var1);

        public Builder channelClass(ChannelClass var1);

        public Builder destinations(Collection<OutputDestination> var1);

        public Builder destinations(OutputDestination ... var1);

        public Builder destinations(Consumer<OutputDestination.Builder> ... var1);

        public Builder egressEndpoints(Collection<ChannelEgressEndpoint> var1);

        public Builder egressEndpoints(ChannelEgressEndpoint ... var1);

        public Builder egressEndpoints(Consumer<ChannelEgressEndpoint.Builder> ... var1);

        public Builder id(String var1);

        public Builder inputAttachments(Collection<InputAttachment> var1);

        public Builder inputAttachments(InputAttachment ... var1);

        public Builder inputAttachments(Consumer<InputAttachment.Builder> ... var1);

        public Builder inputSpecification(InputSpecification var1);

        default public Builder inputSpecification(Consumer<InputSpecification.Builder> inputSpecification) {
            return this.inputSpecification((InputSpecification)((InputSpecification.Builder)InputSpecification.builder().applyMutation(inputSpecification)).build());
        }

        public Builder logLevel(String var1);

        public Builder logLevel(LogLevel var1);

        public Builder maintenance(MaintenanceStatus var1);

        default public Builder maintenance(Consumer<MaintenanceStatus.Builder> maintenance) {
            return this.maintenance((MaintenanceStatus)((MaintenanceStatus.Builder)MaintenanceStatus.builder().applyMutation(maintenance)).build());
        }

        public Builder name(String var1);

        public Builder pipelinesRunningCount(Integer var1);

        public Builder roleArn(String var1);

        public Builder state(String var1);

        public Builder state(ChannelState var1);

        public Builder tags(Map<String, String> var1);

        public Builder vpc(VpcOutputSettingsDescription var1);

        default public Builder vpc(Consumer<VpcOutputSettingsDescription.Builder> vpc) {
            return this.vpc((VpcOutputSettingsDescription)((VpcOutputSettingsDescription.Builder)VpcOutputSettingsDescription.builder().applyMutation(vpc)).build());
        }

        public Builder anywhereSettings(DescribeAnywhereSettings var1);

        default public Builder anywhereSettings(Consumer<DescribeAnywhereSettings.Builder> anywhereSettings) {
            return this.anywhereSettings((DescribeAnywhereSettings)((DescribeAnywhereSettings.Builder)DescribeAnywhereSettings.builder().applyMutation(anywhereSettings)).build());
        }
    }
}

