/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.CloudWatchAlarmTemplateComparisonOperator;
import software.amazon.awssdk.services.medialive.model.CloudWatchAlarmTemplateStatistic;
import software.amazon.awssdk.services.medialive.model.CloudWatchAlarmTemplateTargetResourceType;
import software.amazon.awssdk.services.medialive.model.CloudWatchAlarmTemplateTreatMissingData;
import software.amazon.awssdk.services.medialive.model.MediaLiveRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateCloudWatchAlarmTemplateRequest
extends MediaLiveRequest
implements ToCopyableBuilder<Builder, UpdateCloudWatchAlarmTemplateRequest> {
    private static final SdkField<String> COMPARISON_OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComparisonOperator").getter(UpdateCloudWatchAlarmTemplateRequest.getter(UpdateCloudWatchAlarmTemplateRequest::comparisonOperatorAsString)).setter(UpdateCloudWatchAlarmTemplateRequest.setter(Builder::comparisonOperator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comparisonOperator").build()}).build();
    private static final SdkField<Integer> DATAPOINTS_TO_ALARM_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DatapointsToAlarm").getter(UpdateCloudWatchAlarmTemplateRequest.getter(UpdateCloudWatchAlarmTemplateRequest::datapointsToAlarm)).setter(UpdateCloudWatchAlarmTemplateRequest.setter(Builder::datapointsToAlarm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datapointsToAlarm").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateCloudWatchAlarmTemplateRequest.getter(UpdateCloudWatchAlarmTemplateRequest::description)).setter(UpdateCloudWatchAlarmTemplateRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Integer> EVALUATION_PERIODS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EvaluationPeriods").getter(UpdateCloudWatchAlarmTemplateRequest.getter(UpdateCloudWatchAlarmTemplateRequest::evaluationPeriods)).setter(UpdateCloudWatchAlarmTemplateRequest.setter(Builder::evaluationPeriods)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationPeriods").build()}).build();
    private static final SdkField<String> GROUP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupIdentifier").getter(UpdateCloudWatchAlarmTemplateRequest.getter(UpdateCloudWatchAlarmTemplateRequest::groupIdentifier)).setter(UpdateCloudWatchAlarmTemplateRequest.setter(Builder::groupIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupIdentifier").build()}).build();
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Identifier").getter(UpdateCloudWatchAlarmTemplateRequest.getter(UpdateCloudWatchAlarmTemplateRequest::identifier)).setter(UpdateCloudWatchAlarmTemplateRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("identifier").build()}).build();
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricName").getter(UpdateCloudWatchAlarmTemplateRequest.getter(UpdateCloudWatchAlarmTemplateRequest::metricName)).setter(UpdateCloudWatchAlarmTemplateRequest.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricName").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateCloudWatchAlarmTemplateRequest.getter(UpdateCloudWatchAlarmTemplateRequest::name)).setter(UpdateCloudWatchAlarmTemplateRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Integer> PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Period").getter(UpdateCloudWatchAlarmTemplateRequest.getter(UpdateCloudWatchAlarmTemplateRequest::period)).setter(UpdateCloudWatchAlarmTemplateRequest.setter(Builder::period)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("period").build()}).build();
    private static final SdkField<String> STATISTIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Statistic").getter(UpdateCloudWatchAlarmTemplateRequest.getter(UpdateCloudWatchAlarmTemplateRequest::statisticAsString)).setter(UpdateCloudWatchAlarmTemplateRequest.setter(Builder::statistic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statistic").build()}).build();
    private static final SdkField<String> TARGET_RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetResourceType").getter(UpdateCloudWatchAlarmTemplateRequest.getter(UpdateCloudWatchAlarmTemplateRequest::targetResourceTypeAsString)).setter(UpdateCloudWatchAlarmTemplateRequest.setter(Builder::targetResourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetResourceType").build()}).build();
    private static final SdkField<Double> THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Threshold").getter(UpdateCloudWatchAlarmTemplateRequest.getter(UpdateCloudWatchAlarmTemplateRequest::threshold)).setter(UpdateCloudWatchAlarmTemplateRequest.setter(Builder::threshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threshold").build()}).build();
    private static final SdkField<String> TREAT_MISSING_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TreatMissingData").getter(UpdateCloudWatchAlarmTemplateRequest.getter(UpdateCloudWatchAlarmTemplateRequest::treatMissingDataAsString)).setter(UpdateCloudWatchAlarmTemplateRequest.setter(Builder::treatMissingData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("treatMissingData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPARISON_OPERATOR_FIELD, DATAPOINTS_TO_ALARM_FIELD, DESCRIPTION_FIELD, EVALUATION_PERIODS_FIELD, GROUP_IDENTIFIER_FIELD, IDENTIFIER_FIELD, METRIC_NAME_FIELD, NAME_FIELD, PERIOD_FIELD, STATISTIC_FIELD, TARGET_RESOURCE_TYPE_FIELD, THRESHOLD_FIELD, TREAT_MISSING_DATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("comparisonOperator", COMPARISON_OPERATOR_FIELD);
            this.put("datapointsToAlarm", DATAPOINTS_TO_ALARM_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("evaluationPeriods", EVALUATION_PERIODS_FIELD);
            this.put("groupIdentifier", GROUP_IDENTIFIER_FIELD);
            this.put("identifier", IDENTIFIER_FIELD);
            this.put("metricName", METRIC_NAME_FIELD);
            this.put("name", NAME_FIELD);
            this.put("period", PERIOD_FIELD);
            this.put("statistic", STATISTIC_FIELD);
            this.put("targetResourceType", TARGET_RESOURCE_TYPE_FIELD);
            this.put("threshold", THRESHOLD_FIELD);
            this.put("treatMissingData", TREAT_MISSING_DATA_FIELD);
        }
    });
    private final String comparisonOperator;
    private final Integer datapointsToAlarm;
    private final String description;
    private final Integer evaluationPeriods;
    private final String groupIdentifier;
    private final String identifier;
    private final String metricName;
    private final String name;
    private final Integer period;
    private final String statistic;
    private final String targetResourceType;
    private final Double threshold;
    private final String treatMissingData;

    private UpdateCloudWatchAlarmTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.comparisonOperator = builder.comparisonOperator;
        this.datapointsToAlarm = builder.datapointsToAlarm;
        this.description = builder.description;
        this.evaluationPeriods = builder.evaluationPeriods;
        this.groupIdentifier = builder.groupIdentifier;
        this.identifier = builder.identifier;
        this.metricName = builder.metricName;
        this.name = builder.name;
        this.period = builder.period;
        this.statistic = builder.statistic;
        this.targetResourceType = builder.targetResourceType;
        this.threshold = builder.threshold;
        this.treatMissingData = builder.treatMissingData;
    }

    public final CloudWatchAlarmTemplateComparisonOperator comparisonOperator() {
        return CloudWatchAlarmTemplateComparisonOperator.fromValue(this.comparisonOperator);
    }

    public final String comparisonOperatorAsString() {
        return this.comparisonOperator;
    }

    public final Integer datapointsToAlarm() {
        return this.datapointsToAlarm;
    }

    public final String description() {
        return this.description;
    }

    public final Integer evaluationPeriods() {
        return this.evaluationPeriods;
    }

    public final String groupIdentifier() {
        return this.groupIdentifier;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final String metricName() {
        return this.metricName;
    }

    public final String name() {
        return this.name;
    }

    public final Integer period() {
        return this.period;
    }

    public final CloudWatchAlarmTemplateStatistic statistic() {
        return CloudWatchAlarmTemplateStatistic.fromValue(this.statistic);
    }

    public final String statisticAsString() {
        return this.statistic;
    }

    public final CloudWatchAlarmTemplateTargetResourceType targetResourceType() {
        return CloudWatchAlarmTemplateTargetResourceType.fromValue(this.targetResourceType);
    }

    public final String targetResourceTypeAsString() {
        return this.targetResourceType;
    }

    public final Double threshold() {
        return this.threshold;
    }

    public final CloudWatchAlarmTemplateTreatMissingData treatMissingData() {
        return CloudWatchAlarmTemplateTreatMissingData.fromValue(this.treatMissingData);
    }

    public final String treatMissingDataAsString() {
        return this.treatMissingData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.comparisonOperatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.datapointsToAlarm());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationPeriods());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.period());
        hashCode = 31 * hashCode + Objects.hashCode(this.statisticAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetResourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.threshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.treatMissingDataAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCloudWatchAlarmTemplateRequest)) {
            return false;
        }
        UpdateCloudWatchAlarmTemplateRequest other = (UpdateCloudWatchAlarmTemplateRequest)((Object)obj);
        return Objects.equals(this.comparisonOperatorAsString(), other.comparisonOperatorAsString()) && Objects.equals(this.datapointsToAlarm(), other.datapointsToAlarm()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.evaluationPeriods(), other.evaluationPeriods()) && Objects.equals(this.groupIdentifier(), other.groupIdentifier()) && Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.metricName(), other.metricName()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.period(), other.period()) && Objects.equals(this.statisticAsString(), other.statisticAsString()) && Objects.equals(this.targetResourceTypeAsString(), other.targetResourceTypeAsString()) && Objects.equals(this.threshold(), other.threshold()) && Objects.equals(this.treatMissingDataAsString(), other.treatMissingDataAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateCloudWatchAlarmTemplateRequest").add("ComparisonOperator", (Object)this.comparisonOperatorAsString()).add("DatapointsToAlarm", (Object)this.datapointsToAlarm()).add("Description", (Object)this.description()).add("EvaluationPeriods", (Object)this.evaluationPeriods()).add("GroupIdentifier", (Object)this.groupIdentifier()).add("Identifier", (Object)this.identifier()).add("MetricName", (Object)this.metricName()).add("Name", (Object)this.name()).add("Period", (Object)this.period()).add("Statistic", (Object)this.statisticAsString()).add("TargetResourceType", (Object)this.targetResourceTypeAsString()).add("Threshold", (Object)this.threshold()).add("TreatMissingData", (Object)this.treatMissingDataAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ComparisonOperator": {
                return Optional.ofNullable(clazz.cast(this.comparisonOperatorAsString()));
            }
            case "DatapointsToAlarm": {
                return Optional.ofNullable(clazz.cast(this.datapointsToAlarm()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "EvaluationPeriods": {
                return Optional.ofNullable(clazz.cast(this.evaluationPeriods()));
            }
            case "GroupIdentifier": {
                return Optional.ofNullable(clazz.cast(this.groupIdentifier()));
            }
            case "Identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "MetricName": {
                return Optional.ofNullable(clazz.cast(this.metricName()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Period": {
                return Optional.ofNullable(clazz.cast(this.period()));
            }
            case "Statistic": {
                return Optional.ofNullable(clazz.cast(this.statisticAsString()));
            }
            case "TargetResourceType": {
                return Optional.ofNullable(clazz.cast(this.targetResourceTypeAsString()));
            }
            case "Threshold": {
                return Optional.ofNullable(clazz.cast(this.threshold()));
            }
            case "TreatMissingData": {
                return Optional.ofNullable(clazz.cast(this.treatMissingDataAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateCloudWatchAlarmTemplateRequest, T> g) {
        return obj -> g.apply((UpdateCloudWatchAlarmTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveRequest.BuilderImpl
    implements Builder {
        private String comparisonOperator;
        private Integer datapointsToAlarm;
        private String description;
        private Integer evaluationPeriods;
        private String groupIdentifier;
        private String identifier;
        private String metricName;
        private String name;
        private Integer period;
        private String statistic;
        private String targetResourceType;
        private Double threshold;
        private String treatMissingData;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCloudWatchAlarmTemplateRequest model) {
            super(model);
            this.comparisonOperator(model.comparisonOperator);
            this.datapointsToAlarm(model.datapointsToAlarm);
            this.description(model.description);
            this.evaluationPeriods(model.evaluationPeriods);
            this.groupIdentifier(model.groupIdentifier);
            this.identifier(model.identifier);
            this.metricName(model.metricName);
            this.name(model.name);
            this.period(model.period);
            this.statistic(model.statistic);
            this.targetResourceType(model.targetResourceType);
            this.threshold(model.threshold);
            this.treatMissingData(model.treatMissingData);
        }

        public final String getComparisonOperator() {
            return this.comparisonOperator;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        @Override
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        @Override
        public final Builder comparisonOperator(CloudWatchAlarmTemplateComparisonOperator comparisonOperator) {
            this.comparisonOperator(comparisonOperator == null ? null : comparisonOperator.toString());
            return this;
        }

        public final Integer getDatapointsToAlarm() {
            return this.datapointsToAlarm;
        }

        public final void setDatapointsToAlarm(Integer datapointsToAlarm) {
            this.datapointsToAlarm = datapointsToAlarm;
        }

        @Override
        public final Builder datapointsToAlarm(Integer datapointsToAlarm) {
            this.datapointsToAlarm = datapointsToAlarm;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getEvaluationPeriods() {
            return this.evaluationPeriods;
        }

        public final void setEvaluationPeriods(Integer evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
        }

        @Override
        public final Builder evaluationPeriods(Integer evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
            return this;
        }

        public final String getGroupIdentifier() {
            return this.groupIdentifier;
        }

        public final void setGroupIdentifier(String groupIdentifier) {
            this.groupIdentifier = groupIdentifier;
        }

        @Override
        public final Builder groupIdentifier(String groupIdentifier) {
            this.groupIdentifier = groupIdentifier;
            return this;
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getMetricName() {
            return this.metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getPeriod() {
            return this.period;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        @Override
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final String getStatistic() {
            return this.statistic;
        }

        public final void setStatistic(String statistic) {
            this.statistic = statistic;
        }

        @Override
        public final Builder statistic(String statistic) {
            this.statistic = statistic;
            return this;
        }

        @Override
        public final Builder statistic(CloudWatchAlarmTemplateStatistic statistic) {
            this.statistic(statistic == null ? null : statistic.toString());
            return this;
        }

        public final String getTargetResourceType() {
            return this.targetResourceType;
        }

        public final void setTargetResourceType(String targetResourceType) {
            this.targetResourceType = targetResourceType;
        }

        @Override
        public final Builder targetResourceType(String targetResourceType) {
            this.targetResourceType = targetResourceType;
            return this;
        }

        @Override
        public final Builder targetResourceType(CloudWatchAlarmTemplateTargetResourceType targetResourceType) {
            this.targetResourceType(targetResourceType == null ? null : targetResourceType.toString());
            return this;
        }

        public final Double getThreshold() {
            return this.threshold;
        }

        public final void setThreshold(Double threshold) {
            this.threshold = threshold;
        }

        @Override
        public final Builder threshold(Double threshold) {
            this.threshold = threshold;
            return this;
        }

        public final String getTreatMissingData() {
            return this.treatMissingData;
        }

        public final void setTreatMissingData(String treatMissingData) {
            this.treatMissingData = treatMissingData;
        }

        @Override
        public final Builder treatMissingData(String treatMissingData) {
            this.treatMissingData = treatMissingData;
            return this;
        }

        @Override
        public final Builder treatMissingData(CloudWatchAlarmTemplateTreatMissingData treatMissingData) {
            this.treatMissingData(treatMissingData == null ? null : treatMissingData.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCloudWatchAlarmTemplateRequest build() {
            return new UpdateCloudWatchAlarmTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MediaLiveRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateCloudWatchAlarmTemplateRequest> {
        public Builder comparisonOperator(String var1);

        public Builder comparisonOperator(CloudWatchAlarmTemplateComparisonOperator var1);

        public Builder datapointsToAlarm(Integer var1);

        public Builder description(String var1);

        public Builder evaluationPeriods(Integer var1);

        public Builder groupIdentifier(String var1);

        public Builder identifier(String var1);

        public Builder metricName(String var1);

        public Builder name(String var1);

        public Builder period(Integer var1);

        public Builder statistic(String var1);

        public Builder statistic(CloudWatchAlarmTemplateStatistic var1);

        public Builder targetResourceType(String var1);

        public Builder targetResourceType(CloudWatchAlarmTemplateTargetResourceType var1);

        public Builder threshold(Double var1);

        public Builder treatMissingData(String var1);

        public Builder treatMissingData(CloudWatchAlarmTemplateTreatMissingData var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

