/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.TimecodeBurninFontSize;
import software.amazon.awssdk.services.medialive.model.TimecodeBurninPosition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TimecodeBurninSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TimecodeBurninSettings> {
    private static final SdkField<String> FONT_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FontSize").getter(TimecodeBurninSettings.getter(TimecodeBurninSettings::fontSizeAsString)).setter(TimecodeBurninSettings.setter(Builder::fontSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fontSize").build()}).build();
    private static final SdkField<String> POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Position").getter(TimecodeBurninSettings.getter(TimecodeBurninSettings::positionAsString)).setter(TimecodeBurninSettings.setter(Builder::position)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("position").build()}).build();
    private static final SdkField<String> PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Prefix").getter(TimecodeBurninSettings.getter(TimecodeBurninSettings::prefix)).setter(TimecodeBurninSettings.setter(Builder::prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prefix").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FONT_SIZE_FIELD, POSITION_FIELD, PREFIX_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("fontSize", FONT_SIZE_FIELD);
            this.put("position", POSITION_FIELD);
            this.put("prefix", PREFIX_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String fontSize;
    private final String position;
    private final String prefix;

    private TimecodeBurninSettings(BuilderImpl builder) {
        this.fontSize = builder.fontSize;
        this.position = builder.position;
        this.prefix = builder.prefix;
    }

    public final TimecodeBurninFontSize fontSize() {
        return TimecodeBurninFontSize.fromValue(this.fontSize);
    }

    public final String fontSizeAsString() {
        return this.fontSize;
    }

    public final TimecodeBurninPosition position() {
        return TimecodeBurninPosition.fromValue(this.position);
    }

    public final String positionAsString() {
        return this.position;
    }

    public final String prefix() {
        return this.prefix;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fontSizeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.positionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefix());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimecodeBurninSettings)) {
            return false;
        }
        TimecodeBurninSettings other = (TimecodeBurninSettings)obj;
        return Objects.equals(this.fontSizeAsString(), other.fontSizeAsString()) && Objects.equals(this.positionAsString(), other.positionAsString()) && Objects.equals(this.prefix(), other.prefix());
    }

    public final String toString() {
        return ToString.builder((String)"TimecodeBurninSettings").add("FontSize", (Object)this.fontSizeAsString()).add("Position", (Object)this.positionAsString()).add("Prefix", (Object)this.prefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FontSize": {
                return Optional.ofNullable(clazz.cast(this.fontSizeAsString()));
            }
            case "Position": {
                return Optional.ofNullable(clazz.cast(this.positionAsString()));
            }
            case "Prefix": {
                return Optional.ofNullable(clazz.cast(this.prefix()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TimecodeBurninSettings, T> g) {
        return obj -> g.apply((TimecodeBurninSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fontSize;
        private String position;
        private String prefix;

        private BuilderImpl() {
        }

        private BuilderImpl(TimecodeBurninSettings model) {
            this.fontSize(model.fontSize);
            this.position(model.position);
            this.prefix(model.prefix);
        }

        public final String getFontSize() {
            return this.fontSize;
        }

        public final void setFontSize(String fontSize) {
            this.fontSize = fontSize;
        }

        @Override
        public final Builder fontSize(String fontSize) {
            this.fontSize = fontSize;
            return this;
        }

        @Override
        public final Builder fontSize(TimecodeBurninFontSize fontSize) {
            this.fontSize(fontSize == null ? null : fontSize.toString());
            return this;
        }

        public final String getPosition() {
            return this.position;
        }

        public final void setPosition(String position) {
            this.position = position;
        }

        @Override
        public final Builder position(String position) {
            this.position = position;
            return this;
        }

        @Override
        public final Builder position(TimecodeBurninPosition position) {
            this.position(position == null ? null : position.toString());
            return this;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public TimecodeBurninSettings build() {
            return new TimecodeBurninSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TimecodeBurninSettings> {
        public Builder fontSize(String var1);

        public Builder fontSize(TimecodeBurninFontSize var1);

        public Builder position(String var1);

        public Builder position(TimecodeBurninPosition var1);

        public Builder prefix(String var1);
    }
}

