/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.FrameCaptureCdnSettings;
import software.amazon.awssdk.services.medialive.model.OutputLocationRef;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FrameCaptureGroupSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FrameCaptureGroupSettings> {
    private static final SdkField<OutputLocationRef> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Destination").getter(FrameCaptureGroupSettings.getter(FrameCaptureGroupSettings::destination)).setter(FrameCaptureGroupSettings.setter(Builder::destination)).constructor(OutputLocationRef::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()}).build();
    private static final SdkField<FrameCaptureCdnSettings> FRAME_CAPTURE_CDN_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FrameCaptureCdnSettings").getter(FrameCaptureGroupSettings.getter(FrameCaptureGroupSettings::frameCaptureCdnSettings)).setter(FrameCaptureGroupSettings.setter(Builder::frameCaptureCdnSettings)).constructor(FrameCaptureCdnSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frameCaptureCdnSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_FIELD, FRAME_CAPTURE_CDN_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("destination", DESTINATION_FIELD);
            this.put("frameCaptureCdnSettings", FRAME_CAPTURE_CDN_SETTINGS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final OutputLocationRef destination;
    private final FrameCaptureCdnSettings frameCaptureCdnSettings;

    private FrameCaptureGroupSettings(BuilderImpl builder) {
        this.destination = builder.destination;
        this.frameCaptureCdnSettings = builder.frameCaptureCdnSettings;
    }

    public final OutputLocationRef destination() {
        return this.destination;
    }

    public final FrameCaptureCdnSettings frameCaptureCdnSettings() {
        return this.frameCaptureCdnSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.frameCaptureCdnSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FrameCaptureGroupSettings)) {
            return false;
        }
        FrameCaptureGroupSettings other = (FrameCaptureGroupSettings)obj;
        return Objects.equals(this.destination(), other.destination()) && Objects.equals(this.frameCaptureCdnSettings(), other.frameCaptureCdnSettings());
    }

    public final String toString() {
        return ToString.builder((String)"FrameCaptureGroupSettings").add("Destination", (Object)this.destination()).add("FrameCaptureCdnSettings", (Object)this.frameCaptureCdnSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "FrameCaptureCdnSettings": {
                return Optional.ofNullable(clazz.cast(this.frameCaptureCdnSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<FrameCaptureGroupSettings, T> g) {
        return obj -> g.apply((FrameCaptureGroupSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private OutputLocationRef destination;
        private FrameCaptureCdnSettings frameCaptureCdnSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(FrameCaptureGroupSettings model) {
            this.destination(model.destination);
            this.frameCaptureCdnSettings(model.frameCaptureCdnSettings);
        }

        public final OutputLocationRef.Builder getDestination() {
            return this.destination != null ? this.destination.toBuilder() : null;
        }

        public final void setDestination(OutputLocationRef.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(OutputLocationRef destination) {
            this.destination = destination;
            return this;
        }

        public final FrameCaptureCdnSettings.Builder getFrameCaptureCdnSettings() {
            return this.frameCaptureCdnSettings != null ? this.frameCaptureCdnSettings.toBuilder() : null;
        }

        public final void setFrameCaptureCdnSettings(FrameCaptureCdnSettings.BuilderImpl frameCaptureCdnSettings) {
            this.frameCaptureCdnSettings = frameCaptureCdnSettings != null ? frameCaptureCdnSettings.build() : null;
        }

        @Override
        public final Builder frameCaptureCdnSettings(FrameCaptureCdnSettings frameCaptureCdnSettings) {
            this.frameCaptureCdnSettings = frameCaptureCdnSettings;
            return this;
        }

        public FrameCaptureGroupSettings build() {
            return new FrameCaptureGroupSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FrameCaptureGroupSettings> {
        public Builder destination(OutputLocationRef var1);

        default public Builder destination(Consumer<OutputLocationRef.Builder> destination) {
            return this.destination((OutputLocationRef)((OutputLocationRef.Builder)OutputLocationRef.builder().applyMutation(destination)).build());
        }

        public Builder frameCaptureCdnSettings(FrameCaptureCdnSettings var1);

        default public Builder frameCaptureCdnSettings(Consumer<FrameCaptureCdnSettings.Builder> frameCaptureCdnSettings) {
            return this.frameCaptureCdnSettings((FrameCaptureCdnSettings)((FrameCaptureCdnSettings.Builder)FrameCaptureCdnSettings.builder().applyMutation(frameCaptureCdnSettings)).build());
        }
    }
}

