/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.Scte35ArchiveAllowedFlag;
import software.amazon.awssdk.services.medialive.model.Scte35DeviceRestrictions;
import software.amazon.awssdk.services.medialive.model.Scte35NoRegionalBlackoutFlag;
import software.amazon.awssdk.services.medialive.model.Scte35WebDeliveryAllowedFlag;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Scte35DeliveryRestrictions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Scte35DeliveryRestrictions> {
    private static final SdkField<String> ARCHIVE_ALLOWED_FLAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ArchiveAllowedFlag").getter(Scte35DeliveryRestrictions.getter(Scte35DeliveryRestrictions::archiveAllowedFlagAsString)).setter(Scte35DeliveryRestrictions.setter(Builder::archiveAllowedFlag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("archiveAllowedFlag").build()}).build();
    private static final SdkField<String> DEVICE_RESTRICTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceRestrictions").getter(Scte35DeliveryRestrictions.getter(Scte35DeliveryRestrictions::deviceRestrictionsAsString)).setter(Scte35DeliveryRestrictions.setter(Builder::deviceRestrictions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceRestrictions").build()}).build();
    private static final SdkField<String> NO_REGIONAL_BLACKOUT_FLAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NoRegionalBlackoutFlag").getter(Scte35DeliveryRestrictions.getter(Scte35DeliveryRestrictions::noRegionalBlackoutFlagAsString)).setter(Scte35DeliveryRestrictions.setter(Builder::noRegionalBlackoutFlag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("noRegionalBlackoutFlag").build()}).build();
    private static final SdkField<String> WEB_DELIVERY_ALLOWED_FLAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WebDeliveryAllowedFlag").getter(Scte35DeliveryRestrictions.getter(Scte35DeliveryRestrictions::webDeliveryAllowedFlagAsString)).setter(Scte35DeliveryRestrictions.setter(Builder::webDeliveryAllowedFlag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("webDeliveryAllowedFlag").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHIVE_ALLOWED_FLAG_FIELD, DEVICE_RESTRICTIONS_FIELD, NO_REGIONAL_BLACKOUT_FLAG_FIELD, WEB_DELIVERY_ALLOWED_FLAG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("archiveAllowedFlag", ARCHIVE_ALLOWED_FLAG_FIELD);
            this.put("deviceRestrictions", DEVICE_RESTRICTIONS_FIELD);
            this.put("noRegionalBlackoutFlag", NO_REGIONAL_BLACKOUT_FLAG_FIELD);
            this.put("webDeliveryAllowedFlag", WEB_DELIVERY_ALLOWED_FLAG_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String archiveAllowedFlag;
    private final String deviceRestrictions;
    private final String noRegionalBlackoutFlag;
    private final String webDeliveryAllowedFlag;

    private Scte35DeliveryRestrictions(BuilderImpl builder) {
        this.archiveAllowedFlag = builder.archiveAllowedFlag;
        this.deviceRestrictions = builder.deviceRestrictions;
        this.noRegionalBlackoutFlag = builder.noRegionalBlackoutFlag;
        this.webDeliveryAllowedFlag = builder.webDeliveryAllowedFlag;
    }

    public final Scte35ArchiveAllowedFlag archiveAllowedFlag() {
        return Scte35ArchiveAllowedFlag.fromValue(this.archiveAllowedFlag);
    }

    public final String archiveAllowedFlagAsString() {
        return this.archiveAllowedFlag;
    }

    public final Scte35DeviceRestrictions deviceRestrictions() {
        return Scte35DeviceRestrictions.fromValue(this.deviceRestrictions);
    }

    public final String deviceRestrictionsAsString() {
        return this.deviceRestrictions;
    }

    public final Scte35NoRegionalBlackoutFlag noRegionalBlackoutFlag() {
        return Scte35NoRegionalBlackoutFlag.fromValue(this.noRegionalBlackoutFlag);
    }

    public final String noRegionalBlackoutFlagAsString() {
        return this.noRegionalBlackoutFlag;
    }

    public final Scte35WebDeliveryAllowedFlag webDeliveryAllowedFlag() {
        return Scte35WebDeliveryAllowedFlag.fromValue(this.webDeliveryAllowedFlag);
    }

    public final String webDeliveryAllowedFlagAsString() {
        return this.webDeliveryAllowedFlag;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.archiveAllowedFlagAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceRestrictionsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.noRegionalBlackoutFlagAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.webDeliveryAllowedFlagAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Scte35DeliveryRestrictions)) {
            return false;
        }
        Scte35DeliveryRestrictions other = (Scte35DeliveryRestrictions)obj;
        return Objects.equals(this.archiveAllowedFlagAsString(), other.archiveAllowedFlagAsString()) && Objects.equals(this.deviceRestrictionsAsString(), other.deviceRestrictionsAsString()) && Objects.equals(this.noRegionalBlackoutFlagAsString(), other.noRegionalBlackoutFlagAsString()) && Objects.equals(this.webDeliveryAllowedFlagAsString(), other.webDeliveryAllowedFlagAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Scte35DeliveryRestrictions").add("ArchiveAllowedFlag", (Object)this.archiveAllowedFlagAsString()).add("DeviceRestrictions", (Object)this.deviceRestrictionsAsString()).add("NoRegionalBlackoutFlag", (Object)this.noRegionalBlackoutFlagAsString()).add("WebDeliveryAllowedFlag", (Object)this.webDeliveryAllowedFlagAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ArchiveAllowedFlag": {
                return Optional.ofNullable(clazz.cast(this.archiveAllowedFlagAsString()));
            }
            case "DeviceRestrictions": {
                return Optional.ofNullable(clazz.cast(this.deviceRestrictionsAsString()));
            }
            case "NoRegionalBlackoutFlag": {
                return Optional.ofNullable(clazz.cast(this.noRegionalBlackoutFlagAsString()));
            }
            case "WebDeliveryAllowedFlag": {
                return Optional.ofNullable(clazz.cast(this.webDeliveryAllowedFlagAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Scte35DeliveryRestrictions, T> g) {
        return obj -> g.apply((Scte35DeliveryRestrictions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String archiveAllowedFlag;
        private String deviceRestrictions;
        private String noRegionalBlackoutFlag;
        private String webDeliveryAllowedFlag;

        private BuilderImpl() {
        }

        private BuilderImpl(Scte35DeliveryRestrictions model) {
            this.archiveAllowedFlag(model.archiveAllowedFlag);
            this.deviceRestrictions(model.deviceRestrictions);
            this.noRegionalBlackoutFlag(model.noRegionalBlackoutFlag);
            this.webDeliveryAllowedFlag(model.webDeliveryAllowedFlag);
        }

        public final String getArchiveAllowedFlag() {
            return this.archiveAllowedFlag;
        }

        public final void setArchiveAllowedFlag(String archiveAllowedFlag) {
            this.archiveAllowedFlag = archiveAllowedFlag;
        }

        @Override
        public final Builder archiveAllowedFlag(String archiveAllowedFlag) {
            this.archiveAllowedFlag = archiveAllowedFlag;
            return this;
        }

        @Override
        public final Builder archiveAllowedFlag(Scte35ArchiveAllowedFlag archiveAllowedFlag) {
            this.archiveAllowedFlag(archiveAllowedFlag == null ? null : archiveAllowedFlag.toString());
            return this;
        }

        public final String getDeviceRestrictions() {
            return this.deviceRestrictions;
        }

        public final void setDeviceRestrictions(String deviceRestrictions) {
            this.deviceRestrictions = deviceRestrictions;
        }

        @Override
        public final Builder deviceRestrictions(String deviceRestrictions) {
            this.deviceRestrictions = deviceRestrictions;
            return this;
        }

        @Override
        public final Builder deviceRestrictions(Scte35DeviceRestrictions deviceRestrictions) {
            this.deviceRestrictions(deviceRestrictions == null ? null : deviceRestrictions.toString());
            return this;
        }

        public final String getNoRegionalBlackoutFlag() {
            return this.noRegionalBlackoutFlag;
        }

        public final void setNoRegionalBlackoutFlag(String noRegionalBlackoutFlag) {
            this.noRegionalBlackoutFlag = noRegionalBlackoutFlag;
        }

        @Override
        public final Builder noRegionalBlackoutFlag(String noRegionalBlackoutFlag) {
            this.noRegionalBlackoutFlag = noRegionalBlackoutFlag;
            return this;
        }

        @Override
        public final Builder noRegionalBlackoutFlag(Scte35NoRegionalBlackoutFlag noRegionalBlackoutFlag) {
            this.noRegionalBlackoutFlag(noRegionalBlackoutFlag == null ? null : noRegionalBlackoutFlag.toString());
            return this;
        }

        public final String getWebDeliveryAllowedFlag() {
            return this.webDeliveryAllowedFlag;
        }

        public final void setWebDeliveryAllowedFlag(String webDeliveryAllowedFlag) {
            this.webDeliveryAllowedFlag = webDeliveryAllowedFlag;
        }

        @Override
        public final Builder webDeliveryAllowedFlag(String webDeliveryAllowedFlag) {
            this.webDeliveryAllowedFlag = webDeliveryAllowedFlag;
            return this;
        }

        @Override
        public final Builder webDeliveryAllowedFlag(Scte35WebDeliveryAllowedFlag webDeliveryAllowedFlag) {
            this.webDeliveryAllowedFlag(webDeliveryAllowedFlag == null ? null : webDeliveryAllowedFlag.toString());
            return this;
        }

        public Scte35DeliveryRestrictions build() {
            return new Scte35DeliveryRestrictions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Scte35DeliveryRestrictions> {
        public Builder archiveAllowedFlag(String var1);

        public Builder archiveAllowedFlag(Scte35ArchiveAllowedFlag var1);

        public Builder deviceRestrictions(String var1);

        public Builder deviceRestrictions(Scte35DeviceRestrictions var1);

        public Builder noRegionalBlackoutFlag(String var1);

        public Builder noRegionalBlackoutFlag(Scte35NoRegionalBlackoutFlag var1);

        public Builder webDeliveryAllowedFlag(String var1);

        public Builder webDeliveryAllowedFlag(Scte35WebDeliveryAllowedFlag var1);
    }
}

