/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.medialive.model.MediaLiveRequest;
import software.amazon.awssdk.services.medialive.model.TagMapCopier;
import software.amazon.awssdk.services.medialive.model.___listOf__stringPatternSCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSignalMapRequest
extends MediaLiveRequest
implements ToCopyableBuilder<Builder, CreateSignalMapRequest> {
    private static final SdkField<List<String>> CLOUD_WATCH_ALARM_TEMPLATE_GROUP_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CloudWatchAlarmTemplateGroupIdentifiers").getter(CreateSignalMapRequest.getter(CreateSignalMapRequest::cloudWatchAlarmTemplateGroupIdentifiers)).setter(CreateSignalMapRequest.setter(Builder::cloudWatchAlarmTemplateGroupIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchAlarmTemplateGroupIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateSignalMapRequest.getter(CreateSignalMapRequest::description)).setter(CreateSignalMapRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DISCOVERY_ENTRY_POINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DiscoveryEntryPointArn").getter(CreateSignalMapRequest.getter(CreateSignalMapRequest::discoveryEntryPointArn)).setter(CreateSignalMapRequest.setter(Builder::discoveryEntryPointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("discoveryEntryPointArn").build()}).build();
    private static final SdkField<List<String>> EVENT_BRIDGE_RULE_TEMPLATE_GROUP_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EventBridgeRuleTemplateGroupIdentifiers").getter(CreateSignalMapRequest.getter(CreateSignalMapRequest::eventBridgeRuleTemplateGroupIdentifiers)).setter(CreateSignalMapRequest.setter(Builder::eventBridgeRuleTemplateGroupIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventBridgeRuleTemplateGroupIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateSignalMapRequest.getter(CreateSignalMapRequest::name)).setter(CreateSignalMapRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateSignalMapRequest.getter(CreateSignalMapRequest::tags)).setter(CreateSignalMapRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_WATCH_ALARM_TEMPLATE_GROUP_IDENTIFIERS_FIELD, DESCRIPTION_FIELD, DISCOVERY_ENTRY_POINT_ARN_FIELD, EVENT_BRIDGE_RULE_TEMPLATE_GROUP_IDENTIFIERS_FIELD, NAME_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("cloudWatchAlarmTemplateGroupIdentifiers", CLOUD_WATCH_ALARM_TEMPLATE_GROUP_IDENTIFIERS_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("discoveryEntryPointArn", DISCOVERY_ENTRY_POINT_ARN_FIELD);
            this.put("eventBridgeRuleTemplateGroupIdentifiers", EVENT_BRIDGE_RULE_TEMPLATE_GROUP_IDENTIFIERS_FIELD);
            this.put("name", NAME_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private final List<String> cloudWatchAlarmTemplateGroupIdentifiers;
    private final String description;
    private final String discoveryEntryPointArn;
    private final List<String> eventBridgeRuleTemplateGroupIdentifiers;
    private final String name;
    private final Map<String, String> tags;

    private CreateSignalMapRequest(BuilderImpl builder) {
        super(builder);
        this.cloudWatchAlarmTemplateGroupIdentifiers = builder.cloudWatchAlarmTemplateGroupIdentifiers;
        this.description = builder.description;
        this.discoveryEntryPointArn = builder.discoveryEntryPointArn;
        this.eventBridgeRuleTemplateGroupIdentifiers = builder.eventBridgeRuleTemplateGroupIdentifiers;
        this.name = builder.name;
        this.tags = builder.tags;
    }

    public final boolean hasCloudWatchAlarmTemplateGroupIdentifiers() {
        return this.cloudWatchAlarmTemplateGroupIdentifiers != null && !(this.cloudWatchAlarmTemplateGroupIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<String> cloudWatchAlarmTemplateGroupIdentifiers() {
        return this.cloudWatchAlarmTemplateGroupIdentifiers;
    }

    public final String description() {
        return this.description;
    }

    public final String discoveryEntryPointArn() {
        return this.discoveryEntryPointArn;
    }

    public final boolean hasEventBridgeRuleTemplateGroupIdentifiers() {
        return this.eventBridgeRuleTemplateGroupIdentifiers != null && !(this.eventBridgeRuleTemplateGroupIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<String> eventBridgeRuleTemplateGroupIdentifiers() {
        return this.eventBridgeRuleTemplateGroupIdentifiers;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCloudWatchAlarmTemplateGroupIdentifiers() ? this.cloudWatchAlarmTemplateGroupIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.discoveryEntryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventBridgeRuleTemplateGroupIdentifiers() ? this.eventBridgeRuleTemplateGroupIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSignalMapRequest)) {
            return false;
        }
        CreateSignalMapRequest other = (CreateSignalMapRequest)((Object)obj);
        return this.hasCloudWatchAlarmTemplateGroupIdentifiers() == other.hasCloudWatchAlarmTemplateGroupIdentifiers() && Objects.equals(this.cloudWatchAlarmTemplateGroupIdentifiers(), other.cloudWatchAlarmTemplateGroupIdentifiers()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.discoveryEntryPointArn(), other.discoveryEntryPointArn()) && this.hasEventBridgeRuleTemplateGroupIdentifiers() == other.hasEventBridgeRuleTemplateGroupIdentifiers() && Objects.equals(this.eventBridgeRuleTemplateGroupIdentifiers(), other.eventBridgeRuleTemplateGroupIdentifiers()) && Objects.equals(this.name(), other.name()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSignalMapRequest").add("CloudWatchAlarmTemplateGroupIdentifiers", this.hasCloudWatchAlarmTemplateGroupIdentifiers() ? this.cloudWatchAlarmTemplateGroupIdentifiers() : null).add("Description", (Object)this.description()).add("DiscoveryEntryPointArn", (Object)this.discoveryEntryPointArn()).add("EventBridgeRuleTemplateGroupIdentifiers", this.hasEventBridgeRuleTemplateGroupIdentifiers() ? this.eventBridgeRuleTemplateGroupIdentifiers() : null).add("Name", (Object)this.name()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CloudWatchAlarmTemplateGroupIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchAlarmTemplateGroupIdentifiers()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DiscoveryEntryPointArn": {
                return Optional.ofNullable(clazz.cast(this.discoveryEntryPointArn()));
            }
            case "EventBridgeRuleTemplateGroupIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.eventBridgeRuleTemplateGroupIdentifiers()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateSignalMapRequest, T> g) {
        return obj -> g.apply((CreateSignalMapRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveRequest.BuilderImpl
    implements Builder {
        private List<String> cloudWatchAlarmTemplateGroupIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private String description;
        private String discoveryEntryPointArn;
        private List<String> eventBridgeRuleTemplateGroupIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSignalMapRequest model) {
            super(model);
            this.cloudWatchAlarmTemplateGroupIdentifiers(model.cloudWatchAlarmTemplateGroupIdentifiers);
            this.description(model.description);
            this.discoveryEntryPointArn(model.discoveryEntryPointArn);
            this.eventBridgeRuleTemplateGroupIdentifiers(model.eventBridgeRuleTemplateGroupIdentifiers);
            this.name(model.name);
            this.tags(model.tags);
        }

        public final Collection<String> getCloudWatchAlarmTemplateGroupIdentifiers() {
            if (this.cloudWatchAlarmTemplateGroupIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.cloudWatchAlarmTemplateGroupIdentifiers;
        }

        public final void setCloudWatchAlarmTemplateGroupIdentifiers(Collection<String> cloudWatchAlarmTemplateGroupIdentifiers) {
            this.cloudWatchAlarmTemplateGroupIdentifiers = ___listOf__stringPatternSCopier.copy(cloudWatchAlarmTemplateGroupIdentifiers);
        }

        @Override
        public final Builder cloudWatchAlarmTemplateGroupIdentifiers(Collection<String> cloudWatchAlarmTemplateGroupIdentifiers) {
            this.cloudWatchAlarmTemplateGroupIdentifiers = ___listOf__stringPatternSCopier.copy(cloudWatchAlarmTemplateGroupIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchAlarmTemplateGroupIdentifiers(String ... cloudWatchAlarmTemplateGroupIdentifiers) {
            this.cloudWatchAlarmTemplateGroupIdentifiers(Arrays.asList(cloudWatchAlarmTemplateGroupIdentifiers));
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDiscoveryEntryPointArn() {
            return this.discoveryEntryPointArn;
        }

        public final void setDiscoveryEntryPointArn(String discoveryEntryPointArn) {
            this.discoveryEntryPointArn = discoveryEntryPointArn;
        }

        @Override
        public final Builder discoveryEntryPointArn(String discoveryEntryPointArn) {
            this.discoveryEntryPointArn = discoveryEntryPointArn;
            return this;
        }

        public final Collection<String> getEventBridgeRuleTemplateGroupIdentifiers() {
            if (this.eventBridgeRuleTemplateGroupIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.eventBridgeRuleTemplateGroupIdentifiers;
        }

        public final void setEventBridgeRuleTemplateGroupIdentifiers(Collection<String> eventBridgeRuleTemplateGroupIdentifiers) {
            this.eventBridgeRuleTemplateGroupIdentifiers = ___listOf__stringPatternSCopier.copy(eventBridgeRuleTemplateGroupIdentifiers);
        }

        @Override
        public final Builder eventBridgeRuleTemplateGroupIdentifiers(Collection<String> eventBridgeRuleTemplateGroupIdentifiers) {
            this.eventBridgeRuleTemplateGroupIdentifiers = ___listOf__stringPatternSCopier.copy(eventBridgeRuleTemplateGroupIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventBridgeRuleTemplateGroupIdentifiers(String ... eventBridgeRuleTemplateGroupIdentifiers) {
            this.eventBridgeRuleTemplateGroupIdentifiers(Arrays.asList(eventBridgeRuleTemplateGroupIdentifiers));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSignalMapRequest build() {
            return new CreateSignalMapRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MediaLiveRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSignalMapRequest> {
        public Builder cloudWatchAlarmTemplateGroupIdentifiers(Collection<String> var1);

        public Builder cloudWatchAlarmTemplateGroupIdentifiers(String ... var1);

        public Builder description(String var1);

        public Builder discoveryEntryPointArn(String var1);

        public Builder eventBridgeRuleTemplateGroupIdentifiers(Collection<String> var1);

        public Builder eventBridgeRuleTemplateGroupIdentifiers(String ... var1);

        public Builder name(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

