/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.NetworkInterfaceMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NodeInterfaceMappingCreateRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NodeInterfaceMappingCreateRequest> {
    private static final SdkField<String> LOGICAL_INTERFACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogicalInterfaceName").getter(NodeInterfaceMappingCreateRequest.getter(NodeInterfaceMappingCreateRequest::logicalInterfaceName)).setter(NodeInterfaceMappingCreateRequest.setter(Builder::logicalInterfaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logicalInterfaceName").build()}).build();
    private static final SdkField<String> NETWORK_INTERFACE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInterfaceMode").getter(NodeInterfaceMappingCreateRequest.getter(NodeInterfaceMappingCreateRequest::networkInterfaceModeAsString)).setter(NodeInterfaceMappingCreateRequest.setter(Builder::networkInterfaceMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInterfaceMode").build()}).build();
    private static final SdkField<String> PHYSICAL_INTERFACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PhysicalInterfaceName").getter(NodeInterfaceMappingCreateRequest.getter(NodeInterfaceMappingCreateRequest::physicalInterfaceName)).setter(NodeInterfaceMappingCreateRequest.setter(Builder::physicalInterfaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("physicalInterfaceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOGICAL_INTERFACE_NAME_FIELD, NETWORK_INTERFACE_MODE_FIELD, PHYSICAL_INTERFACE_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String logicalInterfaceName;
    private final String networkInterfaceMode;
    private final String physicalInterfaceName;

    private NodeInterfaceMappingCreateRequest(BuilderImpl builder) {
        this.logicalInterfaceName = builder.logicalInterfaceName;
        this.networkInterfaceMode = builder.networkInterfaceMode;
        this.physicalInterfaceName = builder.physicalInterfaceName;
    }

    public final String logicalInterfaceName() {
        return this.logicalInterfaceName;
    }

    public final NetworkInterfaceMode networkInterfaceMode() {
        return NetworkInterfaceMode.fromValue(this.networkInterfaceMode);
    }

    public final String networkInterfaceModeAsString() {
        return this.networkInterfaceMode;
    }

    public final String physicalInterfaceName() {
        return this.physicalInterfaceName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logicalInterfaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.physicalInterfaceName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeInterfaceMappingCreateRequest)) {
            return false;
        }
        NodeInterfaceMappingCreateRequest other = (NodeInterfaceMappingCreateRequest)obj;
        return Objects.equals(this.logicalInterfaceName(), other.logicalInterfaceName()) && Objects.equals(this.networkInterfaceModeAsString(), other.networkInterfaceModeAsString()) && Objects.equals(this.physicalInterfaceName(), other.physicalInterfaceName());
    }

    public final String toString() {
        return ToString.builder((String)"NodeInterfaceMappingCreateRequest").add("LogicalInterfaceName", (Object)this.logicalInterfaceName()).add("NetworkInterfaceMode", (Object)this.networkInterfaceModeAsString()).add("PhysicalInterfaceName", (Object)this.physicalInterfaceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LogicalInterfaceName": {
                return Optional.ofNullable(clazz.cast(this.logicalInterfaceName()));
            }
            case "NetworkInterfaceMode": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceModeAsString()));
            }
            case "PhysicalInterfaceName": {
                return Optional.ofNullable(clazz.cast(this.physicalInterfaceName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NodeInterfaceMappingCreateRequest, T> g) {
        return obj -> g.apply((NodeInterfaceMappingCreateRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String logicalInterfaceName;
        private String networkInterfaceMode;
        private String physicalInterfaceName;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeInterfaceMappingCreateRequest model) {
            this.logicalInterfaceName(model.logicalInterfaceName);
            this.networkInterfaceMode(model.networkInterfaceMode);
            this.physicalInterfaceName(model.physicalInterfaceName);
        }

        public final String getLogicalInterfaceName() {
            return this.logicalInterfaceName;
        }

        public final void setLogicalInterfaceName(String logicalInterfaceName) {
            this.logicalInterfaceName = logicalInterfaceName;
        }

        @Override
        public final Builder logicalInterfaceName(String logicalInterfaceName) {
            this.logicalInterfaceName = logicalInterfaceName;
            return this;
        }

        public final String getNetworkInterfaceMode() {
            return this.networkInterfaceMode;
        }

        public final void setNetworkInterfaceMode(String networkInterfaceMode) {
            this.networkInterfaceMode = networkInterfaceMode;
        }

        @Override
        public final Builder networkInterfaceMode(String networkInterfaceMode) {
            this.networkInterfaceMode = networkInterfaceMode;
            return this;
        }

        @Override
        public final Builder networkInterfaceMode(NetworkInterfaceMode networkInterfaceMode) {
            this.networkInterfaceMode(networkInterfaceMode == null ? null : networkInterfaceMode.toString());
            return this;
        }

        public final String getPhysicalInterfaceName() {
            return this.physicalInterfaceName;
        }

        public final void setPhysicalInterfaceName(String physicalInterfaceName) {
            this.physicalInterfaceName = physicalInterfaceName;
        }

        @Override
        public final Builder physicalInterfaceName(String physicalInterfaceName) {
            this.physicalInterfaceName = physicalInterfaceName;
            return this;
        }

        public NodeInterfaceMappingCreateRequest build() {
            return new NodeInterfaceMappingCreateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NodeInterfaceMappingCreateRequest> {
        public Builder logicalInterfaceName(String var1);

        public Builder networkInterfaceMode(String var1);

        public Builder networkInterfaceMode(NetworkInterfaceMode var1);

        public Builder physicalInterfaceName(String var1);
    }
}

