/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.MediaLiveRequest;
import software.amazon.awssdk.services.medialive.model.___listOf__stringPatternSCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartUpdateSignalMapRequest
extends MediaLiveRequest
implements ToCopyableBuilder<Builder, StartUpdateSignalMapRequest> {
    private static final SdkField<List<String>> CLOUD_WATCH_ALARM_TEMPLATE_GROUP_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CloudWatchAlarmTemplateGroupIdentifiers").getter(StartUpdateSignalMapRequest.getter(StartUpdateSignalMapRequest::cloudWatchAlarmTemplateGroupIdentifiers)).setter(StartUpdateSignalMapRequest.setter(Builder::cloudWatchAlarmTemplateGroupIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchAlarmTemplateGroupIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(StartUpdateSignalMapRequest.getter(StartUpdateSignalMapRequest::description)).setter(StartUpdateSignalMapRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DISCOVERY_ENTRY_POINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DiscoveryEntryPointArn").getter(StartUpdateSignalMapRequest.getter(StartUpdateSignalMapRequest::discoveryEntryPointArn)).setter(StartUpdateSignalMapRequest.setter(Builder::discoveryEntryPointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("discoveryEntryPointArn").build()}).build();
    private static final SdkField<List<String>> EVENT_BRIDGE_RULE_TEMPLATE_GROUP_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EventBridgeRuleTemplateGroupIdentifiers").getter(StartUpdateSignalMapRequest.getter(StartUpdateSignalMapRequest::eventBridgeRuleTemplateGroupIdentifiers)).setter(StartUpdateSignalMapRequest.setter(Builder::eventBridgeRuleTemplateGroupIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventBridgeRuleTemplateGroupIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> FORCE_REDISCOVERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ForceRediscovery").getter(StartUpdateSignalMapRequest.getter(StartUpdateSignalMapRequest::forceRediscovery)).setter(StartUpdateSignalMapRequest.setter(Builder::forceRediscovery)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forceRediscovery").build()}).build();
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Identifier").getter(StartUpdateSignalMapRequest.getter(StartUpdateSignalMapRequest::identifier)).setter(StartUpdateSignalMapRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("identifier").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(StartUpdateSignalMapRequest.getter(StartUpdateSignalMapRequest::name)).setter(StartUpdateSignalMapRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_WATCH_ALARM_TEMPLATE_GROUP_IDENTIFIERS_FIELD, DESCRIPTION_FIELD, DISCOVERY_ENTRY_POINT_ARN_FIELD, EVENT_BRIDGE_RULE_TEMPLATE_GROUP_IDENTIFIERS_FIELD, FORCE_REDISCOVERY_FIELD, IDENTIFIER_FIELD, NAME_FIELD));
    private final List<String> cloudWatchAlarmTemplateGroupIdentifiers;
    private final String description;
    private final String discoveryEntryPointArn;
    private final List<String> eventBridgeRuleTemplateGroupIdentifiers;
    private final Boolean forceRediscovery;
    private final String identifier;
    private final String name;

    private StartUpdateSignalMapRequest(BuilderImpl builder) {
        super(builder);
        this.cloudWatchAlarmTemplateGroupIdentifiers = builder.cloudWatchAlarmTemplateGroupIdentifiers;
        this.description = builder.description;
        this.discoveryEntryPointArn = builder.discoveryEntryPointArn;
        this.eventBridgeRuleTemplateGroupIdentifiers = builder.eventBridgeRuleTemplateGroupIdentifiers;
        this.forceRediscovery = builder.forceRediscovery;
        this.identifier = builder.identifier;
        this.name = builder.name;
    }

    public final boolean hasCloudWatchAlarmTemplateGroupIdentifiers() {
        return this.cloudWatchAlarmTemplateGroupIdentifiers != null && !(this.cloudWatchAlarmTemplateGroupIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<String> cloudWatchAlarmTemplateGroupIdentifiers() {
        return this.cloudWatchAlarmTemplateGroupIdentifiers;
    }

    public final String description() {
        return this.description;
    }

    public final String discoveryEntryPointArn() {
        return this.discoveryEntryPointArn;
    }

    public final boolean hasEventBridgeRuleTemplateGroupIdentifiers() {
        return this.eventBridgeRuleTemplateGroupIdentifiers != null && !(this.eventBridgeRuleTemplateGroupIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<String> eventBridgeRuleTemplateGroupIdentifiers() {
        return this.eventBridgeRuleTemplateGroupIdentifiers;
    }

    public final Boolean forceRediscovery() {
        return this.forceRediscovery;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final String name() {
        return this.name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCloudWatchAlarmTemplateGroupIdentifiers() ? this.cloudWatchAlarmTemplateGroupIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.discoveryEntryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventBridgeRuleTemplateGroupIdentifiers() ? this.eventBridgeRuleTemplateGroupIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.forceRediscovery());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartUpdateSignalMapRequest)) {
            return false;
        }
        StartUpdateSignalMapRequest other = (StartUpdateSignalMapRequest)((Object)obj);
        return this.hasCloudWatchAlarmTemplateGroupIdentifiers() == other.hasCloudWatchAlarmTemplateGroupIdentifiers() && Objects.equals(this.cloudWatchAlarmTemplateGroupIdentifiers(), other.cloudWatchAlarmTemplateGroupIdentifiers()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.discoveryEntryPointArn(), other.discoveryEntryPointArn()) && this.hasEventBridgeRuleTemplateGroupIdentifiers() == other.hasEventBridgeRuleTemplateGroupIdentifiers() && Objects.equals(this.eventBridgeRuleTemplateGroupIdentifiers(), other.eventBridgeRuleTemplateGroupIdentifiers()) && Objects.equals(this.forceRediscovery(), other.forceRediscovery()) && Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.name(), other.name());
    }

    public final String toString() {
        return ToString.builder((String)"StartUpdateSignalMapRequest").add("CloudWatchAlarmTemplateGroupIdentifiers", this.hasCloudWatchAlarmTemplateGroupIdentifiers() ? this.cloudWatchAlarmTemplateGroupIdentifiers() : null).add("Description", (Object)this.description()).add("DiscoveryEntryPointArn", (Object)this.discoveryEntryPointArn()).add("EventBridgeRuleTemplateGroupIdentifiers", this.hasEventBridgeRuleTemplateGroupIdentifiers() ? this.eventBridgeRuleTemplateGroupIdentifiers() : null).add("ForceRediscovery", (Object)this.forceRediscovery()).add("Identifier", (Object)this.identifier()).add("Name", (Object)this.name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CloudWatchAlarmTemplateGroupIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchAlarmTemplateGroupIdentifiers()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DiscoveryEntryPointArn": {
                return Optional.ofNullable(clazz.cast(this.discoveryEntryPointArn()));
            }
            case "EventBridgeRuleTemplateGroupIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.eventBridgeRuleTemplateGroupIdentifiers()));
            }
            case "ForceRediscovery": {
                return Optional.ofNullable(clazz.cast(this.forceRediscovery()));
            }
            case "Identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartUpdateSignalMapRequest, T> g) {
        return obj -> g.apply((StartUpdateSignalMapRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveRequest.BuilderImpl
    implements Builder {
        private List<String> cloudWatchAlarmTemplateGroupIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private String description;
        private String discoveryEntryPointArn;
        private List<String> eventBridgeRuleTemplateGroupIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private Boolean forceRediscovery;
        private String identifier;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(StartUpdateSignalMapRequest model) {
            super(model);
            this.cloudWatchAlarmTemplateGroupIdentifiers(model.cloudWatchAlarmTemplateGroupIdentifiers);
            this.description(model.description);
            this.discoveryEntryPointArn(model.discoveryEntryPointArn);
            this.eventBridgeRuleTemplateGroupIdentifiers(model.eventBridgeRuleTemplateGroupIdentifiers);
            this.forceRediscovery(model.forceRediscovery);
            this.identifier(model.identifier);
            this.name(model.name);
        }

        public final Collection<String> getCloudWatchAlarmTemplateGroupIdentifiers() {
            if (this.cloudWatchAlarmTemplateGroupIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.cloudWatchAlarmTemplateGroupIdentifiers;
        }

        public final void setCloudWatchAlarmTemplateGroupIdentifiers(Collection<String> cloudWatchAlarmTemplateGroupIdentifiers) {
            this.cloudWatchAlarmTemplateGroupIdentifiers = ___listOf__stringPatternSCopier.copy(cloudWatchAlarmTemplateGroupIdentifiers);
        }

        @Override
        public final Builder cloudWatchAlarmTemplateGroupIdentifiers(Collection<String> cloudWatchAlarmTemplateGroupIdentifiers) {
            this.cloudWatchAlarmTemplateGroupIdentifiers = ___listOf__stringPatternSCopier.copy(cloudWatchAlarmTemplateGroupIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchAlarmTemplateGroupIdentifiers(String ... cloudWatchAlarmTemplateGroupIdentifiers) {
            this.cloudWatchAlarmTemplateGroupIdentifiers(Arrays.asList(cloudWatchAlarmTemplateGroupIdentifiers));
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDiscoveryEntryPointArn() {
            return this.discoveryEntryPointArn;
        }

        public final void setDiscoveryEntryPointArn(String discoveryEntryPointArn) {
            this.discoveryEntryPointArn = discoveryEntryPointArn;
        }

        @Override
        public final Builder discoveryEntryPointArn(String discoveryEntryPointArn) {
            this.discoveryEntryPointArn = discoveryEntryPointArn;
            return this;
        }

        public final Collection<String> getEventBridgeRuleTemplateGroupIdentifiers() {
            if (this.eventBridgeRuleTemplateGroupIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.eventBridgeRuleTemplateGroupIdentifiers;
        }

        public final void setEventBridgeRuleTemplateGroupIdentifiers(Collection<String> eventBridgeRuleTemplateGroupIdentifiers) {
            this.eventBridgeRuleTemplateGroupIdentifiers = ___listOf__stringPatternSCopier.copy(eventBridgeRuleTemplateGroupIdentifiers);
        }

        @Override
        public final Builder eventBridgeRuleTemplateGroupIdentifiers(Collection<String> eventBridgeRuleTemplateGroupIdentifiers) {
            this.eventBridgeRuleTemplateGroupIdentifiers = ___listOf__stringPatternSCopier.copy(eventBridgeRuleTemplateGroupIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventBridgeRuleTemplateGroupIdentifiers(String ... eventBridgeRuleTemplateGroupIdentifiers) {
            this.eventBridgeRuleTemplateGroupIdentifiers(Arrays.asList(eventBridgeRuleTemplateGroupIdentifiers));
            return this;
        }

        public final Boolean getForceRediscovery() {
            return this.forceRediscovery;
        }

        public final void setForceRediscovery(Boolean forceRediscovery) {
            this.forceRediscovery = forceRediscovery;
        }

        @Override
        public final Builder forceRediscovery(Boolean forceRediscovery) {
            this.forceRediscovery = forceRediscovery;
            return this;
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartUpdateSignalMapRequest build() {
            return new StartUpdateSignalMapRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaLiveRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartUpdateSignalMapRequest> {
        public Builder cloudWatchAlarmTemplateGroupIdentifiers(Collection<String> var1);

        public Builder cloudWatchAlarmTemplateGroupIdentifiers(String ... var1);

        public Builder description(String var1);

        public Builder discoveryEntryPointArn(String var1);

        public Builder eventBridgeRuleTemplateGroupIdentifiers(Collection<String> var1);

        public Builder eventBridgeRuleTemplateGroupIdentifiers(String ... var1);

        public Builder forceRediscovery(Boolean var1);

        public Builder identifier(String var1);

        public Builder name(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

