/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.DescribeNodeSummary;
import software.amazon.awssdk.services.medialive.model.MediaLiveResponse;
import software.amazon.awssdk.services.medialive.model.___listOfDescribeNodeSummaryCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListNodesResponse
extends MediaLiveResponse
implements ToCopyableBuilder<Builder, ListNodesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListNodesResponse.getter(ListNodesResponse::nextToken)).setter(ListNodesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<DescribeNodeSummary>> NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Nodes").getter(ListNodesResponse.getter(ListNodesResponse::nodes)).setter(ListNodesResponse.setter(Builder::nodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DescribeNodeSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, NODES_FIELD));
    private final String nextToken;
    private final List<DescribeNodeSummary> nodes;

    private ListNodesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.nodes = builder.nodes;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasNodes() {
        return this.nodes != null && !(this.nodes instanceof SdkAutoConstructList);
    }

    public final List<DescribeNodeSummary> nodes() {
        return this.nodes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNodes() ? this.nodes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNodesResponse)) {
            return false;
        }
        ListNodesResponse other = (ListNodesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasNodes() == other.hasNodes() && Objects.equals(this.nodes(), other.nodes());
    }

    public final String toString() {
        return ToString.builder((String)"ListNodesResponse").add("NextToken", (Object)this.nextToken()).add("Nodes", this.hasNodes() ? this.nodes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Nodes": {
                return Optional.ofNullable(clazz.cast(this.nodes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListNodesResponse, T> g) {
        return obj -> g.apply((ListNodesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<DescribeNodeSummary> nodes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListNodesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.nodes(model.nodes);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<DescribeNodeSummary.Builder> getNodes() {
            List<DescribeNodeSummary.Builder> result = ___listOfDescribeNodeSummaryCopier.copyToBuilder(this.nodes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNodes(Collection<DescribeNodeSummary.BuilderImpl> nodes) {
            this.nodes = ___listOfDescribeNodeSummaryCopier.copyFromBuilder(nodes);
        }

        @Override
        public final Builder nodes(Collection<DescribeNodeSummary> nodes) {
            this.nodes = ___listOfDescribeNodeSummaryCopier.copy(nodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodes(DescribeNodeSummary ... nodes) {
            this.nodes(Arrays.asList(nodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodes(Consumer<DescribeNodeSummary.Builder> ... nodes) {
            this.nodes(Stream.of(nodes).map(c -> (DescribeNodeSummary)((DescribeNodeSummary.Builder)DescribeNodeSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListNodesResponse build() {
            return new ListNodesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaLiveResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListNodesResponse> {
        public Builder nextToken(String var1);

        public Builder nodes(Collection<DescribeNodeSummary> var1);

        public Builder nodes(DescribeNodeSummary ... var1);

        public Builder nodes(Consumer<DescribeNodeSummary.Builder> ... var1);
    }
}

