/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.medialive.MediaLiveClient;
import software.amazon.awssdk.services.medialive.internal.UserAgentUtils;
import software.amazon.awssdk.services.medialive.model.EventBridgeRuleTemplateGroupSummary;
import software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplateGroupsRequest;
import software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplateGroupsResponse;

public class ListEventBridgeRuleTemplateGroupsIterable
implements SdkIterable<ListEventBridgeRuleTemplateGroupsResponse> {
    private final MediaLiveClient client;
    private final ListEventBridgeRuleTemplateGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEventBridgeRuleTemplateGroupsIterable(MediaLiveClient client, ListEventBridgeRuleTemplateGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListEventBridgeRuleTemplateGroupsResponseFetcher();
    }

    public Iterator<ListEventBridgeRuleTemplateGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EventBridgeRuleTemplateGroupSummary> eventBridgeRuleTemplateGroups() {
        Function<ListEventBridgeRuleTemplateGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.eventBridgeRuleTemplateGroups() != null) {
                return response.eventBridgeRuleTemplateGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEventBridgeRuleTemplateGroupsResponseFetcher
    implements SyncPageFetcher<ListEventBridgeRuleTemplateGroupsResponse> {
        private ListEventBridgeRuleTemplateGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListEventBridgeRuleTemplateGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEventBridgeRuleTemplateGroupsResponse nextPage(ListEventBridgeRuleTemplateGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListEventBridgeRuleTemplateGroupsIterable.this.client.listEventBridgeRuleTemplateGroups(ListEventBridgeRuleTemplateGroupsIterable.this.firstRequest);
            }
            return ListEventBridgeRuleTemplateGroupsIterable.this.client.listEventBridgeRuleTemplateGroups((ListEventBridgeRuleTemplateGroupsRequest)((Object)ListEventBridgeRuleTemplateGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

