/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.ArchiveOutputSettings;
import software.amazon.awssdk.services.medialive.model.CmafIngestOutputSettings;
import software.amazon.awssdk.services.medialive.model.FrameCaptureOutputSettings;
import software.amazon.awssdk.services.medialive.model.HlsOutputSettings;
import software.amazon.awssdk.services.medialive.model.MediaPackageOutputSettings;
import software.amazon.awssdk.services.medialive.model.MsSmoothOutputSettings;
import software.amazon.awssdk.services.medialive.model.MultiplexOutputSettings;
import software.amazon.awssdk.services.medialive.model.RtmpOutputSettings;
import software.amazon.awssdk.services.medialive.model.UdpOutputSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OutputSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OutputSettings> {
    private static final SdkField<ArchiveOutputSettings> ARCHIVE_OUTPUT_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ArchiveOutputSettings").getter(OutputSettings.getter(OutputSettings::archiveOutputSettings)).setter(OutputSettings.setter(Builder::archiveOutputSettings)).constructor(ArchiveOutputSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("archiveOutputSettings").build()}).build();
    private static final SdkField<FrameCaptureOutputSettings> FRAME_CAPTURE_OUTPUT_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FrameCaptureOutputSettings").getter(OutputSettings.getter(OutputSettings::frameCaptureOutputSettings)).setter(OutputSettings.setter(Builder::frameCaptureOutputSettings)).constructor(FrameCaptureOutputSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frameCaptureOutputSettings").build()}).build();
    private static final SdkField<HlsOutputSettings> HLS_OUTPUT_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HlsOutputSettings").getter(OutputSettings.getter(OutputSettings::hlsOutputSettings)).setter(OutputSettings.setter(Builder::hlsOutputSettings)).constructor(HlsOutputSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hlsOutputSettings").build()}).build();
    private static final SdkField<MediaPackageOutputSettings> MEDIA_PACKAGE_OUTPUT_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MediaPackageOutputSettings").getter(OutputSettings.getter(OutputSettings::mediaPackageOutputSettings)).setter(OutputSettings.setter(Builder::mediaPackageOutputSettings)).constructor(MediaPackageOutputSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaPackageOutputSettings").build()}).build();
    private static final SdkField<MsSmoothOutputSettings> MS_SMOOTH_OUTPUT_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MsSmoothOutputSettings").getter(OutputSettings.getter(OutputSettings::msSmoothOutputSettings)).setter(OutputSettings.setter(Builder::msSmoothOutputSettings)).constructor(MsSmoothOutputSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("msSmoothOutputSettings").build()}).build();
    private static final SdkField<MultiplexOutputSettings> MULTIPLEX_OUTPUT_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MultiplexOutputSettings").getter(OutputSettings.getter(OutputSettings::multiplexOutputSettings)).setter(OutputSettings.setter(Builder::multiplexOutputSettings)).constructor(MultiplexOutputSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiplexOutputSettings").build()}).build();
    private static final SdkField<RtmpOutputSettings> RTMP_OUTPUT_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RtmpOutputSettings").getter(OutputSettings.getter(OutputSettings::rtmpOutputSettings)).setter(OutputSettings.setter(Builder::rtmpOutputSettings)).constructor(RtmpOutputSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rtmpOutputSettings").build()}).build();
    private static final SdkField<UdpOutputSettings> UDP_OUTPUT_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UdpOutputSettings").getter(OutputSettings.getter(OutputSettings::udpOutputSettings)).setter(OutputSettings.setter(Builder::udpOutputSettings)).constructor(UdpOutputSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("udpOutputSettings").build()}).build();
    private static final SdkField<CmafIngestOutputSettings> CMAF_INGEST_OUTPUT_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CmafIngestOutputSettings").getter(OutputSettings.getter(OutputSettings::cmafIngestOutputSettings)).setter(OutputSettings.setter(Builder::cmafIngestOutputSettings)).constructor(CmafIngestOutputSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cmafIngestOutputSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHIVE_OUTPUT_SETTINGS_FIELD, FRAME_CAPTURE_OUTPUT_SETTINGS_FIELD, HLS_OUTPUT_SETTINGS_FIELD, MEDIA_PACKAGE_OUTPUT_SETTINGS_FIELD, MS_SMOOTH_OUTPUT_SETTINGS_FIELD, MULTIPLEX_OUTPUT_SETTINGS_FIELD, RTMP_OUTPUT_SETTINGS_FIELD, UDP_OUTPUT_SETTINGS_FIELD, CMAF_INGEST_OUTPUT_SETTINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final ArchiveOutputSettings archiveOutputSettings;
    private final FrameCaptureOutputSettings frameCaptureOutputSettings;
    private final HlsOutputSettings hlsOutputSettings;
    private final MediaPackageOutputSettings mediaPackageOutputSettings;
    private final MsSmoothOutputSettings msSmoothOutputSettings;
    private final MultiplexOutputSettings multiplexOutputSettings;
    private final RtmpOutputSettings rtmpOutputSettings;
    private final UdpOutputSettings udpOutputSettings;
    private final CmafIngestOutputSettings cmafIngestOutputSettings;

    private OutputSettings(BuilderImpl builder) {
        this.archiveOutputSettings = builder.archiveOutputSettings;
        this.frameCaptureOutputSettings = builder.frameCaptureOutputSettings;
        this.hlsOutputSettings = builder.hlsOutputSettings;
        this.mediaPackageOutputSettings = builder.mediaPackageOutputSettings;
        this.msSmoothOutputSettings = builder.msSmoothOutputSettings;
        this.multiplexOutputSettings = builder.multiplexOutputSettings;
        this.rtmpOutputSettings = builder.rtmpOutputSettings;
        this.udpOutputSettings = builder.udpOutputSettings;
        this.cmafIngestOutputSettings = builder.cmafIngestOutputSettings;
    }

    public final ArchiveOutputSettings archiveOutputSettings() {
        return this.archiveOutputSettings;
    }

    public final FrameCaptureOutputSettings frameCaptureOutputSettings() {
        return this.frameCaptureOutputSettings;
    }

    public final HlsOutputSettings hlsOutputSettings() {
        return this.hlsOutputSettings;
    }

    public final MediaPackageOutputSettings mediaPackageOutputSettings() {
        return this.mediaPackageOutputSettings;
    }

    public final MsSmoothOutputSettings msSmoothOutputSettings() {
        return this.msSmoothOutputSettings;
    }

    public final MultiplexOutputSettings multiplexOutputSettings() {
        return this.multiplexOutputSettings;
    }

    public final RtmpOutputSettings rtmpOutputSettings() {
        return this.rtmpOutputSettings;
    }

    public final UdpOutputSettings udpOutputSettings() {
        return this.udpOutputSettings;
    }

    public final CmafIngestOutputSettings cmafIngestOutputSettings() {
        return this.cmafIngestOutputSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.archiveOutputSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.frameCaptureOutputSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hlsOutputSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaPackageOutputSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.msSmoothOutputSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiplexOutputSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.rtmpOutputSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.udpOutputSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.cmafIngestOutputSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputSettings)) {
            return false;
        }
        OutputSettings other = (OutputSettings)obj;
        return Objects.equals(this.archiveOutputSettings(), other.archiveOutputSettings()) && Objects.equals(this.frameCaptureOutputSettings(), other.frameCaptureOutputSettings()) && Objects.equals(this.hlsOutputSettings(), other.hlsOutputSettings()) && Objects.equals(this.mediaPackageOutputSettings(), other.mediaPackageOutputSettings()) && Objects.equals(this.msSmoothOutputSettings(), other.msSmoothOutputSettings()) && Objects.equals(this.multiplexOutputSettings(), other.multiplexOutputSettings()) && Objects.equals(this.rtmpOutputSettings(), other.rtmpOutputSettings()) && Objects.equals(this.udpOutputSettings(), other.udpOutputSettings()) && Objects.equals(this.cmafIngestOutputSettings(), other.cmafIngestOutputSettings());
    }

    public final String toString() {
        return ToString.builder((String)"OutputSettings").add("ArchiveOutputSettings", (Object)this.archiveOutputSettings()).add("FrameCaptureOutputSettings", (Object)this.frameCaptureOutputSettings()).add("HlsOutputSettings", (Object)this.hlsOutputSettings()).add("MediaPackageOutputSettings", (Object)this.mediaPackageOutputSettings()).add("MsSmoothOutputSettings", (Object)this.msSmoothOutputSettings()).add("MultiplexOutputSettings", (Object)this.multiplexOutputSettings()).add("RtmpOutputSettings", (Object)this.rtmpOutputSettings()).add("UdpOutputSettings", (Object)this.udpOutputSettings()).add("CmafIngestOutputSettings", (Object)this.cmafIngestOutputSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ArchiveOutputSettings": {
                return Optional.ofNullable(clazz.cast(this.archiveOutputSettings()));
            }
            case "FrameCaptureOutputSettings": {
                return Optional.ofNullable(clazz.cast(this.frameCaptureOutputSettings()));
            }
            case "HlsOutputSettings": {
                return Optional.ofNullable(clazz.cast(this.hlsOutputSettings()));
            }
            case "MediaPackageOutputSettings": {
                return Optional.ofNullable(clazz.cast(this.mediaPackageOutputSettings()));
            }
            case "MsSmoothOutputSettings": {
                return Optional.ofNullable(clazz.cast(this.msSmoothOutputSettings()));
            }
            case "MultiplexOutputSettings": {
                return Optional.ofNullable(clazz.cast(this.multiplexOutputSettings()));
            }
            case "RtmpOutputSettings": {
                return Optional.ofNullable(clazz.cast(this.rtmpOutputSettings()));
            }
            case "UdpOutputSettings": {
                return Optional.ofNullable(clazz.cast(this.udpOutputSettings()));
            }
            case "CmafIngestOutputSettings": {
                return Optional.ofNullable(clazz.cast(this.cmafIngestOutputSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OutputSettings, T> g) {
        return obj -> g.apply((OutputSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ArchiveOutputSettings archiveOutputSettings;
        private FrameCaptureOutputSettings frameCaptureOutputSettings;
        private HlsOutputSettings hlsOutputSettings;
        private MediaPackageOutputSettings mediaPackageOutputSettings;
        private MsSmoothOutputSettings msSmoothOutputSettings;
        private MultiplexOutputSettings multiplexOutputSettings;
        private RtmpOutputSettings rtmpOutputSettings;
        private UdpOutputSettings udpOutputSettings;
        private CmafIngestOutputSettings cmafIngestOutputSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputSettings model) {
            this.archiveOutputSettings(model.archiveOutputSettings);
            this.frameCaptureOutputSettings(model.frameCaptureOutputSettings);
            this.hlsOutputSettings(model.hlsOutputSettings);
            this.mediaPackageOutputSettings(model.mediaPackageOutputSettings);
            this.msSmoothOutputSettings(model.msSmoothOutputSettings);
            this.multiplexOutputSettings(model.multiplexOutputSettings);
            this.rtmpOutputSettings(model.rtmpOutputSettings);
            this.udpOutputSettings(model.udpOutputSettings);
            this.cmafIngestOutputSettings(model.cmafIngestOutputSettings);
        }

        public final ArchiveOutputSettings.Builder getArchiveOutputSettings() {
            return this.archiveOutputSettings != null ? this.archiveOutputSettings.toBuilder() : null;
        }

        public final void setArchiveOutputSettings(ArchiveOutputSettings.BuilderImpl archiveOutputSettings) {
            this.archiveOutputSettings = archiveOutputSettings != null ? archiveOutputSettings.build() : null;
        }

        @Override
        public final Builder archiveOutputSettings(ArchiveOutputSettings archiveOutputSettings) {
            this.archiveOutputSettings = archiveOutputSettings;
            return this;
        }

        public final FrameCaptureOutputSettings.Builder getFrameCaptureOutputSettings() {
            return this.frameCaptureOutputSettings != null ? this.frameCaptureOutputSettings.toBuilder() : null;
        }

        public final void setFrameCaptureOutputSettings(FrameCaptureOutputSettings.BuilderImpl frameCaptureOutputSettings) {
            this.frameCaptureOutputSettings = frameCaptureOutputSettings != null ? frameCaptureOutputSettings.build() : null;
        }

        @Override
        public final Builder frameCaptureOutputSettings(FrameCaptureOutputSettings frameCaptureOutputSettings) {
            this.frameCaptureOutputSettings = frameCaptureOutputSettings;
            return this;
        }

        public final HlsOutputSettings.Builder getHlsOutputSettings() {
            return this.hlsOutputSettings != null ? this.hlsOutputSettings.toBuilder() : null;
        }

        public final void setHlsOutputSettings(HlsOutputSettings.BuilderImpl hlsOutputSettings) {
            this.hlsOutputSettings = hlsOutputSettings != null ? hlsOutputSettings.build() : null;
        }

        @Override
        public final Builder hlsOutputSettings(HlsOutputSettings hlsOutputSettings) {
            this.hlsOutputSettings = hlsOutputSettings;
            return this;
        }

        public final MediaPackageOutputSettings.Builder getMediaPackageOutputSettings() {
            return this.mediaPackageOutputSettings != null ? this.mediaPackageOutputSettings.toBuilder() : null;
        }

        public final void setMediaPackageOutputSettings(MediaPackageOutputSettings.BuilderImpl mediaPackageOutputSettings) {
            this.mediaPackageOutputSettings = mediaPackageOutputSettings != null ? mediaPackageOutputSettings.build() : null;
        }

        @Override
        public final Builder mediaPackageOutputSettings(MediaPackageOutputSettings mediaPackageOutputSettings) {
            this.mediaPackageOutputSettings = mediaPackageOutputSettings;
            return this;
        }

        public final MsSmoothOutputSettings.Builder getMsSmoothOutputSettings() {
            return this.msSmoothOutputSettings != null ? this.msSmoothOutputSettings.toBuilder() : null;
        }

        public final void setMsSmoothOutputSettings(MsSmoothOutputSettings.BuilderImpl msSmoothOutputSettings) {
            this.msSmoothOutputSettings = msSmoothOutputSettings != null ? msSmoothOutputSettings.build() : null;
        }

        @Override
        public final Builder msSmoothOutputSettings(MsSmoothOutputSettings msSmoothOutputSettings) {
            this.msSmoothOutputSettings = msSmoothOutputSettings;
            return this;
        }

        public final MultiplexOutputSettings.Builder getMultiplexOutputSettings() {
            return this.multiplexOutputSettings != null ? this.multiplexOutputSettings.toBuilder() : null;
        }

        public final void setMultiplexOutputSettings(MultiplexOutputSettings.BuilderImpl multiplexOutputSettings) {
            this.multiplexOutputSettings = multiplexOutputSettings != null ? multiplexOutputSettings.build() : null;
        }

        @Override
        public final Builder multiplexOutputSettings(MultiplexOutputSettings multiplexOutputSettings) {
            this.multiplexOutputSettings = multiplexOutputSettings;
            return this;
        }

        public final RtmpOutputSettings.Builder getRtmpOutputSettings() {
            return this.rtmpOutputSettings != null ? this.rtmpOutputSettings.toBuilder() : null;
        }

        public final void setRtmpOutputSettings(RtmpOutputSettings.BuilderImpl rtmpOutputSettings) {
            this.rtmpOutputSettings = rtmpOutputSettings != null ? rtmpOutputSettings.build() : null;
        }

        @Override
        public final Builder rtmpOutputSettings(RtmpOutputSettings rtmpOutputSettings) {
            this.rtmpOutputSettings = rtmpOutputSettings;
            return this;
        }

        public final UdpOutputSettings.Builder getUdpOutputSettings() {
            return this.udpOutputSettings != null ? this.udpOutputSettings.toBuilder() : null;
        }

        public final void setUdpOutputSettings(UdpOutputSettings.BuilderImpl udpOutputSettings) {
            this.udpOutputSettings = udpOutputSettings != null ? udpOutputSettings.build() : null;
        }

        @Override
        public final Builder udpOutputSettings(UdpOutputSettings udpOutputSettings) {
            this.udpOutputSettings = udpOutputSettings;
            return this;
        }

        public final CmafIngestOutputSettings.Builder getCmafIngestOutputSettings() {
            return this.cmafIngestOutputSettings != null ? this.cmafIngestOutputSettings.toBuilder() : null;
        }

        public final void setCmafIngestOutputSettings(CmafIngestOutputSettings.BuilderImpl cmafIngestOutputSettings) {
            this.cmafIngestOutputSettings = cmafIngestOutputSettings != null ? cmafIngestOutputSettings.build() : null;
        }

        @Override
        public final Builder cmafIngestOutputSettings(CmafIngestOutputSettings cmafIngestOutputSettings) {
            this.cmafIngestOutputSettings = cmafIngestOutputSettings;
            return this;
        }

        public OutputSettings build() {
            return new OutputSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OutputSettings> {
        public Builder archiveOutputSettings(ArchiveOutputSettings var1);

        default public Builder archiveOutputSettings(Consumer<ArchiveOutputSettings.Builder> archiveOutputSettings) {
            return this.archiveOutputSettings((ArchiveOutputSettings)((ArchiveOutputSettings.Builder)ArchiveOutputSettings.builder().applyMutation(archiveOutputSettings)).build());
        }

        public Builder frameCaptureOutputSettings(FrameCaptureOutputSettings var1);

        default public Builder frameCaptureOutputSettings(Consumer<FrameCaptureOutputSettings.Builder> frameCaptureOutputSettings) {
            return this.frameCaptureOutputSettings((FrameCaptureOutputSettings)((FrameCaptureOutputSettings.Builder)FrameCaptureOutputSettings.builder().applyMutation(frameCaptureOutputSettings)).build());
        }

        public Builder hlsOutputSettings(HlsOutputSettings var1);

        default public Builder hlsOutputSettings(Consumer<HlsOutputSettings.Builder> hlsOutputSettings) {
            return this.hlsOutputSettings((HlsOutputSettings)((HlsOutputSettings.Builder)HlsOutputSettings.builder().applyMutation(hlsOutputSettings)).build());
        }

        public Builder mediaPackageOutputSettings(MediaPackageOutputSettings var1);

        default public Builder mediaPackageOutputSettings(Consumer<MediaPackageOutputSettings.Builder> mediaPackageOutputSettings) {
            return this.mediaPackageOutputSettings((MediaPackageOutputSettings)((MediaPackageOutputSettings.Builder)MediaPackageOutputSettings.builder().applyMutation(mediaPackageOutputSettings)).build());
        }

        public Builder msSmoothOutputSettings(MsSmoothOutputSettings var1);

        default public Builder msSmoothOutputSettings(Consumer<MsSmoothOutputSettings.Builder> msSmoothOutputSettings) {
            return this.msSmoothOutputSettings((MsSmoothOutputSettings)((MsSmoothOutputSettings.Builder)MsSmoothOutputSettings.builder().applyMutation(msSmoothOutputSettings)).build());
        }

        public Builder multiplexOutputSettings(MultiplexOutputSettings var1);

        default public Builder multiplexOutputSettings(Consumer<MultiplexOutputSettings.Builder> multiplexOutputSettings) {
            return this.multiplexOutputSettings((MultiplexOutputSettings)((MultiplexOutputSettings.Builder)MultiplexOutputSettings.builder().applyMutation(multiplexOutputSettings)).build());
        }

        public Builder rtmpOutputSettings(RtmpOutputSettings var1);

        default public Builder rtmpOutputSettings(Consumer<RtmpOutputSettings.Builder> rtmpOutputSettings) {
            return this.rtmpOutputSettings((RtmpOutputSettings)((RtmpOutputSettings.Builder)RtmpOutputSettings.builder().applyMutation(rtmpOutputSettings)).build());
        }

        public Builder udpOutputSettings(UdpOutputSettings var1);

        default public Builder udpOutputSettings(Consumer<UdpOutputSettings.Builder> udpOutputSettings) {
            return this.udpOutputSettings((UdpOutputSettings)((UdpOutputSettings.Builder)UdpOutputSettings.builder().applyMutation(udpOutputSettings)).build());
        }

        public Builder cmafIngestOutputSettings(CmafIngestOutputSettings var1);

        default public Builder cmafIngestOutputSettings(Consumer<CmafIngestOutputSettings.Builder> cmafIngestOutputSettings) {
            return this.cmafIngestOutputSettings((CmafIngestOutputSettings)((CmafIngestOutputSettings.Builder)CmafIngestOutputSettings.builder().applyMutation(cmafIngestOutputSettings)).build());
        }
    }
}

