/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.medialive.MediaLiveClient;
import software.amazon.awssdk.services.medialive.internal.UserAgentUtils;
import software.amazon.awssdk.services.medialive.model.ListReservationsRequest;
import software.amazon.awssdk.services.medialive.model.ListReservationsResponse;
import software.amazon.awssdk.services.medialive.model.Reservation;

public class ListReservationsIterable
implements SdkIterable<ListReservationsResponse> {
    private final MediaLiveClient client;
    private final ListReservationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListReservationsIterable(MediaLiveClient client, ListReservationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListReservationsResponseFetcher();
    }

    public Iterator<ListReservationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Reservation> reservations() {
        Function<ListReservationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.reservations() != null) {
                return response.reservations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListReservationsResponseFetcher
    implements SyncPageFetcher<ListReservationsResponse> {
        private ListReservationsResponseFetcher() {
        }

        public boolean hasNextPage(ListReservationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListReservationsResponse nextPage(ListReservationsResponse previousPage) {
            if (previousPage == null) {
                return ListReservationsIterable.this.client.listReservations(ListReservationsIterable.this.firstRequest);
            }
            return ListReservationsIterable.this.client.listReservations((ListReservationsRequest)((Object)ListReservationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

