/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.medialive.DefaultMediaLiveBaseClientBuilder;
import software.amazon.awssdk.services.medialive.DefaultMediaLiveClient;
import software.amazon.awssdk.services.medialive.MediaLiveClient;
import software.amazon.awssdk.services.medialive.MediaLiveClientBuilder;
import software.amazon.awssdk.services.medialive.MediaLiveServiceClientConfiguration;
import software.amazon.awssdk.services.medialive.endpoints.MediaLiveEndpointProvider;

@SdkInternalApi
final class DefaultMediaLiveClientBuilder
extends DefaultMediaLiveBaseClientBuilder<MediaLiveClientBuilder, MediaLiveClient>
implements MediaLiveClientBuilder {
    DefaultMediaLiveClientBuilder() {
    }

    @Override
    public DefaultMediaLiveClientBuilder endpointProvider(MediaLiveEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final MediaLiveClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultMediaLiveClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        MediaLiveServiceClientConfiguration serviceClientConfiguration = MediaLiveServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultMediaLiveClient(serviceClientConfiguration, clientConfiguration);
    }
}

