/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TimecodeConfigSource {
    EMBEDDED("EMBEDDED"),
    SYSTEMCLOCK("SYSTEMCLOCK"),
    ZEROBASED("ZEROBASED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TimecodeConfigSource> VALUE_MAP;
    private final String value;

    private TimecodeConfigSource(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TimecodeConfigSource fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TimecodeConfigSource> knownValues() {
        EnumSet<TimecodeConfigSource> knownValues = EnumSet.allOf(TimecodeConfigSource.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TimecodeConfigSource.class, TimecodeConfigSource::toString);
    }
}

