/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.MediaLiveRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeThumbnailsRequest
extends MediaLiveRequest
implements ToCopyableBuilder<Builder, DescribeThumbnailsRequest> {
    private static final SdkField<String> CHANNEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelId").getter(DescribeThumbnailsRequest.getter(DescribeThumbnailsRequest::channelId)).setter(DescribeThumbnailsRequest.setter(Builder::channelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("channelId").build()}).build();
    private static final SdkField<String> PIPELINE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PipelineId").getter(DescribeThumbnailsRequest.getter(DescribeThumbnailsRequest::pipelineId)).setter(DescribeThumbnailsRequest.setter(Builder::pipelineId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("pipelineId").build()}).build();
    private static final SdkField<String> THUMBNAIL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ThumbnailType").getter(DescribeThumbnailsRequest.getter(DescribeThumbnailsRequest::thumbnailType)).setter(DescribeThumbnailsRequest.setter(Builder::thumbnailType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("thumbnailType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ID_FIELD, PIPELINE_ID_FIELD, THUMBNAIL_TYPE_FIELD));
    private final String channelId;
    private final String pipelineId;
    private final String thumbnailType;

    private DescribeThumbnailsRequest(BuilderImpl builder) {
        super(builder);
        this.channelId = builder.channelId;
        this.pipelineId = builder.pipelineId;
        this.thumbnailType = builder.thumbnailType;
    }

    public final String channelId() {
        return this.channelId;
    }

    public final String pipelineId() {
        return this.pipelineId;
    }

    public final String thumbnailType() {
        return this.thumbnailType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineId());
        hashCode = 31 * hashCode + Objects.hashCode(this.thumbnailType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeThumbnailsRequest)) {
            return false;
        }
        DescribeThumbnailsRequest other = (DescribeThumbnailsRequest)((Object)obj);
        return Objects.equals(this.channelId(), other.channelId()) && Objects.equals(this.pipelineId(), other.pipelineId()) && Objects.equals(this.thumbnailType(), other.thumbnailType());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeThumbnailsRequest").add("ChannelId", (Object)this.channelId()).add("PipelineId", (Object)this.pipelineId()).add("ThumbnailType", (Object)this.thumbnailType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelId": {
                return Optional.ofNullable(clazz.cast(this.channelId()));
            }
            case "PipelineId": {
                return Optional.ofNullable(clazz.cast(this.pipelineId()));
            }
            case "ThumbnailType": {
                return Optional.ofNullable(clazz.cast(this.thumbnailType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeThumbnailsRequest, T> g) {
        return obj -> g.apply((DescribeThumbnailsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveRequest.BuilderImpl
    implements Builder {
        private String channelId;
        private String pipelineId;
        private String thumbnailType;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeThumbnailsRequest model) {
            super(model);
            this.channelId(model.channelId);
            this.pipelineId(model.pipelineId);
            this.thumbnailType(model.thumbnailType);
        }

        public final String getChannelId() {
            return this.channelId;
        }

        public final void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @Override
        public final Builder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public final String getPipelineId() {
            return this.pipelineId;
        }

        public final void setPipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
        }

        @Override
        public final Builder pipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
            return this;
        }

        public final String getThumbnailType() {
            return this.thumbnailType;
        }

        public final void setThumbnailType(String thumbnailType) {
            this.thumbnailType = thumbnailType;
        }

        @Override
        public final Builder thumbnailType(String thumbnailType) {
            this.thumbnailType = thumbnailType;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeThumbnailsRequest build() {
            return new DescribeThumbnailsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaLiveRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeThumbnailsRequest> {
        public Builder channelId(String var1);

        public Builder pipelineId(String var1);

        public Builder thumbnailType(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

