/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.Ac3BitstreamMode;
import software.amazon.awssdk.services.medialive.model.Ac3CodingMode;
import software.amazon.awssdk.services.medialive.model.Ac3DrcProfile;
import software.amazon.awssdk.services.medialive.model.Ac3LfeFilter;
import software.amazon.awssdk.services.medialive.model.Ac3MetadataControl;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Ac3Settings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Ac3Settings> {
    private static final SdkField<Double> BITRATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Bitrate").getter(Ac3Settings.getter(Ac3Settings::bitrate)).setter(Ac3Settings.setter(Builder::bitrate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitrate").build()}).build();
    private static final SdkField<String> BITSTREAM_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BitstreamMode").getter(Ac3Settings.getter(Ac3Settings::bitstreamModeAsString)).setter(Ac3Settings.setter(Builder::bitstreamMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitstreamMode").build()}).build();
    private static final SdkField<String> CODING_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CodingMode").getter(Ac3Settings.getter(Ac3Settings::codingModeAsString)).setter(Ac3Settings.setter(Builder::codingMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codingMode").build()}).build();
    private static final SdkField<Integer> DIALNORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Dialnorm").getter(Ac3Settings.getter(Ac3Settings::dialnorm)).setter(Ac3Settings.setter(Builder::dialnorm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dialnorm").build()}).build();
    private static final SdkField<String> DRC_PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DrcProfile").getter(Ac3Settings.getter(Ac3Settings::drcProfileAsString)).setter(Ac3Settings.setter(Builder::drcProfile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("drcProfile").build()}).build();
    private static final SdkField<String> LFE_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LfeFilter").getter(Ac3Settings.getter(Ac3Settings::lfeFilterAsString)).setter(Ac3Settings.setter(Builder::lfeFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lfeFilter").build()}).build();
    private static final SdkField<String> METADATA_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetadataControl").getter(Ac3Settings.getter(Ac3Settings::metadataControlAsString)).setter(Ac3Settings.setter(Builder::metadataControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadataControl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BITRATE_FIELD, BITSTREAM_MODE_FIELD, CODING_MODE_FIELD, DIALNORM_FIELD, DRC_PROFILE_FIELD, LFE_FILTER_FIELD, METADATA_CONTROL_FIELD));
    private static final long serialVersionUID = 1L;
    private final Double bitrate;
    private final String bitstreamMode;
    private final String codingMode;
    private final Integer dialnorm;
    private final String drcProfile;
    private final String lfeFilter;
    private final String metadataControl;

    private Ac3Settings(BuilderImpl builder) {
        this.bitrate = builder.bitrate;
        this.bitstreamMode = builder.bitstreamMode;
        this.codingMode = builder.codingMode;
        this.dialnorm = builder.dialnorm;
        this.drcProfile = builder.drcProfile;
        this.lfeFilter = builder.lfeFilter;
        this.metadataControl = builder.metadataControl;
    }

    public final Double bitrate() {
        return this.bitrate;
    }

    public final Ac3BitstreamMode bitstreamMode() {
        return Ac3BitstreamMode.fromValue(this.bitstreamMode);
    }

    public final String bitstreamModeAsString() {
        return this.bitstreamMode;
    }

    public final Ac3CodingMode codingMode() {
        return Ac3CodingMode.fromValue(this.codingMode);
    }

    public final String codingModeAsString() {
        return this.codingMode;
    }

    public final Integer dialnorm() {
        return this.dialnorm;
    }

    public final Ac3DrcProfile drcProfile() {
        return Ac3DrcProfile.fromValue(this.drcProfile);
    }

    public final String drcProfileAsString() {
        return this.drcProfile;
    }

    public final Ac3LfeFilter lfeFilter() {
        return Ac3LfeFilter.fromValue(this.lfeFilter);
    }

    public final String lfeFilterAsString() {
        return this.lfeFilter;
    }

    public final Ac3MetadataControl metadataControl() {
        return Ac3MetadataControl.fromValue(this.metadataControl);
    }

    public final String metadataControlAsString() {
        return this.metadataControl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.bitstreamModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.codingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dialnorm());
        hashCode = 31 * hashCode + Objects.hashCode(this.drcProfileAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lfeFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataControlAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ac3Settings)) {
            return false;
        }
        Ac3Settings other = (Ac3Settings)obj;
        return Objects.equals(this.bitrate(), other.bitrate()) && Objects.equals(this.bitstreamModeAsString(), other.bitstreamModeAsString()) && Objects.equals(this.codingModeAsString(), other.codingModeAsString()) && Objects.equals(this.dialnorm(), other.dialnorm()) && Objects.equals(this.drcProfileAsString(), other.drcProfileAsString()) && Objects.equals(this.lfeFilterAsString(), other.lfeFilterAsString()) && Objects.equals(this.metadataControlAsString(), other.metadataControlAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Ac3Settings").add("Bitrate", (Object)this.bitrate()).add("BitstreamMode", (Object)this.bitstreamModeAsString()).add("CodingMode", (Object)this.codingModeAsString()).add("Dialnorm", (Object)this.dialnorm()).add("DrcProfile", (Object)this.drcProfileAsString()).add("LfeFilter", (Object)this.lfeFilterAsString()).add("MetadataControl", (Object)this.metadataControlAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bitrate": {
                return Optional.ofNullable(clazz.cast(this.bitrate()));
            }
            case "BitstreamMode": {
                return Optional.ofNullable(clazz.cast(this.bitstreamModeAsString()));
            }
            case "CodingMode": {
                return Optional.ofNullable(clazz.cast(this.codingModeAsString()));
            }
            case "Dialnorm": {
                return Optional.ofNullable(clazz.cast(this.dialnorm()));
            }
            case "DrcProfile": {
                return Optional.ofNullable(clazz.cast(this.drcProfileAsString()));
            }
            case "LfeFilter": {
                return Optional.ofNullable(clazz.cast(this.lfeFilterAsString()));
            }
            case "MetadataControl": {
                return Optional.ofNullable(clazz.cast(this.metadataControlAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Ac3Settings, T> g) {
        return obj -> g.apply((Ac3Settings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double bitrate;
        private String bitstreamMode;
        private String codingMode;
        private Integer dialnorm;
        private String drcProfile;
        private String lfeFilter;
        private String metadataControl;

        private BuilderImpl() {
        }

        private BuilderImpl(Ac3Settings model) {
            this.bitrate(model.bitrate);
            this.bitstreamMode(model.bitstreamMode);
            this.codingMode(model.codingMode);
            this.dialnorm(model.dialnorm);
            this.drcProfile(model.drcProfile);
            this.lfeFilter(model.lfeFilter);
            this.metadataControl(model.metadataControl);
        }

        public final Double getBitrate() {
            return this.bitrate;
        }

        public final void setBitrate(Double bitrate) {
            this.bitrate = bitrate;
        }

        @Override
        public final Builder bitrate(Double bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        public final String getBitstreamMode() {
            return this.bitstreamMode;
        }

        public final void setBitstreamMode(String bitstreamMode) {
            this.bitstreamMode = bitstreamMode;
        }

        @Override
        public final Builder bitstreamMode(String bitstreamMode) {
            this.bitstreamMode = bitstreamMode;
            return this;
        }

        @Override
        public final Builder bitstreamMode(Ac3BitstreamMode bitstreamMode) {
            this.bitstreamMode(bitstreamMode == null ? null : bitstreamMode.toString());
            return this;
        }

        public final String getCodingMode() {
            return this.codingMode;
        }

        public final void setCodingMode(String codingMode) {
            this.codingMode = codingMode;
        }

        @Override
        public final Builder codingMode(String codingMode) {
            this.codingMode = codingMode;
            return this;
        }

        @Override
        public final Builder codingMode(Ac3CodingMode codingMode) {
            this.codingMode(codingMode == null ? null : codingMode.toString());
            return this;
        }

        public final Integer getDialnorm() {
            return this.dialnorm;
        }

        public final void setDialnorm(Integer dialnorm) {
            this.dialnorm = dialnorm;
        }

        @Override
        public final Builder dialnorm(Integer dialnorm) {
            this.dialnorm = dialnorm;
            return this;
        }

        public final String getDrcProfile() {
            return this.drcProfile;
        }

        public final void setDrcProfile(String drcProfile) {
            this.drcProfile = drcProfile;
        }

        @Override
        public final Builder drcProfile(String drcProfile) {
            this.drcProfile = drcProfile;
            return this;
        }

        @Override
        public final Builder drcProfile(Ac3DrcProfile drcProfile) {
            this.drcProfile(drcProfile == null ? null : drcProfile.toString());
            return this;
        }

        public final String getLfeFilter() {
            return this.lfeFilter;
        }

        public final void setLfeFilter(String lfeFilter) {
            this.lfeFilter = lfeFilter;
        }

        @Override
        public final Builder lfeFilter(String lfeFilter) {
            this.lfeFilter = lfeFilter;
            return this;
        }

        @Override
        public final Builder lfeFilter(Ac3LfeFilter lfeFilter) {
            this.lfeFilter(lfeFilter == null ? null : lfeFilter.toString());
            return this;
        }

        public final String getMetadataControl() {
            return this.metadataControl;
        }

        public final void setMetadataControl(String metadataControl) {
            this.metadataControl = metadataControl;
        }

        @Override
        public final Builder metadataControl(String metadataControl) {
            this.metadataControl = metadataControl;
            return this;
        }

        @Override
        public final Builder metadataControl(Ac3MetadataControl metadataControl) {
            this.metadataControl(metadataControl == null ? null : metadataControl.toString());
            return this;
        }

        public Ac3Settings build() {
            return new Ac3Settings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Ac3Settings> {
        public Builder bitrate(Double var1);

        public Builder bitstreamMode(String var1);

        public Builder bitstreamMode(Ac3BitstreamMode var1);

        public Builder codingMode(String var1);

        public Builder codingMode(Ac3CodingMode var1);

        public Builder dialnorm(Integer var1);

        public Builder drcProfile(String var1);

        public Builder drcProfile(Ac3DrcProfile var1);

        public Builder lfeFilter(String var1);

        public Builder lfeFilter(Ac3LfeFilter var1);

        public Builder metadataControl(String var1);

        public Builder metadataControl(Ac3MetadataControl var1);
    }
}

