/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.InputDeviceSummary;
import software.amazon.awssdk.services.medialive.model.MediaLiveResponse;
import software.amazon.awssdk.services.medialive.model.___listOfInputDeviceSummaryCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListInputDevicesResponse
extends MediaLiveResponse
implements ToCopyableBuilder<Builder, ListInputDevicesResponse> {
    private static final SdkField<List<InputDeviceSummary>> INPUT_DEVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InputDevices").getter(ListInputDevicesResponse.getter(ListInputDevicesResponse::inputDevices)).setter(ListInputDevicesResponse.setter(Builder::inputDevices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputDevices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputDeviceSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListInputDevicesResponse.getter(ListInputDevicesResponse::nextToken)).setter(ListInputDevicesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_DEVICES_FIELD, NEXT_TOKEN_FIELD));
    private final List<InputDeviceSummary> inputDevices;
    private final String nextToken;

    private ListInputDevicesResponse(BuilderImpl builder) {
        super(builder);
        this.inputDevices = builder.inputDevices;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasInputDevices() {
        return this.inputDevices != null && !(this.inputDevices instanceof SdkAutoConstructList);
    }

    public final List<InputDeviceSummary> inputDevices() {
        return this.inputDevices;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputDevices() ? this.inputDevices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInputDevicesResponse)) {
            return false;
        }
        ListInputDevicesResponse other = (ListInputDevicesResponse)((Object)obj);
        return this.hasInputDevices() == other.hasInputDevices() && Objects.equals(this.inputDevices(), other.inputDevices()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListInputDevicesResponse").add("InputDevices", this.hasInputDevices() ? this.inputDevices() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InputDevices": {
                return Optional.ofNullable(clazz.cast(this.inputDevices()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListInputDevicesResponse, T> g) {
        return obj -> g.apply((ListInputDevicesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveResponse.BuilderImpl
    implements Builder {
        private List<InputDeviceSummary> inputDevices = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInputDevicesResponse model) {
            super(model);
            this.inputDevices(model.inputDevices);
            this.nextToken(model.nextToken);
        }

        public final List<InputDeviceSummary.Builder> getInputDevices() {
            List<InputDeviceSummary.Builder> result = ___listOfInputDeviceSummaryCopier.copyToBuilder(this.inputDevices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputDevices(Collection<InputDeviceSummary.BuilderImpl> inputDevices) {
            this.inputDevices = ___listOfInputDeviceSummaryCopier.copyFromBuilder(inputDevices);
        }

        @Override
        public final Builder inputDevices(Collection<InputDeviceSummary> inputDevices) {
            this.inputDevices = ___listOfInputDeviceSummaryCopier.copy(inputDevices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDevices(InputDeviceSummary ... inputDevices) {
            this.inputDevices(Arrays.asList(inputDevices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDevices(Consumer<InputDeviceSummary.Builder> ... inputDevices) {
            this.inputDevices(Stream.of(inputDevices).map(c -> (InputDeviceSummary)((InputDeviceSummary.Builder)InputDeviceSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListInputDevicesResponse build() {
            return new ListInputDevicesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaLiveResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListInputDevicesResponse> {
        public Builder inputDevices(Collection<InputDeviceSummary> var1);

        public Builder inputDevices(InputDeviceSummary ... var1);

        public Builder inputDevices(Consumer<InputDeviceSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

