/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ChannelState {
    CREATING("CREATING"),
    CREATE_FAILED("CREATE_FAILED"),
    IDLE("IDLE"),
    STARTING("STARTING"),
    RUNNING("RUNNING"),
    RECOVERING("RECOVERING"),
    STOPPING("STOPPING"),
    DELETING("DELETING"),
    DELETED("DELETED"),
    UPDATING("UPDATING"),
    UPDATE_FAILED("UPDATE_FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ChannelState> VALUE_MAP;
    private final String value;

    private ChannelState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ChannelState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ChannelState> knownValues() {
        EnumSet<ChannelState> knownValues = EnumSet.allOf(ChannelState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ChannelState.class, ChannelState::toString);
    }
}

