/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.HlsAkamaiHttpTransferMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HlsAkamaiSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HlsAkamaiSettings> {
    private static final SdkField<Integer> CONNECTION_RETRY_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ConnectionRetryInterval").getter(HlsAkamaiSettings.getter(HlsAkamaiSettings::connectionRetryInterval)).setter(HlsAkamaiSettings.setter(Builder::connectionRetryInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionRetryInterval").build()}).build();
    private static final SdkField<Integer> FILECACHE_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FilecacheDuration").getter(HlsAkamaiSettings.getter(HlsAkamaiSettings::filecacheDuration)).setter(HlsAkamaiSettings.setter(Builder::filecacheDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filecacheDuration").build()}).build();
    private static final SdkField<String> HTTP_TRANSFER_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HttpTransferMode").getter(HlsAkamaiSettings.getter(HlsAkamaiSettings::httpTransferModeAsString)).setter(HlsAkamaiSettings.setter(Builder::httpTransferMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpTransferMode").build()}).build();
    private static final SdkField<Integer> NUM_RETRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumRetries").getter(HlsAkamaiSettings.getter(HlsAkamaiSettings::numRetries)).setter(HlsAkamaiSettings.setter(Builder::numRetries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numRetries").build()}).build();
    private static final SdkField<Integer> RESTART_DELAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RestartDelay").getter(HlsAkamaiSettings.getter(HlsAkamaiSettings::restartDelay)).setter(HlsAkamaiSettings.setter(Builder::restartDelay)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("restartDelay").build()}).build();
    private static final SdkField<String> SALT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Salt").getter(HlsAkamaiSettings.getter(HlsAkamaiSettings::salt)).setter(HlsAkamaiSettings.setter(Builder::salt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("salt").build()}).build();
    private static final SdkField<String> TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Token").getter(HlsAkamaiSettings.getter(HlsAkamaiSettings::token)).setter(HlsAkamaiSettings.setter(Builder::token)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("token").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_RETRY_INTERVAL_FIELD, FILECACHE_DURATION_FIELD, HTTP_TRANSFER_MODE_FIELD, NUM_RETRIES_FIELD, RESTART_DELAY_FIELD, SALT_FIELD, TOKEN_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer connectionRetryInterval;
    private final Integer filecacheDuration;
    private final String httpTransferMode;
    private final Integer numRetries;
    private final Integer restartDelay;
    private final String salt;
    private final String token;

    private HlsAkamaiSettings(BuilderImpl builder) {
        this.connectionRetryInterval = builder.connectionRetryInterval;
        this.filecacheDuration = builder.filecacheDuration;
        this.httpTransferMode = builder.httpTransferMode;
        this.numRetries = builder.numRetries;
        this.restartDelay = builder.restartDelay;
        this.salt = builder.salt;
        this.token = builder.token;
    }

    public final Integer connectionRetryInterval() {
        return this.connectionRetryInterval;
    }

    public final Integer filecacheDuration() {
        return this.filecacheDuration;
    }

    public final HlsAkamaiHttpTransferMode httpTransferMode() {
        return HlsAkamaiHttpTransferMode.fromValue(this.httpTransferMode);
    }

    public final String httpTransferModeAsString() {
        return this.httpTransferMode;
    }

    public final Integer numRetries() {
        return this.numRetries;
    }

    public final Integer restartDelay() {
        return this.restartDelay;
    }

    public final String salt() {
        return this.salt;
    }

    public final String token() {
        return this.token;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionRetryInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.filecacheDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpTransferModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.numRetries());
        hashCode = 31 * hashCode + Objects.hashCode(this.restartDelay());
        hashCode = 31 * hashCode + Objects.hashCode(this.salt());
        hashCode = 31 * hashCode + Objects.hashCode(this.token());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsAkamaiSettings)) {
            return false;
        }
        HlsAkamaiSettings other = (HlsAkamaiSettings)obj;
        return Objects.equals(this.connectionRetryInterval(), other.connectionRetryInterval()) && Objects.equals(this.filecacheDuration(), other.filecacheDuration()) && Objects.equals(this.httpTransferModeAsString(), other.httpTransferModeAsString()) && Objects.equals(this.numRetries(), other.numRetries()) && Objects.equals(this.restartDelay(), other.restartDelay()) && Objects.equals(this.salt(), other.salt()) && Objects.equals(this.token(), other.token());
    }

    public final String toString() {
        return ToString.builder((String)"HlsAkamaiSettings").add("ConnectionRetryInterval", (Object)this.connectionRetryInterval()).add("FilecacheDuration", (Object)this.filecacheDuration()).add("HttpTransferMode", (Object)this.httpTransferModeAsString()).add("NumRetries", (Object)this.numRetries()).add("RestartDelay", (Object)this.restartDelay()).add("Salt", (Object)this.salt()).add("Token", (Object)this.token()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectionRetryInterval": {
                return Optional.ofNullable(clazz.cast(this.connectionRetryInterval()));
            }
            case "FilecacheDuration": {
                return Optional.ofNullable(clazz.cast(this.filecacheDuration()));
            }
            case "HttpTransferMode": {
                return Optional.ofNullable(clazz.cast(this.httpTransferModeAsString()));
            }
            case "NumRetries": {
                return Optional.ofNullable(clazz.cast(this.numRetries()));
            }
            case "RestartDelay": {
                return Optional.ofNullable(clazz.cast(this.restartDelay()));
            }
            case "Salt": {
                return Optional.ofNullable(clazz.cast(this.salt()));
            }
            case "Token": {
                return Optional.ofNullable(clazz.cast(this.token()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HlsAkamaiSettings, T> g) {
        return obj -> g.apply((HlsAkamaiSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer connectionRetryInterval;
        private Integer filecacheDuration;
        private String httpTransferMode;
        private Integer numRetries;
        private Integer restartDelay;
        private String salt;
        private String token;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsAkamaiSettings model) {
            this.connectionRetryInterval(model.connectionRetryInterval);
            this.filecacheDuration(model.filecacheDuration);
            this.httpTransferMode(model.httpTransferMode);
            this.numRetries(model.numRetries);
            this.restartDelay(model.restartDelay);
            this.salt(model.salt);
            this.token(model.token);
        }

        public final Integer getConnectionRetryInterval() {
            return this.connectionRetryInterval;
        }

        public final void setConnectionRetryInterval(Integer connectionRetryInterval) {
            this.connectionRetryInterval = connectionRetryInterval;
        }

        @Override
        @Transient
        public final Builder connectionRetryInterval(Integer connectionRetryInterval) {
            this.connectionRetryInterval = connectionRetryInterval;
            return this;
        }

        public final Integer getFilecacheDuration() {
            return this.filecacheDuration;
        }

        public final void setFilecacheDuration(Integer filecacheDuration) {
            this.filecacheDuration = filecacheDuration;
        }

        @Override
        @Transient
        public final Builder filecacheDuration(Integer filecacheDuration) {
            this.filecacheDuration = filecacheDuration;
            return this;
        }

        public final String getHttpTransferMode() {
            return this.httpTransferMode;
        }

        public final void setHttpTransferMode(String httpTransferMode) {
            this.httpTransferMode = httpTransferMode;
        }

        @Override
        @Transient
        public final Builder httpTransferMode(String httpTransferMode) {
            this.httpTransferMode = httpTransferMode;
            return this;
        }

        @Override
        @Transient
        public final Builder httpTransferMode(HlsAkamaiHttpTransferMode httpTransferMode) {
            this.httpTransferMode(httpTransferMode == null ? null : httpTransferMode.toString());
            return this;
        }

        public final Integer getNumRetries() {
            return this.numRetries;
        }

        public final void setNumRetries(Integer numRetries) {
            this.numRetries = numRetries;
        }

        @Override
        @Transient
        public final Builder numRetries(Integer numRetries) {
            this.numRetries = numRetries;
            return this;
        }

        public final Integer getRestartDelay() {
            return this.restartDelay;
        }

        public final void setRestartDelay(Integer restartDelay) {
            this.restartDelay = restartDelay;
        }

        @Override
        @Transient
        public final Builder restartDelay(Integer restartDelay) {
            this.restartDelay = restartDelay;
            return this;
        }

        public final String getSalt() {
            return this.salt;
        }

        public final void setSalt(String salt) {
            this.salt = salt;
        }

        @Override
        @Transient
        public final Builder salt(String salt) {
            this.salt = salt;
            return this;
        }

        public final String getToken() {
            return this.token;
        }

        public final void setToken(String token) {
            this.token = token;
        }

        @Override
        @Transient
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        public HlsAkamaiSettings build() {
            return new HlsAkamaiSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HlsAkamaiSettings> {
        public Builder connectionRetryInterval(Integer var1);

        public Builder filecacheDuration(Integer var1);

        public Builder httpTransferMode(String var1);

        public Builder httpTransferMode(HlsAkamaiHttpTransferMode var1);

        public Builder numRetries(Integer var1);

        public Builder restartDelay(Integer var1);

        public Builder salt(String var1);

        public Builder token(String var1);
    }
}

