/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.CaptionLanguageMapping;
import software.amazon.awssdk.services.medialive.model.HlsAdMarkers;
import software.amazon.awssdk.services.medialive.model.HlsCaptionLanguageSetting;
import software.amazon.awssdk.services.medialive.model.HlsCdnSettings;
import software.amazon.awssdk.services.medialive.model.HlsClientCache;
import software.amazon.awssdk.services.medialive.model.HlsCodecSpecification;
import software.amazon.awssdk.services.medialive.model.HlsDirectoryStructure;
import software.amazon.awssdk.services.medialive.model.HlsDiscontinuityTags;
import software.amazon.awssdk.services.medialive.model.HlsEncryptionType;
import software.amazon.awssdk.services.medialive.model.HlsId3SegmentTaggingState;
import software.amazon.awssdk.services.medialive.model.HlsIncompleteSegmentBehavior;
import software.amazon.awssdk.services.medialive.model.HlsIvInManifest;
import software.amazon.awssdk.services.medialive.model.HlsIvSource;
import software.amazon.awssdk.services.medialive.model.HlsManifestCompression;
import software.amazon.awssdk.services.medialive.model.HlsManifestDurationFormat;
import software.amazon.awssdk.services.medialive.model.HlsMode;
import software.amazon.awssdk.services.medialive.model.HlsOutputSelection;
import software.amazon.awssdk.services.medialive.model.HlsProgramDateTime;
import software.amazon.awssdk.services.medialive.model.HlsRedundantManifest;
import software.amazon.awssdk.services.medialive.model.HlsSegmentationMode;
import software.amazon.awssdk.services.medialive.model.HlsStreamInfResolution;
import software.amazon.awssdk.services.medialive.model.HlsTimedMetadataId3Frame;
import software.amazon.awssdk.services.medialive.model.HlsTsFileMode;
import software.amazon.awssdk.services.medialive.model.IFrameOnlyPlaylistType;
import software.amazon.awssdk.services.medialive.model.InputLossActionForHlsOut;
import software.amazon.awssdk.services.medialive.model.KeyProviderSettings;
import software.amazon.awssdk.services.medialive.model.OutputLocationRef;
import software.amazon.awssdk.services.medialive.model.___listOfCaptionLanguageMappingCopier;
import software.amazon.awssdk.services.medialive.model.___listOfHlsAdMarkersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HlsGroupSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HlsGroupSettings> {
    private static final SdkField<List<String>> AD_MARKERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdMarkers").getter(HlsGroupSettings.getter(HlsGroupSettings::adMarkersAsStrings)).setter(HlsGroupSettings.setter(Builder::adMarkersWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adMarkers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> BASE_URL_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BaseUrlContent").getter(HlsGroupSettings.getter(HlsGroupSettings::baseUrlContent)).setter(HlsGroupSettings.setter(Builder::baseUrlContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseUrlContent").build()}).build();
    private static final SdkField<String> BASE_URL_CONTENT1_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BaseUrlContent1").getter(HlsGroupSettings.getter(HlsGroupSettings::baseUrlContent1)).setter(HlsGroupSettings.setter(Builder::baseUrlContent1)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseUrlContent1").build()}).build();
    private static final SdkField<String> BASE_URL_MANIFEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BaseUrlManifest").getter(HlsGroupSettings.getter(HlsGroupSettings::baseUrlManifest)).setter(HlsGroupSettings.setter(Builder::baseUrlManifest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseUrlManifest").build()}).build();
    private static final SdkField<String> BASE_URL_MANIFEST1_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BaseUrlManifest1").getter(HlsGroupSettings.getter(HlsGroupSettings::baseUrlManifest1)).setter(HlsGroupSettings.setter(Builder::baseUrlManifest1)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseUrlManifest1").build()}).build();
    private static final SdkField<List<CaptionLanguageMapping>> CAPTION_LANGUAGE_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CaptionLanguageMappings").getter(HlsGroupSettings.getter(HlsGroupSettings::captionLanguageMappings)).setter(HlsGroupSettings.setter(Builder::captionLanguageMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captionLanguageMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CaptionLanguageMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CAPTION_LANGUAGE_SETTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CaptionLanguageSetting").getter(HlsGroupSettings.getter(HlsGroupSettings::captionLanguageSettingAsString)).setter(HlsGroupSettings.setter(Builder::captionLanguageSetting)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captionLanguageSetting").build()}).build();
    private static final SdkField<String> CLIENT_CACHE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientCache").getter(HlsGroupSettings.getter(HlsGroupSettings::clientCacheAsString)).setter(HlsGroupSettings.setter(Builder::clientCache)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientCache").build()}).build();
    private static final SdkField<String> CODEC_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CodecSpecification").getter(HlsGroupSettings.getter(HlsGroupSettings::codecSpecificationAsString)).setter(HlsGroupSettings.setter(Builder::codecSpecification)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codecSpecification").build()}).build();
    private static final SdkField<String> CONSTANT_IV_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConstantIv").getter(HlsGroupSettings.getter(HlsGroupSettings::constantIv)).setter(HlsGroupSettings.setter(Builder::constantIv)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("constantIv").build()}).build();
    private static final SdkField<OutputLocationRef> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Destination").getter(HlsGroupSettings.getter(HlsGroupSettings::destination)).setter(HlsGroupSettings.setter(Builder::destination)).constructor(OutputLocationRef::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()}).build();
    private static final SdkField<String> DIRECTORY_STRUCTURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryStructure").getter(HlsGroupSettings.getter(HlsGroupSettings::directoryStructureAsString)).setter(HlsGroupSettings.setter(Builder::directoryStructure)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directoryStructure").build()}).build();
    private static final SdkField<String> DISCONTINUITY_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DiscontinuityTags").getter(HlsGroupSettings.getter(HlsGroupSettings::discontinuityTagsAsString)).setter(HlsGroupSettings.setter(Builder::discontinuityTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("discontinuityTags").build()}).build();
    private static final SdkField<String> ENCRYPTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionType").getter(HlsGroupSettings.getter(HlsGroupSettings::encryptionTypeAsString)).setter(HlsGroupSettings.setter(Builder::encryptionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionType").build()}).build();
    private static final SdkField<HlsCdnSettings> HLS_CDN_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HlsCdnSettings").getter(HlsGroupSettings.getter(HlsGroupSettings::hlsCdnSettings)).setter(HlsGroupSettings.setter(Builder::hlsCdnSettings)).constructor(HlsCdnSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hlsCdnSettings").build()}).build();
    private static final SdkField<String> HLS_ID3_SEGMENT_TAGGING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HlsId3SegmentTagging").getter(HlsGroupSettings.getter(HlsGroupSettings::hlsId3SegmentTaggingAsString)).setter(HlsGroupSettings.setter(Builder::hlsId3SegmentTagging)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hlsId3SegmentTagging").build()}).build();
    private static final SdkField<String> I_FRAME_ONLY_PLAYLISTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IFrameOnlyPlaylists").getter(HlsGroupSettings.getter(HlsGroupSettings::iFrameOnlyPlaylistsAsString)).setter(HlsGroupSettings.setter(Builder::iFrameOnlyPlaylists)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iFrameOnlyPlaylists").build()}).build();
    private static final SdkField<String> INCOMPLETE_SEGMENT_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IncompleteSegmentBehavior").getter(HlsGroupSettings.getter(HlsGroupSettings::incompleteSegmentBehaviorAsString)).setter(HlsGroupSettings.setter(Builder::incompleteSegmentBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incompleteSegmentBehavior").build()}).build();
    private static final SdkField<Integer> INDEX_N_SEGMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("IndexNSegments").getter(HlsGroupSettings.getter(HlsGroupSettings::indexNSegments)).setter(HlsGroupSettings.setter(Builder::indexNSegments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexNSegments").build()}).build();
    private static final SdkField<String> INPUT_LOSS_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputLossAction").getter(HlsGroupSettings.getter(HlsGroupSettings::inputLossActionAsString)).setter(HlsGroupSettings.setter(Builder::inputLossAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputLossAction").build()}).build();
    private static final SdkField<String> IV_IN_MANIFEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IvInManifest").getter(HlsGroupSettings.getter(HlsGroupSettings::ivInManifestAsString)).setter(HlsGroupSettings.setter(Builder::ivInManifest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ivInManifest").build()}).build();
    private static final SdkField<String> IV_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IvSource").getter(HlsGroupSettings.getter(HlsGroupSettings::ivSourceAsString)).setter(HlsGroupSettings.setter(Builder::ivSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ivSource").build()}).build();
    private static final SdkField<Integer> KEEP_SEGMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("KeepSegments").getter(HlsGroupSettings.getter(HlsGroupSettings::keepSegments)).setter(HlsGroupSettings.setter(Builder::keepSegments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keepSegments").build()}).build();
    private static final SdkField<String> KEY_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyFormat").getter(HlsGroupSettings.getter(HlsGroupSettings::keyFormat)).setter(HlsGroupSettings.setter(Builder::keyFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyFormat").build()}).build();
    private static final SdkField<String> KEY_FORMAT_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyFormatVersions").getter(HlsGroupSettings.getter(HlsGroupSettings::keyFormatVersions)).setter(HlsGroupSettings.setter(Builder::keyFormatVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyFormatVersions").build()}).build();
    private static final SdkField<KeyProviderSettings> KEY_PROVIDER_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KeyProviderSettings").getter(HlsGroupSettings.getter(HlsGroupSettings::keyProviderSettings)).setter(HlsGroupSettings.setter(Builder::keyProviderSettings)).constructor(KeyProviderSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyProviderSettings").build()}).build();
    private static final SdkField<String> MANIFEST_COMPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManifestCompression").getter(HlsGroupSettings.getter(HlsGroupSettings::manifestCompressionAsString)).setter(HlsGroupSettings.setter(Builder::manifestCompression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifestCompression").build()}).build();
    private static final SdkField<String> MANIFEST_DURATION_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManifestDurationFormat").getter(HlsGroupSettings.getter(HlsGroupSettings::manifestDurationFormatAsString)).setter(HlsGroupSettings.setter(Builder::manifestDurationFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifestDurationFormat").build()}).build();
    private static final SdkField<Integer> MIN_SEGMENT_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinSegmentLength").getter(HlsGroupSettings.getter(HlsGroupSettings::minSegmentLength)).setter(HlsGroupSettings.setter(Builder::minSegmentLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minSegmentLength").build()}).build();
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Mode").getter(HlsGroupSettings.getter(HlsGroupSettings::modeAsString)).setter(HlsGroupSettings.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mode").build()}).build();
    private static final SdkField<String> OUTPUT_SELECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputSelection").getter(HlsGroupSettings.getter(HlsGroupSettings::outputSelectionAsString)).setter(HlsGroupSettings.setter(Builder::outputSelection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputSelection").build()}).build();
    private static final SdkField<String> PROGRAM_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProgramDateTime").getter(HlsGroupSettings.getter(HlsGroupSettings::programDateTimeAsString)).setter(HlsGroupSettings.setter(Builder::programDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programDateTime").build()}).build();
    private static final SdkField<Integer> PROGRAM_DATE_TIME_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ProgramDateTimePeriod").getter(HlsGroupSettings.getter(HlsGroupSettings::programDateTimePeriod)).setter(HlsGroupSettings.setter(Builder::programDateTimePeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programDateTimePeriod").build()}).build();
    private static final SdkField<String> REDUNDANT_MANIFEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RedundantManifest").getter(HlsGroupSettings.getter(HlsGroupSettings::redundantManifestAsString)).setter(HlsGroupSettings.setter(Builder::redundantManifest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redundantManifest").build()}).build();
    private static final SdkField<Integer> SEGMENT_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SegmentLength").getter(HlsGroupSettings.getter(HlsGroupSettings::segmentLength)).setter(HlsGroupSettings.setter(Builder::segmentLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentLength").build()}).build();
    private static final SdkField<String> SEGMENTATION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SegmentationMode").getter(HlsGroupSettings.getter(HlsGroupSettings::segmentationModeAsString)).setter(HlsGroupSettings.setter(Builder::segmentationMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentationMode").build()}).build();
    private static final SdkField<Integer> SEGMENTS_PER_SUBDIRECTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SegmentsPerSubdirectory").getter(HlsGroupSettings.getter(HlsGroupSettings::segmentsPerSubdirectory)).setter(HlsGroupSettings.setter(Builder::segmentsPerSubdirectory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentsPerSubdirectory").build()}).build();
    private static final SdkField<String> STREAM_INF_RESOLUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamInfResolution").getter(HlsGroupSettings.getter(HlsGroupSettings::streamInfResolutionAsString)).setter(HlsGroupSettings.setter(Builder::streamInfResolution)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamInfResolution").build()}).build();
    private static final SdkField<String> TIMED_METADATA_ID3_FRAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimedMetadataId3Frame").getter(HlsGroupSettings.getter(HlsGroupSettings::timedMetadataId3FrameAsString)).setter(HlsGroupSettings.setter(Builder::timedMetadataId3Frame)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timedMetadataId3Frame").build()}).build();
    private static final SdkField<Integer> TIMED_METADATA_ID3_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TimedMetadataId3Period").getter(HlsGroupSettings.getter(HlsGroupSettings::timedMetadataId3Period)).setter(HlsGroupSettings.setter(Builder::timedMetadataId3Period)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timedMetadataId3Period").build()}).build();
    private static final SdkField<Integer> TIMESTAMP_DELTA_MILLISECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TimestampDeltaMilliseconds").getter(HlsGroupSettings.getter(HlsGroupSettings::timestampDeltaMilliseconds)).setter(HlsGroupSettings.setter(Builder::timestampDeltaMilliseconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestampDeltaMilliseconds").build()}).build();
    private static final SdkField<String> TS_FILE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TsFileMode").getter(HlsGroupSettings.getter(HlsGroupSettings::tsFileModeAsString)).setter(HlsGroupSettings.setter(Builder::tsFileMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tsFileMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AD_MARKERS_FIELD, BASE_URL_CONTENT_FIELD, BASE_URL_CONTENT1_FIELD, BASE_URL_MANIFEST_FIELD, BASE_URL_MANIFEST1_FIELD, CAPTION_LANGUAGE_MAPPINGS_FIELD, CAPTION_LANGUAGE_SETTING_FIELD, CLIENT_CACHE_FIELD, CODEC_SPECIFICATION_FIELD, CONSTANT_IV_FIELD, DESTINATION_FIELD, DIRECTORY_STRUCTURE_FIELD, DISCONTINUITY_TAGS_FIELD, ENCRYPTION_TYPE_FIELD, HLS_CDN_SETTINGS_FIELD, HLS_ID3_SEGMENT_TAGGING_FIELD, I_FRAME_ONLY_PLAYLISTS_FIELD, INCOMPLETE_SEGMENT_BEHAVIOR_FIELD, INDEX_N_SEGMENTS_FIELD, INPUT_LOSS_ACTION_FIELD, IV_IN_MANIFEST_FIELD, IV_SOURCE_FIELD, KEEP_SEGMENTS_FIELD, KEY_FORMAT_FIELD, KEY_FORMAT_VERSIONS_FIELD, KEY_PROVIDER_SETTINGS_FIELD, MANIFEST_COMPRESSION_FIELD, MANIFEST_DURATION_FORMAT_FIELD, MIN_SEGMENT_LENGTH_FIELD, MODE_FIELD, OUTPUT_SELECTION_FIELD, PROGRAM_DATE_TIME_FIELD, PROGRAM_DATE_TIME_PERIOD_FIELD, REDUNDANT_MANIFEST_FIELD, SEGMENT_LENGTH_FIELD, SEGMENTATION_MODE_FIELD, SEGMENTS_PER_SUBDIRECTORY_FIELD, STREAM_INF_RESOLUTION_FIELD, TIMED_METADATA_ID3_FRAME_FIELD, TIMED_METADATA_ID3_PERIOD_FIELD, TIMESTAMP_DELTA_MILLISECONDS_FIELD, TS_FILE_MODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> adMarkers;
    private final String baseUrlContent;
    private final String baseUrlContent1;
    private final String baseUrlManifest;
    private final String baseUrlManifest1;
    private final List<CaptionLanguageMapping> captionLanguageMappings;
    private final String captionLanguageSetting;
    private final String clientCache;
    private final String codecSpecification;
    private final String constantIv;
    private final OutputLocationRef destination;
    private final String directoryStructure;
    private final String discontinuityTags;
    private final String encryptionType;
    private final HlsCdnSettings hlsCdnSettings;
    private final String hlsId3SegmentTagging;
    private final String iFrameOnlyPlaylists;
    private final String incompleteSegmentBehavior;
    private final Integer indexNSegments;
    private final String inputLossAction;
    private final String ivInManifest;
    private final String ivSource;
    private final Integer keepSegments;
    private final String keyFormat;
    private final String keyFormatVersions;
    private final KeyProviderSettings keyProviderSettings;
    private final String manifestCompression;
    private final String manifestDurationFormat;
    private final Integer minSegmentLength;
    private final String mode;
    private final String outputSelection;
    private final String programDateTime;
    private final Integer programDateTimePeriod;
    private final String redundantManifest;
    private final Integer segmentLength;
    private final String segmentationMode;
    private final Integer segmentsPerSubdirectory;
    private final String streamInfResolution;
    private final String timedMetadataId3Frame;
    private final Integer timedMetadataId3Period;
    private final Integer timestampDeltaMilliseconds;
    private final String tsFileMode;

    private HlsGroupSettings(BuilderImpl builder) {
        this.adMarkers = builder.adMarkers;
        this.baseUrlContent = builder.baseUrlContent;
        this.baseUrlContent1 = builder.baseUrlContent1;
        this.baseUrlManifest = builder.baseUrlManifest;
        this.baseUrlManifest1 = builder.baseUrlManifest1;
        this.captionLanguageMappings = builder.captionLanguageMappings;
        this.captionLanguageSetting = builder.captionLanguageSetting;
        this.clientCache = builder.clientCache;
        this.codecSpecification = builder.codecSpecification;
        this.constantIv = builder.constantIv;
        this.destination = builder.destination;
        this.directoryStructure = builder.directoryStructure;
        this.discontinuityTags = builder.discontinuityTags;
        this.encryptionType = builder.encryptionType;
        this.hlsCdnSettings = builder.hlsCdnSettings;
        this.hlsId3SegmentTagging = builder.hlsId3SegmentTagging;
        this.iFrameOnlyPlaylists = builder.iFrameOnlyPlaylists;
        this.incompleteSegmentBehavior = builder.incompleteSegmentBehavior;
        this.indexNSegments = builder.indexNSegments;
        this.inputLossAction = builder.inputLossAction;
        this.ivInManifest = builder.ivInManifest;
        this.ivSource = builder.ivSource;
        this.keepSegments = builder.keepSegments;
        this.keyFormat = builder.keyFormat;
        this.keyFormatVersions = builder.keyFormatVersions;
        this.keyProviderSettings = builder.keyProviderSettings;
        this.manifestCompression = builder.manifestCompression;
        this.manifestDurationFormat = builder.manifestDurationFormat;
        this.minSegmentLength = builder.minSegmentLength;
        this.mode = builder.mode;
        this.outputSelection = builder.outputSelection;
        this.programDateTime = builder.programDateTime;
        this.programDateTimePeriod = builder.programDateTimePeriod;
        this.redundantManifest = builder.redundantManifest;
        this.segmentLength = builder.segmentLength;
        this.segmentationMode = builder.segmentationMode;
        this.segmentsPerSubdirectory = builder.segmentsPerSubdirectory;
        this.streamInfResolution = builder.streamInfResolution;
        this.timedMetadataId3Frame = builder.timedMetadataId3Frame;
        this.timedMetadataId3Period = builder.timedMetadataId3Period;
        this.timestampDeltaMilliseconds = builder.timestampDeltaMilliseconds;
        this.tsFileMode = builder.tsFileMode;
    }

    public final List<HlsAdMarkers> adMarkers() {
        return ___listOfHlsAdMarkersCopier.copyStringToEnum(this.adMarkers);
    }

    public final boolean hasAdMarkers() {
        return this.adMarkers != null && !(this.adMarkers instanceof SdkAutoConstructList);
    }

    public final List<String> adMarkersAsStrings() {
        return this.adMarkers;
    }

    public final String baseUrlContent() {
        return this.baseUrlContent;
    }

    public final String baseUrlContent1() {
        return this.baseUrlContent1;
    }

    public final String baseUrlManifest() {
        return this.baseUrlManifest;
    }

    public final String baseUrlManifest1() {
        return this.baseUrlManifest1;
    }

    public final boolean hasCaptionLanguageMappings() {
        return this.captionLanguageMappings != null && !(this.captionLanguageMappings instanceof SdkAutoConstructList);
    }

    public final List<CaptionLanguageMapping> captionLanguageMappings() {
        return this.captionLanguageMappings;
    }

    public final HlsCaptionLanguageSetting captionLanguageSetting() {
        return HlsCaptionLanguageSetting.fromValue(this.captionLanguageSetting);
    }

    public final String captionLanguageSettingAsString() {
        return this.captionLanguageSetting;
    }

    public final HlsClientCache clientCache() {
        return HlsClientCache.fromValue(this.clientCache);
    }

    public final String clientCacheAsString() {
        return this.clientCache;
    }

    public final HlsCodecSpecification codecSpecification() {
        return HlsCodecSpecification.fromValue(this.codecSpecification);
    }

    public final String codecSpecificationAsString() {
        return this.codecSpecification;
    }

    public final String constantIv() {
        return this.constantIv;
    }

    public final OutputLocationRef destination() {
        return this.destination;
    }

    public final HlsDirectoryStructure directoryStructure() {
        return HlsDirectoryStructure.fromValue(this.directoryStructure);
    }

    public final String directoryStructureAsString() {
        return this.directoryStructure;
    }

    public final HlsDiscontinuityTags discontinuityTags() {
        return HlsDiscontinuityTags.fromValue(this.discontinuityTags);
    }

    public final String discontinuityTagsAsString() {
        return this.discontinuityTags;
    }

    public final HlsEncryptionType encryptionType() {
        return HlsEncryptionType.fromValue(this.encryptionType);
    }

    public final String encryptionTypeAsString() {
        return this.encryptionType;
    }

    public final HlsCdnSettings hlsCdnSettings() {
        return this.hlsCdnSettings;
    }

    public final HlsId3SegmentTaggingState hlsId3SegmentTagging() {
        return HlsId3SegmentTaggingState.fromValue(this.hlsId3SegmentTagging);
    }

    public final String hlsId3SegmentTaggingAsString() {
        return this.hlsId3SegmentTagging;
    }

    public final IFrameOnlyPlaylistType iFrameOnlyPlaylists() {
        return IFrameOnlyPlaylistType.fromValue(this.iFrameOnlyPlaylists);
    }

    public final String iFrameOnlyPlaylistsAsString() {
        return this.iFrameOnlyPlaylists;
    }

    public final HlsIncompleteSegmentBehavior incompleteSegmentBehavior() {
        return HlsIncompleteSegmentBehavior.fromValue(this.incompleteSegmentBehavior);
    }

    public final String incompleteSegmentBehaviorAsString() {
        return this.incompleteSegmentBehavior;
    }

    public final Integer indexNSegments() {
        return this.indexNSegments;
    }

    public final InputLossActionForHlsOut inputLossAction() {
        return InputLossActionForHlsOut.fromValue(this.inputLossAction);
    }

    public final String inputLossActionAsString() {
        return this.inputLossAction;
    }

    public final HlsIvInManifest ivInManifest() {
        return HlsIvInManifest.fromValue(this.ivInManifest);
    }

    public final String ivInManifestAsString() {
        return this.ivInManifest;
    }

    public final HlsIvSource ivSource() {
        return HlsIvSource.fromValue(this.ivSource);
    }

    public final String ivSourceAsString() {
        return this.ivSource;
    }

    public final Integer keepSegments() {
        return this.keepSegments;
    }

    public final String keyFormat() {
        return this.keyFormat;
    }

    public final String keyFormatVersions() {
        return this.keyFormatVersions;
    }

    public final KeyProviderSettings keyProviderSettings() {
        return this.keyProviderSettings;
    }

    public final HlsManifestCompression manifestCompression() {
        return HlsManifestCompression.fromValue(this.manifestCompression);
    }

    public final String manifestCompressionAsString() {
        return this.manifestCompression;
    }

    public final HlsManifestDurationFormat manifestDurationFormat() {
        return HlsManifestDurationFormat.fromValue(this.manifestDurationFormat);
    }

    public final String manifestDurationFormatAsString() {
        return this.manifestDurationFormat;
    }

    public final Integer minSegmentLength() {
        return this.minSegmentLength;
    }

    public final HlsMode mode() {
        return HlsMode.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    public final HlsOutputSelection outputSelection() {
        return HlsOutputSelection.fromValue(this.outputSelection);
    }

    public final String outputSelectionAsString() {
        return this.outputSelection;
    }

    public final HlsProgramDateTime programDateTime() {
        return HlsProgramDateTime.fromValue(this.programDateTime);
    }

    public final String programDateTimeAsString() {
        return this.programDateTime;
    }

    public final Integer programDateTimePeriod() {
        return this.programDateTimePeriod;
    }

    public final HlsRedundantManifest redundantManifest() {
        return HlsRedundantManifest.fromValue(this.redundantManifest);
    }

    public final String redundantManifestAsString() {
        return this.redundantManifest;
    }

    public final Integer segmentLength() {
        return this.segmentLength;
    }

    public final HlsSegmentationMode segmentationMode() {
        return HlsSegmentationMode.fromValue(this.segmentationMode);
    }

    public final String segmentationModeAsString() {
        return this.segmentationMode;
    }

    public final Integer segmentsPerSubdirectory() {
        return this.segmentsPerSubdirectory;
    }

    public final HlsStreamInfResolution streamInfResolution() {
        return HlsStreamInfResolution.fromValue(this.streamInfResolution);
    }

    public final String streamInfResolutionAsString() {
        return this.streamInfResolution;
    }

    public final HlsTimedMetadataId3Frame timedMetadataId3Frame() {
        return HlsTimedMetadataId3Frame.fromValue(this.timedMetadataId3Frame);
    }

    public final String timedMetadataId3FrameAsString() {
        return this.timedMetadataId3Frame;
    }

    public final Integer timedMetadataId3Period() {
        return this.timedMetadataId3Period;
    }

    public final Integer timestampDeltaMilliseconds() {
        return this.timestampDeltaMilliseconds;
    }

    public final HlsTsFileMode tsFileMode() {
        return HlsTsFileMode.fromValue(this.tsFileMode);
    }

    public final String tsFileModeAsString() {
        return this.tsFileMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdMarkers() ? this.adMarkersAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.baseUrlContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseUrlContent1());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseUrlManifest());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseUrlManifest1());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCaptionLanguageMappings() ? this.captionLanguageMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.captionLanguageSettingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientCacheAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.codecSpecificationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.constantIv());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryStructureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.discontinuityTagsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hlsCdnSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hlsId3SegmentTaggingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.iFrameOnlyPlaylistsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.incompleteSegmentBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexNSegments());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputLossActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ivInManifestAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ivSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.keepSegments());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyFormat());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyFormatVersions());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyProviderSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestCompressionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestDurationFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.minSegmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputSelectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.programDateTimeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.programDateTimePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.redundantManifestAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentsPerSubdirectory());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamInfResolutionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timedMetadataId3FrameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timedMetadataId3Period());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestampDeltaMilliseconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.tsFileModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsGroupSettings)) {
            return false;
        }
        HlsGroupSettings other = (HlsGroupSettings)obj;
        return this.hasAdMarkers() == other.hasAdMarkers() && Objects.equals(this.adMarkersAsStrings(), other.adMarkersAsStrings()) && Objects.equals(this.baseUrlContent(), other.baseUrlContent()) && Objects.equals(this.baseUrlContent1(), other.baseUrlContent1()) && Objects.equals(this.baseUrlManifest(), other.baseUrlManifest()) && Objects.equals(this.baseUrlManifest1(), other.baseUrlManifest1()) && this.hasCaptionLanguageMappings() == other.hasCaptionLanguageMappings() && Objects.equals(this.captionLanguageMappings(), other.captionLanguageMappings()) && Objects.equals(this.captionLanguageSettingAsString(), other.captionLanguageSettingAsString()) && Objects.equals(this.clientCacheAsString(), other.clientCacheAsString()) && Objects.equals(this.codecSpecificationAsString(), other.codecSpecificationAsString()) && Objects.equals(this.constantIv(), other.constantIv()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.directoryStructureAsString(), other.directoryStructureAsString()) && Objects.equals(this.discontinuityTagsAsString(), other.discontinuityTagsAsString()) && Objects.equals(this.encryptionTypeAsString(), other.encryptionTypeAsString()) && Objects.equals(this.hlsCdnSettings(), other.hlsCdnSettings()) && Objects.equals(this.hlsId3SegmentTaggingAsString(), other.hlsId3SegmentTaggingAsString()) && Objects.equals(this.iFrameOnlyPlaylistsAsString(), other.iFrameOnlyPlaylistsAsString()) && Objects.equals(this.incompleteSegmentBehaviorAsString(), other.incompleteSegmentBehaviorAsString()) && Objects.equals(this.indexNSegments(), other.indexNSegments()) && Objects.equals(this.inputLossActionAsString(), other.inputLossActionAsString()) && Objects.equals(this.ivInManifestAsString(), other.ivInManifestAsString()) && Objects.equals(this.ivSourceAsString(), other.ivSourceAsString()) && Objects.equals(this.keepSegments(), other.keepSegments()) && Objects.equals(this.keyFormat(), other.keyFormat()) && Objects.equals(this.keyFormatVersions(), other.keyFormatVersions()) && Objects.equals(this.keyProviderSettings(), other.keyProviderSettings()) && Objects.equals(this.manifestCompressionAsString(), other.manifestCompressionAsString()) && Objects.equals(this.manifestDurationFormatAsString(), other.manifestDurationFormatAsString()) && Objects.equals(this.minSegmentLength(), other.minSegmentLength()) && Objects.equals(this.modeAsString(), other.modeAsString()) && Objects.equals(this.outputSelectionAsString(), other.outputSelectionAsString()) && Objects.equals(this.programDateTimeAsString(), other.programDateTimeAsString()) && Objects.equals(this.programDateTimePeriod(), other.programDateTimePeriod()) && Objects.equals(this.redundantManifestAsString(), other.redundantManifestAsString()) && Objects.equals(this.segmentLength(), other.segmentLength()) && Objects.equals(this.segmentationModeAsString(), other.segmentationModeAsString()) && Objects.equals(this.segmentsPerSubdirectory(), other.segmentsPerSubdirectory()) && Objects.equals(this.streamInfResolutionAsString(), other.streamInfResolutionAsString()) && Objects.equals(this.timedMetadataId3FrameAsString(), other.timedMetadataId3FrameAsString()) && Objects.equals(this.timedMetadataId3Period(), other.timedMetadataId3Period()) && Objects.equals(this.timestampDeltaMilliseconds(), other.timestampDeltaMilliseconds()) && Objects.equals(this.tsFileModeAsString(), other.tsFileModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"HlsGroupSettings").add("AdMarkers", this.hasAdMarkers() ? this.adMarkersAsStrings() : null).add("BaseUrlContent", (Object)this.baseUrlContent()).add("BaseUrlContent1", (Object)this.baseUrlContent1()).add("BaseUrlManifest", (Object)this.baseUrlManifest()).add("BaseUrlManifest1", (Object)this.baseUrlManifest1()).add("CaptionLanguageMappings", this.hasCaptionLanguageMappings() ? this.captionLanguageMappings() : null).add("CaptionLanguageSetting", (Object)this.captionLanguageSettingAsString()).add("ClientCache", (Object)this.clientCacheAsString()).add("CodecSpecification", (Object)this.codecSpecificationAsString()).add("ConstantIv", (Object)this.constantIv()).add("Destination", (Object)this.destination()).add("DirectoryStructure", (Object)this.directoryStructureAsString()).add("DiscontinuityTags", (Object)this.discontinuityTagsAsString()).add("EncryptionType", (Object)this.encryptionTypeAsString()).add("HlsCdnSettings", (Object)this.hlsCdnSettings()).add("HlsId3SegmentTagging", (Object)this.hlsId3SegmentTaggingAsString()).add("IFrameOnlyPlaylists", (Object)this.iFrameOnlyPlaylistsAsString()).add("IncompleteSegmentBehavior", (Object)this.incompleteSegmentBehaviorAsString()).add("IndexNSegments", (Object)this.indexNSegments()).add("InputLossAction", (Object)this.inputLossActionAsString()).add("IvInManifest", (Object)this.ivInManifestAsString()).add("IvSource", (Object)this.ivSourceAsString()).add("KeepSegments", (Object)this.keepSegments()).add("KeyFormat", (Object)this.keyFormat()).add("KeyFormatVersions", (Object)this.keyFormatVersions()).add("KeyProviderSettings", (Object)this.keyProviderSettings()).add("ManifestCompression", (Object)this.manifestCompressionAsString()).add("ManifestDurationFormat", (Object)this.manifestDurationFormatAsString()).add("MinSegmentLength", (Object)this.minSegmentLength()).add("Mode", (Object)this.modeAsString()).add("OutputSelection", (Object)this.outputSelectionAsString()).add("ProgramDateTime", (Object)this.programDateTimeAsString()).add("ProgramDateTimePeriod", (Object)this.programDateTimePeriod()).add("RedundantManifest", (Object)this.redundantManifestAsString()).add("SegmentLength", (Object)this.segmentLength()).add("SegmentationMode", (Object)this.segmentationModeAsString()).add("SegmentsPerSubdirectory", (Object)this.segmentsPerSubdirectory()).add("StreamInfResolution", (Object)this.streamInfResolutionAsString()).add("TimedMetadataId3Frame", (Object)this.timedMetadataId3FrameAsString()).add("TimedMetadataId3Period", (Object)this.timedMetadataId3Period()).add("TimestampDeltaMilliseconds", (Object)this.timestampDeltaMilliseconds()).add("TsFileMode", (Object)this.tsFileModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdMarkers": {
                return Optional.ofNullable(clazz.cast(this.adMarkersAsStrings()));
            }
            case "BaseUrlContent": {
                return Optional.ofNullable(clazz.cast(this.baseUrlContent()));
            }
            case "BaseUrlContent1": {
                return Optional.ofNullable(clazz.cast(this.baseUrlContent1()));
            }
            case "BaseUrlManifest": {
                return Optional.ofNullable(clazz.cast(this.baseUrlManifest()));
            }
            case "BaseUrlManifest1": {
                return Optional.ofNullable(clazz.cast(this.baseUrlManifest1()));
            }
            case "CaptionLanguageMappings": {
                return Optional.ofNullable(clazz.cast(this.captionLanguageMappings()));
            }
            case "CaptionLanguageSetting": {
                return Optional.ofNullable(clazz.cast(this.captionLanguageSettingAsString()));
            }
            case "ClientCache": {
                return Optional.ofNullable(clazz.cast(this.clientCacheAsString()));
            }
            case "CodecSpecification": {
                return Optional.ofNullable(clazz.cast(this.codecSpecificationAsString()));
            }
            case "ConstantIv": {
                return Optional.ofNullable(clazz.cast(this.constantIv()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "DirectoryStructure": {
                return Optional.ofNullable(clazz.cast(this.directoryStructureAsString()));
            }
            case "DiscontinuityTags": {
                return Optional.ofNullable(clazz.cast(this.discontinuityTagsAsString()));
            }
            case "EncryptionType": {
                return Optional.ofNullable(clazz.cast(this.encryptionTypeAsString()));
            }
            case "HlsCdnSettings": {
                return Optional.ofNullable(clazz.cast(this.hlsCdnSettings()));
            }
            case "HlsId3SegmentTagging": {
                return Optional.ofNullable(clazz.cast(this.hlsId3SegmentTaggingAsString()));
            }
            case "IFrameOnlyPlaylists": {
                return Optional.ofNullable(clazz.cast(this.iFrameOnlyPlaylistsAsString()));
            }
            case "IncompleteSegmentBehavior": {
                return Optional.ofNullable(clazz.cast(this.incompleteSegmentBehaviorAsString()));
            }
            case "IndexNSegments": {
                return Optional.ofNullable(clazz.cast(this.indexNSegments()));
            }
            case "InputLossAction": {
                return Optional.ofNullable(clazz.cast(this.inputLossActionAsString()));
            }
            case "IvInManifest": {
                return Optional.ofNullable(clazz.cast(this.ivInManifestAsString()));
            }
            case "IvSource": {
                return Optional.ofNullable(clazz.cast(this.ivSourceAsString()));
            }
            case "KeepSegments": {
                return Optional.ofNullable(clazz.cast(this.keepSegments()));
            }
            case "KeyFormat": {
                return Optional.ofNullable(clazz.cast(this.keyFormat()));
            }
            case "KeyFormatVersions": {
                return Optional.ofNullable(clazz.cast(this.keyFormatVersions()));
            }
            case "KeyProviderSettings": {
                return Optional.ofNullable(clazz.cast(this.keyProviderSettings()));
            }
            case "ManifestCompression": {
                return Optional.ofNullable(clazz.cast(this.manifestCompressionAsString()));
            }
            case "ManifestDurationFormat": {
                return Optional.ofNullable(clazz.cast(this.manifestDurationFormatAsString()));
            }
            case "MinSegmentLength": {
                return Optional.ofNullable(clazz.cast(this.minSegmentLength()));
            }
            case "Mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
            case "OutputSelection": {
                return Optional.ofNullable(clazz.cast(this.outputSelectionAsString()));
            }
            case "ProgramDateTime": {
                return Optional.ofNullable(clazz.cast(this.programDateTimeAsString()));
            }
            case "ProgramDateTimePeriod": {
                return Optional.ofNullable(clazz.cast(this.programDateTimePeriod()));
            }
            case "RedundantManifest": {
                return Optional.ofNullable(clazz.cast(this.redundantManifestAsString()));
            }
            case "SegmentLength": {
                return Optional.ofNullable(clazz.cast(this.segmentLength()));
            }
            case "SegmentationMode": {
                return Optional.ofNullable(clazz.cast(this.segmentationModeAsString()));
            }
            case "SegmentsPerSubdirectory": {
                return Optional.ofNullable(clazz.cast(this.segmentsPerSubdirectory()));
            }
            case "StreamInfResolution": {
                return Optional.ofNullable(clazz.cast(this.streamInfResolutionAsString()));
            }
            case "TimedMetadataId3Frame": {
                return Optional.ofNullable(clazz.cast(this.timedMetadataId3FrameAsString()));
            }
            case "TimedMetadataId3Period": {
                return Optional.ofNullable(clazz.cast(this.timedMetadataId3Period()));
            }
            case "TimestampDeltaMilliseconds": {
                return Optional.ofNullable(clazz.cast(this.timestampDeltaMilliseconds()));
            }
            case "TsFileMode": {
                return Optional.ofNullable(clazz.cast(this.tsFileModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HlsGroupSettings, T> g) {
        return obj -> g.apply((HlsGroupSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> adMarkers = DefaultSdkAutoConstructList.getInstance();
        private String baseUrlContent;
        private String baseUrlContent1;
        private String baseUrlManifest;
        private String baseUrlManifest1;
        private List<CaptionLanguageMapping> captionLanguageMappings = DefaultSdkAutoConstructList.getInstance();
        private String captionLanguageSetting;
        private String clientCache;
        private String codecSpecification;
        private String constantIv;
        private OutputLocationRef destination;
        private String directoryStructure;
        private String discontinuityTags;
        private String encryptionType;
        private HlsCdnSettings hlsCdnSettings;
        private String hlsId3SegmentTagging;
        private String iFrameOnlyPlaylists;
        private String incompleteSegmentBehavior;
        private Integer indexNSegments;
        private String inputLossAction;
        private String ivInManifest;
        private String ivSource;
        private Integer keepSegments;
        private String keyFormat;
        private String keyFormatVersions;
        private KeyProviderSettings keyProviderSettings;
        private String manifestCompression;
        private String manifestDurationFormat;
        private Integer minSegmentLength;
        private String mode;
        private String outputSelection;
        private String programDateTime;
        private Integer programDateTimePeriod;
        private String redundantManifest;
        private Integer segmentLength;
        private String segmentationMode;
        private Integer segmentsPerSubdirectory;
        private String streamInfResolution;
        private String timedMetadataId3Frame;
        private Integer timedMetadataId3Period;
        private Integer timestampDeltaMilliseconds;
        private String tsFileMode;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsGroupSettings model) {
            this.adMarkersWithStrings(model.adMarkers);
            this.baseUrlContent(model.baseUrlContent);
            this.baseUrlContent1(model.baseUrlContent1);
            this.baseUrlManifest(model.baseUrlManifest);
            this.baseUrlManifest1(model.baseUrlManifest1);
            this.captionLanguageMappings(model.captionLanguageMappings);
            this.captionLanguageSetting(model.captionLanguageSetting);
            this.clientCache(model.clientCache);
            this.codecSpecification(model.codecSpecification);
            this.constantIv(model.constantIv);
            this.destination(model.destination);
            this.directoryStructure(model.directoryStructure);
            this.discontinuityTags(model.discontinuityTags);
            this.encryptionType(model.encryptionType);
            this.hlsCdnSettings(model.hlsCdnSettings);
            this.hlsId3SegmentTagging(model.hlsId3SegmentTagging);
            this.iFrameOnlyPlaylists(model.iFrameOnlyPlaylists);
            this.incompleteSegmentBehavior(model.incompleteSegmentBehavior);
            this.indexNSegments(model.indexNSegments);
            this.inputLossAction(model.inputLossAction);
            this.ivInManifest(model.ivInManifest);
            this.ivSource(model.ivSource);
            this.keepSegments(model.keepSegments);
            this.keyFormat(model.keyFormat);
            this.keyFormatVersions(model.keyFormatVersions);
            this.keyProviderSettings(model.keyProviderSettings);
            this.manifestCompression(model.manifestCompression);
            this.manifestDurationFormat(model.manifestDurationFormat);
            this.minSegmentLength(model.minSegmentLength);
            this.mode(model.mode);
            this.outputSelection(model.outputSelection);
            this.programDateTime(model.programDateTime);
            this.programDateTimePeriod(model.programDateTimePeriod);
            this.redundantManifest(model.redundantManifest);
            this.segmentLength(model.segmentLength);
            this.segmentationMode(model.segmentationMode);
            this.segmentsPerSubdirectory(model.segmentsPerSubdirectory);
            this.streamInfResolution(model.streamInfResolution);
            this.timedMetadataId3Frame(model.timedMetadataId3Frame);
            this.timedMetadataId3Period(model.timedMetadataId3Period);
            this.timestampDeltaMilliseconds(model.timestampDeltaMilliseconds);
            this.tsFileMode(model.tsFileMode);
        }

        public final Collection<String> getAdMarkers() {
            if (this.adMarkers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.adMarkers;
        }

        public final void setAdMarkers(Collection<String> adMarkers) {
            this.adMarkers = ___listOfHlsAdMarkersCopier.copy(adMarkers);
        }

        @Override
        @Transient
        public final Builder adMarkersWithStrings(Collection<String> adMarkers) {
            this.adMarkers = ___listOfHlsAdMarkersCopier.copy(adMarkers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder adMarkersWithStrings(String ... adMarkers) {
            this.adMarkersWithStrings(Arrays.asList(adMarkers));
            return this;
        }

        @Override
        @Transient
        public final Builder adMarkers(Collection<HlsAdMarkers> adMarkers) {
            this.adMarkers = ___listOfHlsAdMarkersCopier.copyEnumToString(adMarkers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder adMarkers(HlsAdMarkers ... adMarkers) {
            this.adMarkers(Arrays.asList(adMarkers));
            return this;
        }

        public final String getBaseUrlContent() {
            return this.baseUrlContent;
        }

        public final void setBaseUrlContent(String baseUrlContent) {
            this.baseUrlContent = baseUrlContent;
        }

        @Override
        @Transient
        public final Builder baseUrlContent(String baseUrlContent) {
            this.baseUrlContent = baseUrlContent;
            return this;
        }

        public final String getBaseUrlContent1() {
            return this.baseUrlContent1;
        }

        public final void setBaseUrlContent1(String baseUrlContent1) {
            this.baseUrlContent1 = baseUrlContent1;
        }

        @Override
        @Transient
        public final Builder baseUrlContent1(String baseUrlContent1) {
            this.baseUrlContent1 = baseUrlContent1;
            return this;
        }

        public final String getBaseUrlManifest() {
            return this.baseUrlManifest;
        }

        public final void setBaseUrlManifest(String baseUrlManifest) {
            this.baseUrlManifest = baseUrlManifest;
        }

        @Override
        @Transient
        public final Builder baseUrlManifest(String baseUrlManifest) {
            this.baseUrlManifest = baseUrlManifest;
            return this;
        }

        public final String getBaseUrlManifest1() {
            return this.baseUrlManifest1;
        }

        public final void setBaseUrlManifest1(String baseUrlManifest1) {
            this.baseUrlManifest1 = baseUrlManifest1;
        }

        @Override
        @Transient
        public final Builder baseUrlManifest1(String baseUrlManifest1) {
            this.baseUrlManifest1 = baseUrlManifest1;
            return this;
        }

        public final List<CaptionLanguageMapping.Builder> getCaptionLanguageMappings() {
            List<CaptionLanguageMapping.Builder> result = ___listOfCaptionLanguageMappingCopier.copyToBuilder(this.captionLanguageMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCaptionLanguageMappings(Collection<CaptionLanguageMapping.BuilderImpl> captionLanguageMappings) {
            this.captionLanguageMappings = ___listOfCaptionLanguageMappingCopier.copyFromBuilder(captionLanguageMappings);
        }

        @Override
        @Transient
        public final Builder captionLanguageMappings(Collection<CaptionLanguageMapping> captionLanguageMappings) {
            this.captionLanguageMappings = ___listOfCaptionLanguageMappingCopier.copy(captionLanguageMappings);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder captionLanguageMappings(CaptionLanguageMapping ... captionLanguageMappings) {
            this.captionLanguageMappings(Arrays.asList(captionLanguageMappings));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder captionLanguageMappings(Consumer<CaptionLanguageMapping.Builder> ... captionLanguageMappings) {
            this.captionLanguageMappings(Stream.of(captionLanguageMappings).map(c -> (CaptionLanguageMapping)((CaptionLanguageMapping.Builder)CaptionLanguageMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getCaptionLanguageSetting() {
            return this.captionLanguageSetting;
        }

        public final void setCaptionLanguageSetting(String captionLanguageSetting) {
            this.captionLanguageSetting = captionLanguageSetting;
        }

        @Override
        @Transient
        public final Builder captionLanguageSetting(String captionLanguageSetting) {
            this.captionLanguageSetting = captionLanguageSetting;
            return this;
        }

        @Override
        @Transient
        public final Builder captionLanguageSetting(HlsCaptionLanguageSetting captionLanguageSetting) {
            this.captionLanguageSetting(captionLanguageSetting == null ? null : captionLanguageSetting.toString());
            return this;
        }

        public final String getClientCache() {
            return this.clientCache;
        }

        public final void setClientCache(String clientCache) {
            this.clientCache = clientCache;
        }

        @Override
        @Transient
        public final Builder clientCache(String clientCache) {
            this.clientCache = clientCache;
            return this;
        }

        @Override
        @Transient
        public final Builder clientCache(HlsClientCache clientCache) {
            this.clientCache(clientCache == null ? null : clientCache.toString());
            return this;
        }

        public final String getCodecSpecification() {
            return this.codecSpecification;
        }

        public final void setCodecSpecification(String codecSpecification) {
            this.codecSpecification = codecSpecification;
        }

        @Override
        @Transient
        public final Builder codecSpecification(String codecSpecification) {
            this.codecSpecification = codecSpecification;
            return this;
        }

        @Override
        @Transient
        public final Builder codecSpecification(HlsCodecSpecification codecSpecification) {
            this.codecSpecification(codecSpecification == null ? null : codecSpecification.toString());
            return this;
        }

        public final String getConstantIv() {
            return this.constantIv;
        }

        public final void setConstantIv(String constantIv) {
            this.constantIv = constantIv;
        }

        @Override
        @Transient
        public final Builder constantIv(String constantIv) {
            this.constantIv = constantIv;
            return this;
        }

        public final OutputLocationRef.Builder getDestination() {
            return this.destination != null ? this.destination.toBuilder() : null;
        }

        public final void setDestination(OutputLocationRef.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        @Transient
        public final Builder destination(OutputLocationRef destination) {
            this.destination = destination;
            return this;
        }

        public final String getDirectoryStructure() {
            return this.directoryStructure;
        }

        public final void setDirectoryStructure(String directoryStructure) {
            this.directoryStructure = directoryStructure;
        }

        @Override
        @Transient
        public final Builder directoryStructure(String directoryStructure) {
            this.directoryStructure = directoryStructure;
            return this;
        }

        @Override
        @Transient
        public final Builder directoryStructure(HlsDirectoryStructure directoryStructure) {
            this.directoryStructure(directoryStructure == null ? null : directoryStructure.toString());
            return this;
        }

        public final String getDiscontinuityTags() {
            return this.discontinuityTags;
        }

        public final void setDiscontinuityTags(String discontinuityTags) {
            this.discontinuityTags = discontinuityTags;
        }

        @Override
        @Transient
        public final Builder discontinuityTags(String discontinuityTags) {
            this.discontinuityTags = discontinuityTags;
            return this;
        }

        @Override
        @Transient
        public final Builder discontinuityTags(HlsDiscontinuityTags discontinuityTags) {
            this.discontinuityTags(discontinuityTags == null ? null : discontinuityTags.toString());
            return this;
        }

        public final String getEncryptionType() {
            return this.encryptionType;
        }

        public final void setEncryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
        }

        @Override
        @Transient
        public final Builder encryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
            return this;
        }

        @Override
        @Transient
        public final Builder encryptionType(HlsEncryptionType encryptionType) {
            this.encryptionType(encryptionType == null ? null : encryptionType.toString());
            return this;
        }

        public final HlsCdnSettings.Builder getHlsCdnSettings() {
            return this.hlsCdnSettings != null ? this.hlsCdnSettings.toBuilder() : null;
        }

        public final void setHlsCdnSettings(HlsCdnSettings.BuilderImpl hlsCdnSettings) {
            this.hlsCdnSettings = hlsCdnSettings != null ? hlsCdnSettings.build() : null;
        }

        @Override
        @Transient
        public final Builder hlsCdnSettings(HlsCdnSettings hlsCdnSettings) {
            this.hlsCdnSettings = hlsCdnSettings;
            return this;
        }

        public final String getHlsId3SegmentTagging() {
            return this.hlsId3SegmentTagging;
        }

        public final void setHlsId3SegmentTagging(String hlsId3SegmentTagging) {
            this.hlsId3SegmentTagging = hlsId3SegmentTagging;
        }

        @Override
        @Transient
        public final Builder hlsId3SegmentTagging(String hlsId3SegmentTagging) {
            this.hlsId3SegmentTagging = hlsId3SegmentTagging;
            return this;
        }

        @Override
        @Transient
        public final Builder hlsId3SegmentTagging(HlsId3SegmentTaggingState hlsId3SegmentTagging) {
            this.hlsId3SegmentTagging(hlsId3SegmentTagging == null ? null : hlsId3SegmentTagging.toString());
            return this;
        }

        public final String getIFrameOnlyPlaylists() {
            return this.iFrameOnlyPlaylists;
        }

        public final void setIFrameOnlyPlaylists(String iFrameOnlyPlaylists) {
            this.iFrameOnlyPlaylists = iFrameOnlyPlaylists;
        }

        @Override
        @Transient
        public final Builder iFrameOnlyPlaylists(String iFrameOnlyPlaylists) {
            this.iFrameOnlyPlaylists = iFrameOnlyPlaylists;
            return this;
        }

        @Override
        @Transient
        public final Builder iFrameOnlyPlaylists(IFrameOnlyPlaylistType iFrameOnlyPlaylists) {
            this.iFrameOnlyPlaylists(iFrameOnlyPlaylists == null ? null : iFrameOnlyPlaylists.toString());
            return this;
        }

        public final String getIncompleteSegmentBehavior() {
            return this.incompleteSegmentBehavior;
        }

        public final void setIncompleteSegmentBehavior(String incompleteSegmentBehavior) {
            this.incompleteSegmentBehavior = incompleteSegmentBehavior;
        }

        @Override
        @Transient
        public final Builder incompleteSegmentBehavior(String incompleteSegmentBehavior) {
            this.incompleteSegmentBehavior = incompleteSegmentBehavior;
            return this;
        }

        @Override
        @Transient
        public final Builder incompleteSegmentBehavior(HlsIncompleteSegmentBehavior incompleteSegmentBehavior) {
            this.incompleteSegmentBehavior(incompleteSegmentBehavior == null ? null : incompleteSegmentBehavior.toString());
            return this;
        }

        public final Integer getIndexNSegments() {
            return this.indexNSegments;
        }

        public final void setIndexNSegments(Integer indexNSegments) {
            this.indexNSegments = indexNSegments;
        }

        @Override
        @Transient
        public final Builder indexNSegments(Integer indexNSegments) {
            this.indexNSegments = indexNSegments;
            return this;
        }

        public final String getInputLossAction() {
            return this.inputLossAction;
        }

        public final void setInputLossAction(String inputLossAction) {
            this.inputLossAction = inputLossAction;
        }

        @Override
        @Transient
        public final Builder inputLossAction(String inputLossAction) {
            this.inputLossAction = inputLossAction;
            return this;
        }

        @Override
        @Transient
        public final Builder inputLossAction(InputLossActionForHlsOut inputLossAction) {
            this.inputLossAction(inputLossAction == null ? null : inputLossAction.toString());
            return this;
        }

        public final String getIvInManifest() {
            return this.ivInManifest;
        }

        public final void setIvInManifest(String ivInManifest) {
            this.ivInManifest = ivInManifest;
        }

        @Override
        @Transient
        public final Builder ivInManifest(String ivInManifest) {
            this.ivInManifest = ivInManifest;
            return this;
        }

        @Override
        @Transient
        public final Builder ivInManifest(HlsIvInManifest ivInManifest) {
            this.ivInManifest(ivInManifest == null ? null : ivInManifest.toString());
            return this;
        }

        public final String getIvSource() {
            return this.ivSource;
        }

        public final void setIvSource(String ivSource) {
            this.ivSource = ivSource;
        }

        @Override
        @Transient
        public final Builder ivSource(String ivSource) {
            this.ivSource = ivSource;
            return this;
        }

        @Override
        @Transient
        public final Builder ivSource(HlsIvSource ivSource) {
            this.ivSource(ivSource == null ? null : ivSource.toString());
            return this;
        }

        public final Integer getKeepSegments() {
            return this.keepSegments;
        }

        public final void setKeepSegments(Integer keepSegments) {
            this.keepSegments = keepSegments;
        }

        @Override
        @Transient
        public final Builder keepSegments(Integer keepSegments) {
            this.keepSegments = keepSegments;
            return this;
        }

        public final String getKeyFormat() {
            return this.keyFormat;
        }

        public final void setKeyFormat(String keyFormat) {
            this.keyFormat = keyFormat;
        }

        @Override
        @Transient
        public final Builder keyFormat(String keyFormat) {
            this.keyFormat = keyFormat;
            return this;
        }

        public final String getKeyFormatVersions() {
            return this.keyFormatVersions;
        }

        public final void setKeyFormatVersions(String keyFormatVersions) {
            this.keyFormatVersions = keyFormatVersions;
        }

        @Override
        @Transient
        public final Builder keyFormatVersions(String keyFormatVersions) {
            this.keyFormatVersions = keyFormatVersions;
            return this;
        }

        public final KeyProviderSettings.Builder getKeyProviderSettings() {
            return this.keyProviderSettings != null ? this.keyProviderSettings.toBuilder() : null;
        }

        public final void setKeyProviderSettings(KeyProviderSettings.BuilderImpl keyProviderSettings) {
            this.keyProviderSettings = keyProviderSettings != null ? keyProviderSettings.build() : null;
        }

        @Override
        @Transient
        public final Builder keyProviderSettings(KeyProviderSettings keyProviderSettings) {
            this.keyProviderSettings = keyProviderSettings;
            return this;
        }

        public final String getManifestCompression() {
            return this.manifestCompression;
        }

        public final void setManifestCompression(String manifestCompression) {
            this.manifestCompression = manifestCompression;
        }

        @Override
        @Transient
        public final Builder manifestCompression(String manifestCompression) {
            this.manifestCompression = manifestCompression;
            return this;
        }

        @Override
        @Transient
        public final Builder manifestCompression(HlsManifestCompression manifestCompression) {
            this.manifestCompression(manifestCompression == null ? null : manifestCompression.toString());
            return this;
        }

        public final String getManifestDurationFormat() {
            return this.manifestDurationFormat;
        }

        public final void setManifestDurationFormat(String manifestDurationFormat) {
            this.manifestDurationFormat = manifestDurationFormat;
        }

        @Override
        @Transient
        public final Builder manifestDurationFormat(String manifestDurationFormat) {
            this.manifestDurationFormat = manifestDurationFormat;
            return this;
        }

        @Override
        @Transient
        public final Builder manifestDurationFormat(HlsManifestDurationFormat manifestDurationFormat) {
            this.manifestDurationFormat(manifestDurationFormat == null ? null : manifestDurationFormat.toString());
            return this;
        }

        public final Integer getMinSegmentLength() {
            return this.minSegmentLength;
        }

        public final void setMinSegmentLength(Integer minSegmentLength) {
            this.minSegmentLength = minSegmentLength;
        }

        @Override
        @Transient
        public final Builder minSegmentLength(Integer minSegmentLength) {
            this.minSegmentLength = minSegmentLength;
            return this;
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        @Transient
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        @Transient
        public final Builder mode(HlsMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final String getOutputSelection() {
            return this.outputSelection;
        }

        public final void setOutputSelection(String outputSelection) {
            this.outputSelection = outputSelection;
        }

        @Override
        @Transient
        public final Builder outputSelection(String outputSelection) {
            this.outputSelection = outputSelection;
            return this;
        }

        @Override
        @Transient
        public final Builder outputSelection(HlsOutputSelection outputSelection) {
            this.outputSelection(outputSelection == null ? null : outputSelection.toString());
            return this;
        }

        public final String getProgramDateTime() {
            return this.programDateTime;
        }

        public final void setProgramDateTime(String programDateTime) {
            this.programDateTime = programDateTime;
        }

        @Override
        @Transient
        public final Builder programDateTime(String programDateTime) {
            this.programDateTime = programDateTime;
            return this;
        }

        @Override
        @Transient
        public final Builder programDateTime(HlsProgramDateTime programDateTime) {
            this.programDateTime(programDateTime == null ? null : programDateTime.toString());
            return this;
        }

        public final Integer getProgramDateTimePeriod() {
            return this.programDateTimePeriod;
        }

        public final void setProgramDateTimePeriod(Integer programDateTimePeriod) {
            this.programDateTimePeriod = programDateTimePeriod;
        }

        @Override
        @Transient
        public final Builder programDateTimePeriod(Integer programDateTimePeriod) {
            this.programDateTimePeriod = programDateTimePeriod;
            return this;
        }

        public final String getRedundantManifest() {
            return this.redundantManifest;
        }

        public final void setRedundantManifest(String redundantManifest) {
            this.redundantManifest = redundantManifest;
        }

        @Override
        @Transient
        public final Builder redundantManifest(String redundantManifest) {
            this.redundantManifest = redundantManifest;
            return this;
        }

        @Override
        @Transient
        public final Builder redundantManifest(HlsRedundantManifest redundantManifest) {
            this.redundantManifest(redundantManifest == null ? null : redundantManifest.toString());
            return this;
        }

        public final Integer getSegmentLength() {
            return this.segmentLength;
        }

        public final void setSegmentLength(Integer segmentLength) {
            this.segmentLength = segmentLength;
        }

        @Override
        @Transient
        public final Builder segmentLength(Integer segmentLength) {
            this.segmentLength = segmentLength;
            return this;
        }

        public final String getSegmentationMode() {
            return this.segmentationMode;
        }

        public final void setSegmentationMode(String segmentationMode) {
            this.segmentationMode = segmentationMode;
        }

        @Override
        @Transient
        public final Builder segmentationMode(String segmentationMode) {
            this.segmentationMode = segmentationMode;
            return this;
        }

        @Override
        @Transient
        public final Builder segmentationMode(HlsSegmentationMode segmentationMode) {
            this.segmentationMode(segmentationMode == null ? null : segmentationMode.toString());
            return this;
        }

        public final Integer getSegmentsPerSubdirectory() {
            return this.segmentsPerSubdirectory;
        }

        public final void setSegmentsPerSubdirectory(Integer segmentsPerSubdirectory) {
            this.segmentsPerSubdirectory = segmentsPerSubdirectory;
        }

        @Override
        @Transient
        public final Builder segmentsPerSubdirectory(Integer segmentsPerSubdirectory) {
            this.segmentsPerSubdirectory = segmentsPerSubdirectory;
            return this;
        }

        public final String getStreamInfResolution() {
            return this.streamInfResolution;
        }

        public final void setStreamInfResolution(String streamInfResolution) {
            this.streamInfResolution = streamInfResolution;
        }

        @Override
        @Transient
        public final Builder streamInfResolution(String streamInfResolution) {
            this.streamInfResolution = streamInfResolution;
            return this;
        }

        @Override
        @Transient
        public final Builder streamInfResolution(HlsStreamInfResolution streamInfResolution) {
            this.streamInfResolution(streamInfResolution == null ? null : streamInfResolution.toString());
            return this;
        }

        public final String getTimedMetadataId3Frame() {
            return this.timedMetadataId3Frame;
        }

        public final void setTimedMetadataId3Frame(String timedMetadataId3Frame) {
            this.timedMetadataId3Frame = timedMetadataId3Frame;
        }

        @Override
        @Transient
        public final Builder timedMetadataId3Frame(String timedMetadataId3Frame) {
            this.timedMetadataId3Frame = timedMetadataId3Frame;
            return this;
        }

        @Override
        @Transient
        public final Builder timedMetadataId3Frame(HlsTimedMetadataId3Frame timedMetadataId3Frame) {
            this.timedMetadataId3Frame(timedMetadataId3Frame == null ? null : timedMetadataId3Frame.toString());
            return this;
        }

        public final Integer getTimedMetadataId3Period() {
            return this.timedMetadataId3Period;
        }

        public final void setTimedMetadataId3Period(Integer timedMetadataId3Period) {
            this.timedMetadataId3Period = timedMetadataId3Period;
        }

        @Override
        @Transient
        public final Builder timedMetadataId3Period(Integer timedMetadataId3Period) {
            this.timedMetadataId3Period = timedMetadataId3Period;
            return this;
        }

        public final Integer getTimestampDeltaMilliseconds() {
            return this.timestampDeltaMilliseconds;
        }

        public final void setTimestampDeltaMilliseconds(Integer timestampDeltaMilliseconds) {
            this.timestampDeltaMilliseconds = timestampDeltaMilliseconds;
        }

        @Override
        @Transient
        public final Builder timestampDeltaMilliseconds(Integer timestampDeltaMilliseconds) {
            this.timestampDeltaMilliseconds = timestampDeltaMilliseconds;
            return this;
        }

        public final String getTsFileMode() {
            return this.tsFileMode;
        }

        public final void setTsFileMode(String tsFileMode) {
            this.tsFileMode = tsFileMode;
        }

        @Override
        @Transient
        public final Builder tsFileMode(String tsFileMode) {
            this.tsFileMode = tsFileMode;
            return this;
        }

        @Override
        @Transient
        public final Builder tsFileMode(HlsTsFileMode tsFileMode) {
            this.tsFileMode(tsFileMode == null ? null : tsFileMode.toString());
            return this;
        }

        public HlsGroupSettings build() {
            return new HlsGroupSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HlsGroupSettings> {
        public Builder adMarkersWithStrings(Collection<String> var1);

        public Builder adMarkersWithStrings(String ... var1);

        public Builder adMarkers(Collection<HlsAdMarkers> var1);

        public Builder adMarkers(HlsAdMarkers ... var1);

        public Builder baseUrlContent(String var1);

        public Builder baseUrlContent1(String var1);

        public Builder baseUrlManifest(String var1);

        public Builder baseUrlManifest1(String var1);

        public Builder captionLanguageMappings(Collection<CaptionLanguageMapping> var1);

        public Builder captionLanguageMappings(CaptionLanguageMapping ... var1);

        public Builder captionLanguageMappings(Consumer<CaptionLanguageMapping.Builder> ... var1);

        public Builder captionLanguageSetting(String var1);

        public Builder captionLanguageSetting(HlsCaptionLanguageSetting var1);

        public Builder clientCache(String var1);

        public Builder clientCache(HlsClientCache var1);

        public Builder codecSpecification(String var1);

        public Builder codecSpecification(HlsCodecSpecification var1);

        public Builder constantIv(String var1);

        public Builder destination(OutputLocationRef var1);

        default public Builder destination(Consumer<OutputLocationRef.Builder> destination) {
            return this.destination((OutputLocationRef)((OutputLocationRef.Builder)OutputLocationRef.builder().applyMutation(destination)).build());
        }

        public Builder directoryStructure(String var1);

        public Builder directoryStructure(HlsDirectoryStructure var1);

        public Builder discontinuityTags(String var1);

        public Builder discontinuityTags(HlsDiscontinuityTags var1);

        public Builder encryptionType(String var1);

        public Builder encryptionType(HlsEncryptionType var1);

        public Builder hlsCdnSettings(HlsCdnSettings var1);

        default public Builder hlsCdnSettings(Consumer<HlsCdnSettings.Builder> hlsCdnSettings) {
            return this.hlsCdnSettings((HlsCdnSettings)((HlsCdnSettings.Builder)HlsCdnSettings.builder().applyMutation(hlsCdnSettings)).build());
        }

        public Builder hlsId3SegmentTagging(String var1);

        public Builder hlsId3SegmentTagging(HlsId3SegmentTaggingState var1);

        public Builder iFrameOnlyPlaylists(String var1);

        public Builder iFrameOnlyPlaylists(IFrameOnlyPlaylistType var1);

        public Builder incompleteSegmentBehavior(String var1);

        public Builder incompleteSegmentBehavior(HlsIncompleteSegmentBehavior var1);

        public Builder indexNSegments(Integer var1);

        public Builder inputLossAction(String var1);

        public Builder inputLossAction(InputLossActionForHlsOut var1);

        public Builder ivInManifest(String var1);

        public Builder ivInManifest(HlsIvInManifest var1);

        public Builder ivSource(String var1);

        public Builder ivSource(HlsIvSource var1);

        public Builder keepSegments(Integer var1);

        public Builder keyFormat(String var1);

        public Builder keyFormatVersions(String var1);

        public Builder keyProviderSettings(KeyProviderSettings var1);

        default public Builder keyProviderSettings(Consumer<KeyProviderSettings.Builder> keyProviderSettings) {
            return this.keyProviderSettings((KeyProviderSettings)((KeyProviderSettings.Builder)KeyProviderSettings.builder().applyMutation(keyProviderSettings)).build());
        }

        public Builder manifestCompression(String var1);

        public Builder manifestCompression(HlsManifestCompression var1);

        public Builder manifestDurationFormat(String var1);

        public Builder manifestDurationFormat(HlsManifestDurationFormat var1);

        public Builder minSegmentLength(Integer var1);

        public Builder mode(String var1);

        public Builder mode(HlsMode var1);

        public Builder outputSelection(String var1);

        public Builder outputSelection(HlsOutputSelection var1);

        public Builder programDateTime(String var1);

        public Builder programDateTime(HlsProgramDateTime var1);

        public Builder programDateTimePeriod(Integer var1);

        public Builder redundantManifest(String var1);

        public Builder redundantManifest(HlsRedundantManifest var1);

        public Builder segmentLength(Integer var1);

        public Builder segmentationMode(String var1);

        public Builder segmentationMode(HlsSegmentationMode var1);

        public Builder segmentsPerSubdirectory(Integer var1);

        public Builder streamInfResolution(String var1);

        public Builder streamInfResolution(HlsStreamInfResolution var1);

        public Builder timedMetadataId3Frame(String var1);

        public Builder timedMetadataId3Frame(HlsTimedMetadataId3Frame var1);

        public Builder timedMetadataId3Period(Integer var1);

        public Builder timestampDeltaMilliseconds(Integer var1);

        public Builder tsFileMode(String var1);

        public Builder tsFileMode(HlsTsFileMode var1);
    }
}

