/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum HlsH265PackagingType {
    HEV1("HEV1"),
    HVC1("HVC1"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, HlsH265PackagingType> VALUE_MAP;
    private final String value;

    private HlsH265PackagingType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HlsH265PackagingType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HlsH265PackagingType> knownValues() {
        EnumSet<HlsH265PackagingType> knownValues = EnumSet.allOf(HlsH265PackagingType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(HlsH265PackagingType.class, HlsH265PackagingType::toString);
    }
}

