/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.MediaLiveResponse;
import software.amazon.awssdk.services.medialive.model.MultiplexProgramPacketIdentifiersMap;
import software.amazon.awssdk.services.medialive.model.MultiplexProgramPipelineDetail;
import software.amazon.awssdk.services.medialive.model.MultiplexProgramSettings;
import software.amazon.awssdk.services.medialive.model.___listOfMultiplexProgramPipelineDetailCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeMultiplexProgramResponse
extends MediaLiveResponse
implements ToCopyableBuilder<Builder, DescribeMultiplexProgramResponse> {
    private static final SdkField<String> CHANNEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelId").getter(DescribeMultiplexProgramResponse.getter(DescribeMultiplexProgramResponse::channelId)).setter(DescribeMultiplexProgramResponse.setter(Builder::channelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelId").build()}).build();
    private static final SdkField<MultiplexProgramSettings> MULTIPLEX_PROGRAM_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MultiplexProgramSettings").getter(DescribeMultiplexProgramResponse.getter(DescribeMultiplexProgramResponse::multiplexProgramSettings)).setter(DescribeMultiplexProgramResponse.setter(Builder::multiplexProgramSettings)).constructor(MultiplexProgramSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiplexProgramSettings").build()}).build();
    private static final SdkField<MultiplexProgramPacketIdentifiersMap> PACKET_IDENTIFIERS_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PacketIdentifiersMap").getter(DescribeMultiplexProgramResponse.getter(DescribeMultiplexProgramResponse::packetIdentifiersMap)).setter(DescribeMultiplexProgramResponse.setter(Builder::packetIdentifiersMap)).constructor(MultiplexProgramPacketIdentifiersMap::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packetIdentifiersMap").build()}).build();
    private static final SdkField<List<MultiplexProgramPipelineDetail>> PIPELINE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PipelineDetails").getter(DescribeMultiplexProgramResponse.getter(DescribeMultiplexProgramResponse::pipelineDetails)).setter(DescribeMultiplexProgramResponse.setter(Builder::pipelineDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MultiplexProgramPipelineDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PROGRAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProgramName").getter(DescribeMultiplexProgramResponse.getter(DescribeMultiplexProgramResponse::programName)).setter(DescribeMultiplexProgramResponse.setter(Builder::programName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ID_FIELD, MULTIPLEX_PROGRAM_SETTINGS_FIELD, PACKET_IDENTIFIERS_MAP_FIELD, PIPELINE_DETAILS_FIELD, PROGRAM_NAME_FIELD));
    private final String channelId;
    private final MultiplexProgramSettings multiplexProgramSettings;
    private final MultiplexProgramPacketIdentifiersMap packetIdentifiersMap;
    private final List<MultiplexProgramPipelineDetail> pipelineDetails;
    private final String programName;

    private DescribeMultiplexProgramResponse(BuilderImpl builder) {
        super(builder);
        this.channelId = builder.channelId;
        this.multiplexProgramSettings = builder.multiplexProgramSettings;
        this.packetIdentifiersMap = builder.packetIdentifiersMap;
        this.pipelineDetails = builder.pipelineDetails;
        this.programName = builder.programName;
    }

    public final String channelId() {
        return this.channelId;
    }

    public final MultiplexProgramSettings multiplexProgramSettings() {
        return this.multiplexProgramSettings;
    }

    public final MultiplexProgramPacketIdentifiersMap packetIdentifiersMap() {
        return this.packetIdentifiersMap;
    }

    public final boolean hasPipelineDetails() {
        return this.pipelineDetails != null && !(this.pipelineDetails instanceof SdkAutoConstructList);
    }

    public final List<MultiplexProgramPipelineDetail> pipelineDetails() {
        return this.pipelineDetails;
    }

    public final String programName() {
        return this.programName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiplexProgramSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.packetIdentifiersMap());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPipelineDetails() ? this.pipelineDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.programName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMultiplexProgramResponse)) {
            return false;
        }
        DescribeMultiplexProgramResponse other = (DescribeMultiplexProgramResponse)((Object)obj);
        return Objects.equals(this.channelId(), other.channelId()) && Objects.equals(this.multiplexProgramSettings(), other.multiplexProgramSettings()) && Objects.equals(this.packetIdentifiersMap(), other.packetIdentifiersMap()) && this.hasPipelineDetails() == other.hasPipelineDetails() && Objects.equals(this.pipelineDetails(), other.pipelineDetails()) && Objects.equals(this.programName(), other.programName());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeMultiplexProgramResponse").add("ChannelId", (Object)this.channelId()).add("MultiplexProgramSettings", (Object)this.multiplexProgramSettings()).add("PacketIdentifiersMap", (Object)this.packetIdentifiersMap()).add("PipelineDetails", this.hasPipelineDetails() ? this.pipelineDetails() : null).add("ProgramName", (Object)this.programName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelId": {
                return Optional.ofNullable(clazz.cast(this.channelId()));
            }
            case "MultiplexProgramSettings": {
                return Optional.ofNullable(clazz.cast(this.multiplexProgramSettings()));
            }
            case "PacketIdentifiersMap": {
                return Optional.ofNullable(clazz.cast(this.packetIdentifiersMap()));
            }
            case "PipelineDetails": {
                return Optional.ofNullable(clazz.cast(this.pipelineDetails()));
            }
            case "ProgramName": {
                return Optional.ofNullable(clazz.cast(this.programName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeMultiplexProgramResponse, T> g) {
        return obj -> g.apply((DescribeMultiplexProgramResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveResponse.BuilderImpl
    implements Builder {
        private String channelId;
        private MultiplexProgramSettings multiplexProgramSettings;
        private MultiplexProgramPacketIdentifiersMap packetIdentifiersMap;
        private List<MultiplexProgramPipelineDetail> pipelineDetails = DefaultSdkAutoConstructList.getInstance();
        private String programName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMultiplexProgramResponse model) {
            super(model);
            this.channelId(model.channelId);
            this.multiplexProgramSettings(model.multiplexProgramSettings);
            this.packetIdentifiersMap(model.packetIdentifiersMap);
            this.pipelineDetails(model.pipelineDetails);
            this.programName(model.programName);
        }

        public final String getChannelId() {
            return this.channelId;
        }

        public final void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @Override
        public final Builder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public final MultiplexProgramSettings.Builder getMultiplexProgramSettings() {
            return this.multiplexProgramSettings != null ? this.multiplexProgramSettings.toBuilder() : null;
        }

        public final void setMultiplexProgramSettings(MultiplexProgramSettings.BuilderImpl multiplexProgramSettings) {
            this.multiplexProgramSettings = multiplexProgramSettings != null ? multiplexProgramSettings.build() : null;
        }

        @Override
        public final Builder multiplexProgramSettings(MultiplexProgramSettings multiplexProgramSettings) {
            this.multiplexProgramSettings = multiplexProgramSettings;
            return this;
        }

        public final MultiplexProgramPacketIdentifiersMap.Builder getPacketIdentifiersMap() {
            return this.packetIdentifiersMap != null ? this.packetIdentifiersMap.toBuilder() : null;
        }

        public final void setPacketIdentifiersMap(MultiplexProgramPacketIdentifiersMap.BuilderImpl packetIdentifiersMap) {
            this.packetIdentifiersMap = packetIdentifiersMap != null ? packetIdentifiersMap.build() : null;
        }

        @Override
        public final Builder packetIdentifiersMap(MultiplexProgramPacketIdentifiersMap packetIdentifiersMap) {
            this.packetIdentifiersMap = packetIdentifiersMap;
            return this;
        }

        public final List<MultiplexProgramPipelineDetail.Builder> getPipelineDetails() {
            List<MultiplexProgramPipelineDetail.Builder> result = ___listOfMultiplexProgramPipelineDetailCopier.copyToBuilder(this.pipelineDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPipelineDetails(Collection<MultiplexProgramPipelineDetail.BuilderImpl> pipelineDetails) {
            this.pipelineDetails = ___listOfMultiplexProgramPipelineDetailCopier.copyFromBuilder(pipelineDetails);
        }

        @Override
        public final Builder pipelineDetails(Collection<MultiplexProgramPipelineDetail> pipelineDetails) {
            this.pipelineDetails = ___listOfMultiplexProgramPipelineDetailCopier.copy(pipelineDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineDetails(MultiplexProgramPipelineDetail ... pipelineDetails) {
            this.pipelineDetails(Arrays.asList(pipelineDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineDetails(Consumer<MultiplexProgramPipelineDetail.Builder> ... pipelineDetails) {
            this.pipelineDetails(Stream.of(pipelineDetails).map(c -> (MultiplexProgramPipelineDetail)((MultiplexProgramPipelineDetail.Builder)MultiplexProgramPipelineDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getProgramName() {
            return this.programName;
        }

        public final void setProgramName(String programName) {
            this.programName = programName;
        }

        @Override
        public final Builder programName(String programName) {
            this.programName = programName;
            return this;
        }

        @Override
        public DescribeMultiplexProgramResponse build() {
            return new DescribeMultiplexProgramResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaLiveResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeMultiplexProgramResponse> {
        public Builder channelId(String var1);

        public Builder multiplexProgramSettings(MultiplexProgramSettings var1);

        default public Builder multiplexProgramSettings(Consumer<MultiplexProgramSettings.Builder> multiplexProgramSettings) {
            return this.multiplexProgramSettings((MultiplexProgramSettings)((MultiplexProgramSettings.Builder)MultiplexProgramSettings.builder().applyMutation(multiplexProgramSettings)).build());
        }

        public Builder packetIdentifiersMap(MultiplexProgramPacketIdentifiersMap var1);

        default public Builder packetIdentifiersMap(Consumer<MultiplexProgramPacketIdentifiersMap.Builder> packetIdentifiersMap) {
            return this.packetIdentifiersMap((MultiplexProgramPacketIdentifiersMap)((MultiplexProgramPacketIdentifiersMap.Builder)MultiplexProgramPacketIdentifiersMap.builder().applyMutation(packetIdentifiersMap)).build());
        }

        public Builder pipelineDetails(Collection<MultiplexProgramPipelineDetail> var1);

        public Builder pipelineDetails(MultiplexProgramPipelineDetail ... var1);

        public Builder pipelineDetails(Consumer<MultiplexProgramPipelineDetail.Builder> ... var1);

        public Builder programName(String var1);
    }
}

