/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.InputClippingSettings;
import software.amazon.awssdk.services.medialive.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InputPrepareScheduleActionSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InputPrepareScheduleActionSettings> {
    private static final SdkField<String> INPUT_ATTACHMENT_NAME_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputAttachmentNameReference").getter(InputPrepareScheduleActionSettings.getter(InputPrepareScheduleActionSettings::inputAttachmentNameReference)).setter(InputPrepareScheduleActionSettings.setter(Builder::inputAttachmentNameReference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputAttachmentNameReference").build()}).build();
    private static final SdkField<InputClippingSettings> INPUT_CLIPPING_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InputClippingSettings").getter(InputPrepareScheduleActionSettings.getter(InputPrepareScheduleActionSettings::inputClippingSettings)).setter(InputPrepareScheduleActionSettings.setter(Builder::inputClippingSettings)).constructor(InputClippingSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputClippingSettings").build()}).build();
    private static final SdkField<List<String>> URL_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UrlPath").getter(InputPrepareScheduleActionSettings.getter(InputPrepareScheduleActionSettings::urlPath)).setter(InputPrepareScheduleActionSettings.setter(Builder::urlPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("urlPath").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_ATTACHMENT_NAME_REFERENCE_FIELD, INPUT_CLIPPING_SETTINGS_FIELD, URL_PATH_FIELD));
    private static final long serialVersionUID = 1L;
    private final String inputAttachmentNameReference;
    private final InputClippingSettings inputClippingSettings;
    private final List<String> urlPath;

    private InputPrepareScheduleActionSettings(BuilderImpl builder) {
        this.inputAttachmentNameReference = builder.inputAttachmentNameReference;
        this.inputClippingSettings = builder.inputClippingSettings;
        this.urlPath = builder.urlPath;
    }

    public final String inputAttachmentNameReference() {
        return this.inputAttachmentNameReference;
    }

    public final InputClippingSettings inputClippingSettings() {
        return this.inputClippingSettings;
    }

    public final boolean hasUrlPath() {
        return this.urlPath != null && !(this.urlPath instanceof SdkAutoConstructList);
    }

    public final List<String> urlPath() {
        return this.urlPath;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.inputAttachmentNameReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputClippingSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUrlPath() ? this.urlPath() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputPrepareScheduleActionSettings)) {
            return false;
        }
        InputPrepareScheduleActionSettings other = (InputPrepareScheduleActionSettings)obj;
        return Objects.equals(this.inputAttachmentNameReference(), other.inputAttachmentNameReference()) && Objects.equals(this.inputClippingSettings(), other.inputClippingSettings()) && this.hasUrlPath() == other.hasUrlPath() && Objects.equals(this.urlPath(), other.urlPath());
    }

    public final String toString() {
        return ToString.builder((String)"InputPrepareScheduleActionSettings").add("InputAttachmentNameReference", (Object)this.inputAttachmentNameReference()).add("InputClippingSettings", (Object)this.inputClippingSettings()).add("UrlPath", this.hasUrlPath() ? this.urlPath() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InputAttachmentNameReference": {
                return Optional.ofNullable(clazz.cast(this.inputAttachmentNameReference()));
            }
            case "InputClippingSettings": {
                return Optional.ofNullable(clazz.cast(this.inputClippingSettings()));
            }
            case "UrlPath": {
                return Optional.ofNullable(clazz.cast(this.urlPath()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputPrepareScheduleActionSettings, T> g) {
        return obj -> g.apply((InputPrepareScheduleActionSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String inputAttachmentNameReference;
        private InputClippingSettings inputClippingSettings;
        private List<String> urlPath = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InputPrepareScheduleActionSettings model) {
            this.inputAttachmentNameReference(model.inputAttachmentNameReference);
            this.inputClippingSettings(model.inputClippingSettings);
            this.urlPath(model.urlPath);
        }

        public final String getInputAttachmentNameReference() {
            return this.inputAttachmentNameReference;
        }

        public final void setInputAttachmentNameReference(String inputAttachmentNameReference) {
            this.inputAttachmentNameReference = inputAttachmentNameReference;
        }

        @Override
        @Transient
        public final Builder inputAttachmentNameReference(String inputAttachmentNameReference) {
            this.inputAttachmentNameReference = inputAttachmentNameReference;
            return this;
        }

        public final InputClippingSettings.Builder getInputClippingSettings() {
            return this.inputClippingSettings != null ? this.inputClippingSettings.toBuilder() : null;
        }

        public final void setInputClippingSettings(InputClippingSettings.BuilderImpl inputClippingSettings) {
            this.inputClippingSettings = inputClippingSettings != null ? inputClippingSettings.build() : null;
        }

        @Override
        @Transient
        public final Builder inputClippingSettings(InputClippingSettings inputClippingSettings) {
            this.inputClippingSettings = inputClippingSettings;
            return this;
        }

        public final Collection<String> getUrlPath() {
            if (this.urlPath instanceof SdkAutoConstructList) {
                return null;
            }
            return this.urlPath;
        }

        public final void setUrlPath(Collection<String> urlPath) {
            this.urlPath = ___listOf__stringCopier.copy(urlPath);
        }

        @Override
        @Transient
        public final Builder urlPath(Collection<String> urlPath) {
            this.urlPath = ___listOf__stringCopier.copy(urlPath);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder urlPath(String ... urlPath) {
            this.urlPath(Arrays.asList(urlPath));
            return this;
        }

        public InputPrepareScheduleActionSettings build() {
            return new InputPrepareScheduleActionSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InputPrepareScheduleActionSettings> {
        public Builder inputAttachmentNameReference(String var1);

        public Builder inputClippingSettings(InputClippingSettings var1);

        default public Builder inputClippingSettings(Consumer<InputClippingSettings.Builder> inputClippingSettings) {
            return this.inputClippingSettings((InputClippingSettings)((InputClippingSettings.Builder)InputClippingSettings.builder().applyMutation(inputClippingSettings)).build());
        }

        public Builder urlPath(Collection<String> var1);

        public Builder urlPath(String ... var1);
    }
}

