/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.medialive.MediaLiveClient;
import software.amazon.awssdk.services.medialive.model.ListInputDeviceTransfersRequest;
import software.amazon.awssdk.services.medialive.model.ListInputDeviceTransfersResponse;
import software.amazon.awssdk.services.medialive.model.TransferringInputDeviceSummary;

public class ListInputDeviceTransfersIterable
implements SdkIterable<ListInputDeviceTransfersResponse> {
    private final MediaLiveClient client;
    private final ListInputDeviceTransfersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListInputDeviceTransfersIterable(MediaLiveClient client, ListInputDeviceTransfersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListInputDeviceTransfersResponseFetcher();
    }

    public Iterator<ListInputDeviceTransfersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TransferringInputDeviceSummary> inputDeviceTransfers() {
        Function<ListInputDeviceTransfersResponse, Iterator> getIterator = response -> {
            if (response != null && response.inputDeviceTransfers() != null) {
                return response.inputDeviceTransfers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListInputDeviceTransfersResponseFetcher
    implements SyncPageFetcher<ListInputDeviceTransfersResponse> {
        private ListInputDeviceTransfersResponseFetcher() {
        }

        public boolean hasNextPage(ListInputDeviceTransfersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListInputDeviceTransfersResponse nextPage(ListInputDeviceTransfersResponse previousPage) {
            if (previousPage == null) {
                return ListInputDeviceTransfersIterable.this.client.listInputDeviceTransfers(ListInputDeviceTransfersIterable.this.firstRequest);
            }
            return ListInputDeviceTransfersIterable.this.client.listInputDeviceTransfers((ListInputDeviceTransfersRequest)((Object)ListInputDeviceTransfersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

