/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.medialive.MediaLiveAsyncClient;
import software.amazon.awssdk.services.medialive.model.InputDeviceSummary;
import software.amazon.awssdk.services.medialive.model.ListInputDevicesRequest;
import software.amazon.awssdk.services.medialive.model.ListInputDevicesResponse;

public class ListInputDevicesPublisher
implements SdkPublisher<ListInputDevicesResponse> {
    private final MediaLiveAsyncClient client;
    private final ListInputDevicesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListInputDevicesPublisher(MediaLiveAsyncClient client, ListInputDevicesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListInputDevicesPublisher(MediaLiveAsyncClient client, ListInputDevicesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListInputDevicesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListInputDevicesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<InputDeviceSummary> inputDevices() {
        Function<ListInputDevicesResponse, Iterator> getIterator = response -> {
            if (response != null && response.inputDevices() != null) {
                return response.inputDevices().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListInputDevicesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListInputDevicesResponseFetcher
    implements AsyncPageFetcher<ListInputDevicesResponse> {
        private ListInputDevicesResponseFetcher() {
        }

        public boolean hasNextPage(ListInputDevicesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListInputDevicesResponse> nextPage(ListInputDevicesResponse previousPage) {
            if (previousPage == null) {
                return ListInputDevicesPublisher.this.client.listInputDevices(ListInputDevicesPublisher.this.firstRequest);
            }
            return ListInputDevicesPublisher.this.client.listInputDevices((ListInputDevicesRequest)((Object)ListInputDevicesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

