/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.InputLossActionForMsSmoothOut;
import software.amazon.awssdk.services.medialive.model.OutputLocationRef;
import software.amazon.awssdk.services.medialive.model.SmoothGroupAudioOnlyTimecodeControl;
import software.amazon.awssdk.services.medialive.model.SmoothGroupCertificateMode;
import software.amazon.awssdk.services.medialive.model.SmoothGroupEventIdMode;
import software.amazon.awssdk.services.medialive.model.SmoothGroupEventStopBehavior;
import software.amazon.awssdk.services.medialive.model.SmoothGroupSegmentationMode;
import software.amazon.awssdk.services.medialive.model.SmoothGroupSparseTrackType;
import software.amazon.awssdk.services.medialive.model.SmoothGroupStreamManifestBehavior;
import software.amazon.awssdk.services.medialive.model.SmoothGroupTimestampOffsetMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MsSmoothGroupSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MsSmoothGroupSettings> {
    private static final SdkField<String> ACQUISITION_POINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AcquisitionPointId").getter(MsSmoothGroupSettings.getter(MsSmoothGroupSettings::acquisitionPointId)).setter(MsSmoothGroupSettings.setter(Builder::acquisitionPointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acquisitionPointId").build()}).build();
    private static final SdkField<String> AUDIO_ONLY_TIMECODE_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AudioOnlyTimecodeControl").getter(MsSmoothGroupSettings.getter(MsSmoothGroupSettings::audioOnlyTimecodeControlAsString)).setter(MsSmoothGroupSettings.setter(Builder::audioOnlyTimecodeControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioOnlyTimecodeControl").build()}).build();
    private static final SdkField<String> CERTIFICATE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateMode").getter(MsSmoothGroupSettings.getter(MsSmoothGroupSettings::certificateModeAsString)).setter(MsSmoothGroupSettings.setter(Builder::certificateMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateMode").build()}).build();
    private static final SdkField<Integer> CONNECTION_RETRY_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ConnectionRetryInterval").getter(MsSmoothGroupSettings.getter(MsSmoothGroupSettings::connectionRetryInterval)).setter(MsSmoothGroupSettings.setter(Builder::connectionRetryInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionRetryInterval").build()}).build();
    private static final SdkField<OutputLocationRef> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Destination").getter(MsSmoothGroupSettings.getter(MsSmoothGroupSettings::destination)).setter(MsSmoothGroupSettings.setter(Builder::destination)).constructor(OutputLocationRef::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()}).build();
    private static final SdkField<String> EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventId").getter(MsSmoothGroupSettings.getter(MsSmoothGroupSettings::eventId)).setter(MsSmoothGroupSettings.setter(Builder::eventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventId").build()}).build();
    private static final SdkField<String> EVENT_ID_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventIdMode").getter(MsSmoothGroupSettings.getter(MsSmoothGroupSettings::eventIdModeAsString)).setter(MsSmoothGroupSettings.setter(Builder::eventIdMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventIdMode").build()}).build();
    private static final SdkField<String> EVENT_STOP_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventStopBehavior").getter(MsSmoothGroupSettings.getter(MsSmoothGroupSettings::eventStopBehaviorAsString)).setter(MsSmoothGroupSettings.setter(Builder::eventStopBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventStopBehavior").build()}).build();
    private static final SdkField<Integer> FILECACHE_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FilecacheDuration").getter(MsSmoothGroupSettings.getter(MsSmoothGroupSettings::filecacheDuration)).setter(MsSmoothGroupSettings.setter(Builder::filecacheDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filecacheDuration").build()}).build();
    private static final SdkField<Integer> FRAGMENT_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FragmentLength").getter(MsSmoothGroupSettings.getter(MsSmoothGroupSettings::fragmentLength)).setter(MsSmoothGroupSettings.setter(Builder::fragmentLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fragmentLength").build()}).build();
    private static final SdkField<String> INPUT_LOSS_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputLossAction").getter(MsSmoothGroupSettings.getter(MsSmoothGroupSettings::inputLossActionAsString)).setter(MsSmoothGroupSettings.setter(Builder::inputLossAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputLossAction").build()}).build();
    private static final SdkField<Integer> NUM_RETRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumRetries").getter(MsSmoothGroupSettings.getter(MsSmoothGroupSettings::numRetries)).setter(MsSmoothGroupSettings.setter(Builder::numRetries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numRetries").build()}).build();
    private static final SdkField<Integer> RESTART_DELAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RestartDelay").getter(MsSmoothGroupSettings.getter(MsSmoothGroupSettings::restartDelay)).setter(MsSmoothGroupSettings.setter(Builder::restartDelay)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("restartDelay").build()}).build();
    private static final SdkField<String> SEGMENTATION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SegmentationMode").getter(MsSmoothGroupSettings.getter(MsSmoothGroupSettings::segmentationModeAsString)).setter(MsSmoothGroupSettings.setter(Builder::segmentationMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentationMode").build()}).build();
    private static final SdkField<Integer> SEND_DELAY_MS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SendDelayMs").getter(MsSmoothGroupSettings.getter(MsSmoothGroupSettings::sendDelayMs)).setter(MsSmoothGroupSettings.setter(Builder::sendDelayMs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sendDelayMs").build()}).build();
    private static final SdkField<String> SPARSE_TRACK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SparseTrackType").getter(MsSmoothGroupSettings.getter(MsSmoothGroupSettings::sparseTrackTypeAsString)).setter(MsSmoothGroupSettings.setter(Builder::sparseTrackType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sparseTrackType").build()}).build();
    private static final SdkField<String> STREAM_MANIFEST_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamManifestBehavior").getter(MsSmoothGroupSettings.getter(MsSmoothGroupSettings::streamManifestBehaviorAsString)).setter(MsSmoothGroupSettings.setter(Builder::streamManifestBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamManifestBehavior").build()}).build();
    private static final SdkField<String> TIMESTAMP_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimestampOffset").getter(MsSmoothGroupSettings.getter(MsSmoothGroupSettings::timestampOffset)).setter(MsSmoothGroupSettings.setter(Builder::timestampOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestampOffset").build()}).build();
    private static final SdkField<String> TIMESTAMP_OFFSET_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimestampOffsetMode").getter(MsSmoothGroupSettings.getter(MsSmoothGroupSettings::timestampOffsetModeAsString)).setter(MsSmoothGroupSettings.setter(Builder::timestampOffsetMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestampOffsetMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACQUISITION_POINT_ID_FIELD, AUDIO_ONLY_TIMECODE_CONTROL_FIELD, CERTIFICATE_MODE_FIELD, CONNECTION_RETRY_INTERVAL_FIELD, DESTINATION_FIELD, EVENT_ID_FIELD, EVENT_ID_MODE_FIELD, EVENT_STOP_BEHAVIOR_FIELD, FILECACHE_DURATION_FIELD, FRAGMENT_LENGTH_FIELD, INPUT_LOSS_ACTION_FIELD, NUM_RETRIES_FIELD, RESTART_DELAY_FIELD, SEGMENTATION_MODE_FIELD, SEND_DELAY_MS_FIELD, SPARSE_TRACK_TYPE_FIELD, STREAM_MANIFEST_BEHAVIOR_FIELD, TIMESTAMP_OFFSET_FIELD, TIMESTAMP_OFFSET_MODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String acquisitionPointId;
    private final String audioOnlyTimecodeControl;
    private final String certificateMode;
    private final Integer connectionRetryInterval;
    private final OutputLocationRef destination;
    private final String eventId;
    private final String eventIdMode;
    private final String eventStopBehavior;
    private final Integer filecacheDuration;
    private final Integer fragmentLength;
    private final String inputLossAction;
    private final Integer numRetries;
    private final Integer restartDelay;
    private final String segmentationMode;
    private final Integer sendDelayMs;
    private final String sparseTrackType;
    private final String streamManifestBehavior;
    private final String timestampOffset;
    private final String timestampOffsetMode;

    private MsSmoothGroupSettings(BuilderImpl builder) {
        this.acquisitionPointId = builder.acquisitionPointId;
        this.audioOnlyTimecodeControl = builder.audioOnlyTimecodeControl;
        this.certificateMode = builder.certificateMode;
        this.connectionRetryInterval = builder.connectionRetryInterval;
        this.destination = builder.destination;
        this.eventId = builder.eventId;
        this.eventIdMode = builder.eventIdMode;
        this.eventStopBehavior = builder.eventStopBehavior;
        this.filecacheDuration = builder.filecacheDuration;
        this.fragmentLength = builder.fragmentLength;
        this.inputLossAction = builder.inputLossAction;
        this.numRetries = builder.numRetries;
        this.restartDelay = builder.restartDelay;
        this.segmentationMode = builder.segmentationMode;
        this.sendDelayMs = builder.sendDelayMs;
        this.sparseTrackType = builder.sparseTrackType;
        this.streamManifestBehavior = builder.streamManifestBehavior;
        this.timestampOffset = builder.timestampOffset;
        this.timestampOffsetMode = builder.timestampOffsetMode;
    }

    public final String acquisitionPointId() {
        return this.acquisitionPointId;
    }

    public final SmoothGroupAudioOnlyTimecodeControl audioOnlyTimecodeControl() {
        return SmoothGroupAudioOnlyTimecodeControl.fromValue(this.audioOnlyTimecodeControl);
    }

    public final String audioOnlyTimecodeControlAsString() {
        return this.audioOnlyTimecodeControl;
    }

    public final SmoothGroupCertificateMode certificateMode() {
        return SmoothGroupCertificateMode.fromValue(this.certificateMode);
    }

    public final String certificateModeAsString() {
        return this.certificateMode;
    }

    public final Integer connectionRetryInterval() {
        return this.connectionRetryInterval;
    }

    public final OutputLocationRef destination() {
        return this.destination;
    }

    public final String eventId() {
        return this.eventId;
    }

    public final SmoothGroupEventIdMode eventIdMode() {
        return SmoothGroupEventIdMode.fromValue(this.eventIdMode);
    }

    public final String eventIdModeAsString() {
        return this.eventIdMode;
    }

    public final SmoothGroupEventStopBehavior eventStopBehavior() {
        return SmoothGroupEventStopBehavior.fromValue(this.eventStopBehavior);
    }

    public final String eventStopBehaviorAsString() {
        return this.eventStopBehavior;
    }

    public final Integer filecacheDuration() {
        return this.filecacheDuration;
    }

    public final Integer fragmentLength() {
        return this.fragmentLength;
    }

    public final InputLossActionForMsSmoothOut inputLossAction() {
        return InputLossActionForMsSmoothOut.fromValue(this.inputLossAction);
    }

    public final String inputLossActionAsString() {
        return this.inputLossAction;
    }

    public final Integer numRetries() {
        return this.numRetries;
    }

    public final Integer restartDelay() {
        return this.restartDelay;
    }

    public final SmoothGroupSegmentationMode segmentationMode() {
        return SmoothGroupSegmentationMode.fromValue(this.segmentationMode);
    }

    public final String segmentationModeAsString() {
        return this.segmentationMode;
    }

    public final Integer sendDelayMs() {
        return this.sendDelayMs;
    }

    public final SmoothGroupSparseTrackType sparseTrackType() {
        return SmoothGroupSparseTrackType.fromValue(this.sparseTrackType);
    }

    public final String sparseTrackTypeAsString() {
        return this.sparseTrackType;
    }

    public final SmoothGroupStreamManifestBehavior streamManifestBehavior() {
        return SmoothGroupStreamManifestBehavior.fromValue(this.streamManifestBehavior);
    }

    public final String streamManifestBehaviorAsString() {
        return this.streamManifestBehavior;
    }

    public final String timestampOffset() {
        return this.timestampOffset;
    }

    public final SmoothGroupTimestampOffsetMode timestampOffsetMode() {
        return SmoothGroupTimestampOffsetMode.fromValue(this.timestampOffsetMode);
    }

    public final String timestampOffsetModeAsString() {
        return this.timestampOffsetMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.acquisitionPointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioOnlyTimecodeControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionRetryInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventIdModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventStopBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.filecacheDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.fragmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputLossActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.numRetries());
        hashCode = 31 * hashCode + Objects.hashCode(this.restartDelay());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sendDelayMs());
        hashCode = 31 * hashCode + Objects.hashCode(this.sparseTrackTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamManifestBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestampOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestampOffsetModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MsSmoothGroupSettings)) {
            return false;
        }
        MsSmoothGroupSettings other = (MsSmoothGroupSettings)obj;
        return Objects.equals(this.acquisitionPointId(), other.acquisitionPointId()) && Objects.equals(this.audioOnlyTimecodeControlAsString(), other.audioOnlyTimecodeControlAsString()) && Objects.equals(this.certificateModeAsString(), other.certificateModeAsString()) && Objects.equals(this.connectionRetryInterval(), other.connectionRetryInterval()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.eventId(), other.eventId()) && Objects.equals(this.eventIdModeAsString(), other.eventIdModeAsString()) && Objects.equals(this.eventStopBehaviorAsString(), other.eventStopBehaviorAsString()) && Objects.equals(this.filecacheDuration(), other.filecacheDuration()) && Objects.equals(this.fragmentLength(), other.fragmentLength()) && Objects.equals(this.inputLossActionAsString(), other.inputLossActionAsString()) && Objects.equals(this.numRetries(), other.numRetries()) && Objects.equals(this.restartDelay(), other.restartDelay()) && Objects.equals(this.segmentationModeAsString(), other.segmentationModeAsString()) && Objects.equals(this.sendDelayMs(), other.sendDelayMs()) && Objects.equals(this.sparseTrackTypeAsString(), other.sparseTrackTypeAsString()) && Objects.equals(this.streamManifestBehaviorAsString(), other.streamManifestBehaviorAsString()) && Objects.equals(this.timestampOffset(), other.timestampOffset()) && Objects.equals(this.timestampOffsetModeAsString(), other.timestampOffsetModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"MsSmoothGroupSettings").add("AcquisitionPointId", (Object)this.acquisitionPointId()).add("AudioOnlyTimecodeControl", (Object)this.audioOnlyTimecodeControlAsString()).add("CertificateMode", (Object)this.certificateModeAsString()).add("ConnectionRetryInterval", (Object)this.connectionRetryInterval()).add("Destination", (Object)this.destination()).add("EventId", (Object)this.eventId()).add("EventIdMode", (Object)this.eventIdModeAsString()).add("EventStopBehavior", (Object)this.eventStopBehaviorAsString()).add("FilecacheDuration", (Object)this.filecacheDuration()).add("FragmentLength", (Object)this.fragmentLength()).add("InputLossAction", (Object)this.inputLossActionAsString()).add("NumRetries", (Object)this.numRetries()).add("RestartDelay", (Object)this.restartDelay()).add("SegmentationMode", (Object)this.segmentationModeAsString()).add("SendDelayMs", (Object)this.sendDelayMs()).add("SparseTrackType", (Object)this.sparseTrackTypeAsString()).add("StreamManifestBehavior", (Object)this.streamManifestBehaviorAsString()).add("TimestampOffset", (Object)this.timestampOffset()).add("TimestampOffsetMode", (Object)this.timestampOffsetModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcquisitionPointId": {
                return Optional.ofNullable(clazz.cast(this.acquisitionPointId()));
            }
            case "AudioOnlyTimecodeControl": {
                return Optional.ofNullable(clazz.cast(this.audioOnlyTimecodeControlAsString()));
            }
            case "CertificateMode": {
                return Optional.ofNullable(clazz.cast(this.certificateModeAsString()));
            }
            case "ConnectionRetryInterval": {
                return Optional.ofNullable(clazz.cast(this.connectionRetryInterval()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "EventId": {
                return Optional.ofNullable(clazz.cast(this.eventId()));
            }
            case "EventIdMode": {
                return Optional.ofNullable(clazz.cast(this.eventIdModeAsString()));
            }
            case "EventStopBehavior": {
                return Optional.ofNullable(clazz.cast(this.eventStopBehaviorAsString()));
            }
            case "FilecacheDuration": {
                return Optional.ofNullable(clazz.cast(this.filecacheDuration()));
            }
            case "FragmentLength": {
                return Optional.ofNullable(clazz.cast(this.fragmentLength()));
            }
            case "InputLossAction": {
                return Optional.ofNullable(clazz.cast(this.inputLossActionAsString()));
            }
            case "NumRetries": {
                return Optional.ofNullable(clazz.cast(this.numRetries()));
            }
            case "RestartDelay": {
                return Optional.ofNullable(clazz.cast(this.restartDelay()));
            }
            case "SegmentationMode": {
                return Optional.ofNullable(clazz.cast(this.segmentationModeAsString()));
            }
            case "SendDelayMs": {
                return Optional.ofNullable(clazz.cast(this.sendDelayMs()));
            }
            case "SparseTrackType": {
                return Optional.ofNullable(clazz.cast(this.sparseTrackTypeAsString()));
            }
            case "StreamManifestBehavior": {
                return Optional.ofNullable(clazz.cast(this.streamManifestBehaviorAsString()));
            }
            case "TimestampOffset": {
                return Optional.ofNullable(clazz.cast(this.timestampOffset()));
            }
            case "TimestampOffsetMode": {
                return Optional.ofNullable(clazz.cast(this.timestampOffsetModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MsSmoothGroupSettings, T> g) {
        return obj -> g.apply((MsSmoothGroupSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String acquisitionPointId;
        private String audioOnlyTimecodeControl;
        private String certificateMode;
        private Integer connectionRetryInterval;
        private OutputLocationRef destination;
        private String eventId;
        private String eventIdMode;
        private String eventStopBehavior;
        private Integer filecacheDuration;
        private Integer fragmentLength;
        private String inputLossAction;
        private Integer numRetries;
        private Integer restartDelay;
        private String segmentationMode;
        private Integer sendDelayMs;
        private String sparseTrackType;
        private String streamManifestBehavior;
        private String timestampOffset;
        private String timestampOffsetMode;

        private BuilderImpl() {
        }

        private BuilderImpl(MsSmoothGroupSettings model) {
            this.acquisitionPointId(model.acquisitionPointId);
            this.audioOnlyTimecodeControl(model.audioOnlyTimecodeControl);
            this.certificateMode(model.certificateMode);
            this.connectionRetryInterval(model.connectionRetryInterval);
            this.destination(model.destination);
            this.eventId(model.eventId);
            this.eventIdMode(model.eventIdMode);
            this.eventStopBehavior(model.eventStopBehavior);
            this.filecacheDuration(model.filecacheDuration);
            this.fragmentLength(model.fragmentLength);
            this.inputLossAction(model.inputLossAction);
            this.numRetries(model.numRetries);
            this.restartDelay(model.restartDelay);
            this.segmentationMode(model.segmentationMode);
            this.sendDelayMs(model.sendDelayMs);
            this.sparseTrackType(model.sparseTrackType);
            this.streamManifestBehavior(model.streamManifestBehavior);
            this.timestampOffset(model.timestampOffset);
            this.timestampOffsetMode(model.timestampOffsetMode);
        }

        public final String getAcquisitionPointId() {
            return this.acquisitionPointId;
        }

        @Override
        public final Builder acquisitionPointId(String acquisitionPointId) {
            this.acquisitionPointId = acquisitionPointId;
            return this;
        }

        public final void setAcquisitionPointId(String acquisitionPointId) {
            this.acquisitionPointId = acquisitionPointId;
        }

        public final String getAudioOnlyTimecodeControl() {
            return this.audioOnlyTimecodeControl;
        }

        @Override
        public final Builder audioOnlyTimecodeControl(String audioOnlyTimecodeControl) {
            this.audioOnlyTimecodeControl = audioOnlyTimecodeControl;
            return this;
        }

        @Override
        public final Builder audioOnlyTimecodeControl(SmoothGroupAudioOnlyTimecodeControl audioOnlyTimecodeControl) {
            this.audioOnlyTimecodeControl(audioOnlyTimecodeControl == null ? null : audioOnlyTimecodeControl.toString());
            return this;
        }

        public final void setAudioOnlyTimecodeControl(String audioOnlyTimecodeControl) {
            this.audioOnlyTimecodeControl = audioOnlyTimecodeControl;
        }

        public final String getCertificateMode() {
            return this.certificateMode;
        }

        @Override
        public final Builder certificateMode(String certificateMode) {
            this.certificateMode = certificateMode;
            return this;
        }

        @Override
        public final Builder certificateMode(SmoothGroupCertificateMode certificateMode) {
            this.certificateMode(certificateMode == null ? null : certificateMode.toString());
            return this;
        }

        public final void setCertificateMode(String certificateMode) {
            this.certificateMode = certificateMode;
        }

        public final Integer getConnectionRetryInterval() {
            return this.connectionRetryInterval;
        }

        @Override
        public final Builder connectionRetryInterval(Integer connectionRetryInterval) {
            this.connectionRetryInterval = connectionRetryInterval;
            return this;
        }

        public final void setConnectionRetryInterval(Integer connectionRetryInterval) {
            this.connectionRetryInterval = connectionRetryInterval;
        }

        public final OutputLocationRef.Builder getDestination() {
            return this.destination != null ? this.destination.toBuilder() : null;
        }

        @Override
        public final Builder destination(OutputLocationRef destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(OutputLocationRef.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        public final String getEventId() {
            return this.eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        public final String getEventIdMode() {
            return this.eventIdMode;
        }

        @Override
        public final Builder eventIdMode(String eventIdMode) {
            this.eventIdMode = eventIdMode;
            return this;
        }

        @Override
        public final Builder eventIdMode(SmoothGroupEventIdMode eventIdMode) {
            this.eventIdMode(eventIdMode == null ? null : eventIdMode.toString());
            return this;
        }

        public final void setEventIdMode(String eventIdMode) {
            this.eventIdMode = eventIdMode;
        }

        public final String getEventStopBehavior() {
            return this.eventStopBehavior;
        }

        @Override
        public final Builder eventStopBehavior(String eventStopBehavior) {
            this.eventStopBehavior = eventStopBehavior;
            return this;
        }

        @Override
        public final Builder eventStopBehavior(SmoothGroupEventStopBehavior eventStopBehavior) {
            this.eventStopBehavior(eventStopBehavior == null ? null : eventStopBehavior.toString());
            return this;
        }

        public final void setEventStopBehavior(String eventStopBehavior) {
            this.eventStopBehavior = eventStopBehavior;
        }

        public final Integer getFilecacheDuration() {
            return this.filecacheDuration;
        }

        @Override
        public final Builder filecacheDuration(Integer filecacheDuration) {
            this.filecacheDuration = filecacheDuration;
            return this;
        }

        public final void setFilecacheDuration(Integer filecacheDuration) {
            this.filecacheDuration = filecacheDuration;
        }

        public final Integer getFragmentLength() {
            return this.fragmentLength;
        }

        @Override
        public final Builder fragmentLength(Integer fragmentLength) {
            this.fragmentLength = fragmentLength;
            return this;
        }

        public final void setFragmentLength(Integer fragmentLength) {
            this.fragmentLength = fragmentLength;
        }

        public final String getInputLossAction() {
            return this.inputLossAction;
        }

        @Override
        public final Builder inputLossAction(String inputLossAction) {
            this.inputLossAction = inputLossAction;
            return this;
        }

        @Override
        public final Builder inputLossAction(InputLossActionForMsSmoothOut inputLossAction) {
            this.inputLossAction(inputLossAction == null ? null : inputLossAction.toString());
            return this;
        }

        public final void setInputLossAction(String inputLossAction) {
            this.inputLossAction = inputLossAction;
        }

        public final Integer getNumRetries() {
            return this.numRetries;
        }

        @Override
        public final Builder numRetries(Integer numRetries) {
            this.numRetries = numRetries;
            return this;
        }

        public final void setNumRetries(Integer numRetries) {
            this.numRetries = numRetries;
        }

        public final Integer getRestartDelay() {
            return this.restartDelay;
        }

        @Override
        public final Builder restartDelay(Integer restartDelay) {
            this.restartDelay = restartDelay;
            return this;
        }

        public final void setRestartDelay(Integer restartDelay) {
            this.restartDelay = restartDelay;
        }

        public final String getSegmentationMode() {
            return this.segmentationMode;
        }

        @Override
        public final Builder segmentationMode(String segmentationMode) {
            this.segmentationMode = segmentationMode;
            return this;
        }

        @Override
        public final Builder segmentationMode(SmoothGroupSegmentationMode segmentationMode) {
            this.segmentationMode(segmentationMode == null ? null : segmentationMode.toString());
            return this;
        }

        public final void setSegmentationMode(String segmentationMode) {
            this.segmentationMode = segmentationMode;
        }

        public final Integer getSendDelayMs() {
            return this.sendDelayMs;
        }

        @Override
        public final Builder sendDelayMs(Integer sendDelayMs) {
            this.sendDelayMs = sendDelayMs;
            return this;
        }

        public final void setSendDelayMs(Integer sendDelayMs) {
            this.sendDelayMs = sendDelayMs;
        }

        public final String getSparseTrackType() {
            return this.sparseTrackType;
        }

        @Override
        public final Builder sparseTrackType(String sparseTrackType) {
            this.sparseTrackType = sparseTrackType;
            return this;
        }

        @Override
        public final Builder sparseTrackType(SmoothGroupSparseTrackType sparseTrackType) {
            this.sparseTrackType(sparseTrackType == null ? null : sparseTrackType.toString());
            return this;
        }

        public final void setSparseTrackType(String sparseTrackType) {
            this.sparseTrackType = sparseTrackType;
        }

        public final String getStreamManifestBehavior() {
            return this.streamManifestBehavior;
        }

        @Override
        public final Builder streamManifestBehavior(String streamManifestBehavior) {
            this.streamManifestBehavior = streamManifestBehavior;
            return this;
        }

        @Override
        public final Builder streamManifestBehavior(SmoothGroupStreamManifestBehavior streamManifestBehavior) {
            this.streamManifestBehavior(streamManifestBehavior == null ? null : streamManifestBehavior.toString());
            return this;
        }

        public final void setStreamManifestBehavior(String streamManifestBehavior) {
            this.streamManifestBehavior = streamManifestBehavior;
        }

        public final String getTimestampOffset() {
            return this.timestampOffset;
        }

        @Override
        public final Builder timestampOffset(String timestampOffset) {
            this.timestampOffset = timestampOffset;
            return this;
        }

        public final void setTimestampOffset(String timestampOffset) {
            this.timestampOffset = timestampOffset;
        }

        public final String getTimestampOffsetMode() {
            return this.timestampOffsetMode;
        }

        @Override
        public final Builder timestampOffsetMode(String timestampOffsetMode) {
            this.timestampOffsetMode = timestampOffsetMode;
            return this;
        }

        @Override
        public final Builder timestampOffsetMode(SmoothGroupTimestampOffsetMode timestampOffsetMode) {
            this.timestampOffsetMode(timestampOffsetMode == null ? null : timestampOffsetMode.toString());
            return this;
        }

        public final void setTimestampOffsetMode(String timestampOffsetMode) {
            this.timestampOffsetMode = timestampOffsetMode;
        }

        public MsSmoothGroupSettings build() {
            return new MsSmoothGroupSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MsSmoothGroupSettings> {
        public Builder acquisitionPointId(String var1);

        public Builder audioOnlyTimecodeControl(String var1);

        public Builder audioOnlyTimecodeControl(SmoothGroupAudioOnlyTimecodeControl var1);

        public Builder certificateMode(String var1);

        public Builder certificateMode(SmoothGroupCertificateMode var1);

        public Builder connectionRetryInterval(Integer var1);

        public Builder destination(OutputLocationRef var1);

        default public Builder destination(Consumer<OutputLocationRef.Builder> destination) {
            return this.destination((OutputLocationRef)((OutputLocationRef.Builder)OutputLocationRef.builder().applyMutation(destination)).build());
        }

        public Builder eventId(String var1);

        public Builder eventIdMode(String var1);

        public Builder eventIdMode(SmoothGroupEventIdMode var1);

        public Builder eventStopBehavior(String var1);

        public Builder eventStopBehavior(SmoothGroupEventStopBehavior var1);

        public Builder filecacheDuration(Integer var1);

        public Builder fragmentLength(Integer var1);

        public Builder inputLossAction(String var1);

        public Builder inputLossAction(InputLossActionForMsSmoothOut var1);

        public Builder numRetries(Integer var1);

        public Builder restartDelay(Integer var1);

        public Builder segmentationMode(String var1);

        public Builder segmentationMode(SmoothGroupSegmentationMode var1);

        public Builder sendDelayMs(Integer var1);

        public Builder sparseTrackType(String var1);

        public Builder sparseTrackType(SmoothGroupSparseTrackType var1);

        public Builder streamManifestBehavior(String var1);

        public Builder streamManifestBehavior(SmoothGroupStreamManifestBehavior var1);

        public Builder timestampOffset(String var1);

        public Builder timestampOffsetMode(String var1);

        public Builder timestampOffsetMode(SmoothGroupTimestampOffsetMode var1);
    }
}

