/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.BatchScheduleActionCreateResult;
import software.amazon.awssdk.services.medialive.model.BatchScheduleActionDeleteResult;
import software.amazon.awssdk.services.medialive.model.MediaLiveResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchUpdateScheduleResponse
extends MediaLiveResponse
implements ToCopyableBuilder<Builder, BatchUpdateScheduleResponse> {
    private static final SdkField<BatchScheduleActionCreateResult> CREATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Creates").getter(BatchUpdateScheduleResponse.getter(BatchUpdateScheduleResponse::creates)).setter(BatchUpdateScheduleResponse.setter(Builder::creates)).constructor(BatchScheduleActionCreateResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creates").build()}).build();
    private static final SdkField<BatchScheduleActionDeleteResult> DELETES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Deletes").getter(BatchUpdateScheduleResponse.getter(BatchUpdateScheduleResponse::deletes)).setter(BatchUpdateScheduleResponse.setter(Builder::deletes)).constructor(BatchScheduleActionDeleteResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deletes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATES_FIELD, DELETES_FIELD));
    private final BatchScheduleActionCreateResult creates;
    private final BatchScheduleActionDeleteResult deletes;

    private BatchUpdateScheduleResponse(BuilderImpl builder) {
        super(builder);
        this.creates = builder.creates;
        this.deletes = builder.deletes;
    }

    public final BatchScheduleActionCreateResult creates() {
        return this.creates;
    }

    public final BatchScheduleActionDeleteResult deletes() {
        return this.deletes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.creates());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateScheduleResponse)) {
            return false;
        }
        BatchUpdateScheduleResponse other = (BatchUpdateScheduleResponse)((Object)obj);
        return Objects.equals(this.creates(), other.creates()) && Objects.equals(this.deletes(), other.deletes());
    }

    public final String toString() {
        return ToString.builder((String)"BatchUpdateScheduleResponse").add("Creates", (Object)this.creates()).add("Deletes", (Object)this.deletes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Creates": {
                return Optional.ofNullable(clazz.cast(this.creates()));
            }
            case "Deletes": {
                return Optional.ofNullable(clazz.cast(this.deletes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateScheduleResponse, T> g) {
        return obj -> g.apply((BatchUpdateScheduleResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveResponse.BuilderImpl
    implements Builder {
        private BatchScheduleActionCreateResult creates;
        private BatchScheduleActionDeleteResult deletes;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateScheduleResponse model) {
            super(model);
            this.creates(model.creates);
            this.deletes(model.deletes);
        }

        public final BatchScheduleActionCreateResult.Builder getCreates() {
            return this.creates != null ? this.creates.toBuilder() : null;
        }

        @Override
        public final Builder creates(BatchScheduleActionCreateResult creates) {
            this.creates = creates;
            return this;
        }

        public final void setCreates(BatchScheduleActionCreateResult.BuilderImpl creates) {
            this.creates = creates != null ? creates.build() : null;
        }

        public final BatchScheduleActionDeleteResult.Builder getDeletes() {
            return this.deletes != null ? this.deletes.toBuilder() : null;
        }

        @Override
        public final Builder deletes(BatchScheduleActionDeleteResult deletes) {
            this.deletes = deletes;
            return this;
        }

        public final void setDeletes(BatchScheduleActionDeleteResult.BuilderImpl deletes) {
            this.deletes = deletes != null ? deletes.build() : null;
        }

        @Override
        public BatchUpdateScheduleResponse build() {
            return new BatchUpdateScheduleResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaLiveResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchUpdateScheduleResponse> {
        public Builder creates(BatchScheduleActionCreateResult var1);

        default public Builder creates(Consumer<BatchScheduleActionCreateResult.Builder> creates) {
            return this.creates((BatchScheduleActionCreateResult)((BatchScheduleActionCreateResult.Builder)BatchScheduleActionCreateResult.builder().applyMutation(creates)).build());
        }

        public Builder deletes(BatchScheduleActionDeleteResult var1);

        default public Builder deletes(Consumer<BatchScheduleActionDeleteResult.Builder> deletes) {
            return this.deletes((BatchScheduleActionDeleteResult)((BatchScheduleActionDeleteResult.Builder)BatchScheduleActionDeleteResult.builder().applyMutation(deletes)).build());
        }
    }
}

