/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.MediaLiveRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteMultiplexProgramRequest
extends MediaLiveRequest
implements ToCopyableBuilder<Builder, DeleteMultiplexProgramRequest> {
    private static final SdkField<String> MULTIPLEX_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MultiplexId").getter(DeleteMultiplexProgramRequest.getter(DeleteMultiplexProgramRequest::multiplexId)).setter(DeleteMultiplexProgramRequest.setter(Builder::multiplexId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("multiplexId").build()}).build();
    private static final SdkField<String> PROGRAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProgramName").getter(DeleteMultiplexProgramRequest.getter(DeleteMultiplexProgramRequest::programName)).setter(DeleteMultiplexProgramRequest.setter(Builder::programName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("programName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MULTIPLEX_ID_FIELD, PROGRAM_NAME_FIELD));
    private final String multiplexId;
    private final String programName;

    private DeleteMultiplexProgramRequest(BuilderImpl builder) {
        super(builder);
        this.multiplexId = builder.multiplexId;
        this.programName = builder.programName;
    }

    public final String multiplexId() {
        return this.multiplexId;
    }

    public final String programName() {
        return this.programName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.multiplexId());
        hashCode = 31 * hashCode + Objects.hashCode(this.programName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteMultiplexProgramRequest)) {
            return false;
        }
        DeleteMultiplexProgramRequest other = (DeleteMultiplexProgramRequest)((Object)obj);
        return Objects.equals(this.multiplexId(), other.multiplexId()) && Objects.equals(this.programName(), other.programName());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteMultiplexProgramRequest").add("MultiplexId", (Object)this.multiplexId()).add("ProgramName", (Object)this.programName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MultiplexId": {
                return Optional.ofNullable(clazz.cast(this.multiplexId()));
            }
            case "ProgramName": {
                return Optional.ofNullable(clazz.cast(this.programName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteMultiplexProgramRequest, T> g) {
        return obj -> g.apply((DeleteMultiplexProgramRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveRequest.BuilderImpl
    implements Builder {
        private String multiplexId;
        private String programName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteMultiplexProgramRequest model) {
            super(model);
            this.multiplexId(model.multiplexId);
            this.programName(model.programName);
        }

        public final String getMultiplexId() {
            return this.multiplexId;
        }

        @Override
        public final Builder multiplexId(String multiplexId) {
            this.multiplexId = multiplexId;
            return this;
        }

        public final void setMultiplexId(String multiplexId) {
            this.multiplexId = multiplexId;
        }

        public final String getProgramName() {
            return this.programName;
        }

        @Override
        public final Builder programName(String programName) {
            this.programName = programName;
            return this;
        }

        public final void setProgramName(String programName) {
            this.programName = programName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteMultiplexProgramRequest build() {
            return new DeleteMultiplexProgramRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaLiveRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteMultiplexProgramRequest> {
        public Builder multiplexId(String var1);

        public Builder programName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

