/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ChannelState {
    CREATING("CREATING"),
    CREATE_FAILED("CREATE_FAILED"),
    IDLE("IDLE"),
    STARTING("STARTING"),
    RUNNING("RUNNING"),
    RECOVERING("RECOVERING"),
    STOPPING("STOPPING"),
    DELETING("DELETING"),
    DELETED("DELETED"),
    UPDATING("UPDATING"),
    UPDATE_FAILED("UPDATE_FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ChannelState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ChannelState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ChannelState.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ChannelState> knownValues() {
        return Stream.of(ChannelState.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

