/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.NielsenPcmToId3TaggingState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NielsenConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NielsenConfiguration> {
    private static final SdkField<String> DISTRIBUTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DistributorId").getter(NielsenConfiguration.getter(NielsenConfiguration::distributorId)).setter(NielsenConfiguration.setter(Builder::distributorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distributorId").build()}).build();
    private static final SdkField<String> NIELSEN_PCM_TO_ID3_TAGGING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NielsenPcmToId3Tagging").getter(NielsenConfiguration.getter(NielsenConfiguration::nielsenPcmToId3TaggingAsString)).setter(NielsenConfiguration.setter(Builder::nielsenPcmToId3Tagging)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nielsenPcmToId3Tagging").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISTRIBUTOR_ID_FIELD, NIELSEN_PCM_TO_ID3_TAGGING_FIELD));
    private static final long serialVersionUID = 1L;
    private final String distributorId;
    private final String nielsenPcmToId3Tagging;

    private NielsenConfiguration(BuilderImpl builder) {
        this.distributorId = builder.distributorId;
        this.nielsenPcmToId3Tagging = builder.nielsenPcmToId3Tagging;
    }

    public final String distributorId() {
        return this.distributorId;
    }

    public final NielsenPcmToId3TaggingState nielsenPcmToId3Tagging() {
        return NielsenPcmToId3TaggingState.fromValue(this.nielsenPcmToId3Tagging);
    }

    public final String nielsenPcmToId3TaggingAsString() {
        return this.nielsenPcmToId3Tagging;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.distributorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nielsenPcmToId3TaggingAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NielsenConfiguration)) {
            return false;
        }
        NielsenConfiguration other = (NielsenConfiguration)obj;
        return Objects.equals(this.distributorId(), other.distributorId()) && Objects.equals(this.nielsenPcmToId3TaggingAsString(), other.nielsenPcmToId3TaggingAsString());
    }

    public final String toString() {
        return ToString.builder((String)"NielsenConfiguration").add("DistributorId", (Object)this.distributorId()).add("NielsenPcmToId3Tagging", (Object)this.nielsenPcmToId3TaggingAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DistributorId": {
                return Optional.ofNullable(clazz.cast(this.distributorId()));
            }
            case "NielsenPcmToId3Tagging": {
                return Optional.ofNullable(clazz.cast(this.nielsenPcmToId3TaggingAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NielsenConfiguration, T> g) {
        return obj -> g.apply((NielsenConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String distributorId;
        private String nielsenPcmToId3Tagging;

        private BuilderImpl() {
        }

        private BuilderImpl(NielsenConfiguration model) {
            this.distributorId(model.distributorId);
            this.nielsenPcmToId3Tagging(model.nielsenPcmToId3Tagging);
        }

        public final String getDistributorId() {
            return this.distributorId;
        }

        @Override
        public final Builder distributorId(String distributorId) {
            this.distributorId = distributorId;
            return this;
        }

        public final void setDistributorId(String distributorId) {
            this.distributorId = distributorId;
        }

        public final String getNielsenPcmToId3Tagging() {
            return this.nielsenPcmToId3Tagging;
        }

        @Override
        public final Builder nielsenPcmToId3Tagging(String nielsenPcmToId3Tagging) {
            this.nielsenPcmToId3Tagging = nielsenPcmToId3Tagging;
            return this;
        }

        @Override
        public final Builder nielsenPcmToId3Tagging(NielsenPcmToId3TaggingState nielsenPcmToId3Tagging) {
            this.nielsenPcmToId3Tagging(nielsenPcmToId3Tagging == null ? null : nielsenPcmToId3Tagging.toString());
            return this;
        }

        public final void setNielsenPcmToId3Tagging(String nielsenPcmToId3Tagging) {
            this.nielsenPcmToId3Tagging = nielsenPcmToId3Tagging;
        }

        public NielsenConfiguration build() {
            return new NielsenConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NielsenConfiguration> {
        public Builder distributorId(String var1);

        public Builder nielsenPcmToId3Tagging(String var1);

        public Builder nielsenPcmToId3Tagging(NielsenPcmToId3TaggingState var1);
    }
}

